/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import java.util.Arrays;
import java.util.List;
import org.jcvi.jillion.align.NucleotideSequenceAlignment;
import org.jcvi.jillion.align.ProteinSequenceAlignment;
import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.align.pairwise.NucleotidePairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.NucleotidePairwiseSequenceAlignmentImpl;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.ProteinPairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.ProteinPairwiseSequenceAlignmentImpl;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.align.NucleotideSequenceAlignmentBuilder;
import org.jcvi.jillion.internal.align.ProteinSequenceAlignmentBuilder;
import org.jcvi.jillion.internal.align.SequenceAlignmentBuilder;

abstract class ResiduePairwiseStrategy<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>, A extends SequenceAlignment<R, S>, P extends PairwiseSequenceAlignment<R, S>> {
    ResiduePairwiseStrategy() {
    }

    public static ResiduePairwiseStrategy<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideSequenceAlignment, NucleotidePairwiseSequenceAlignment> getNucleotideStrategy() {
        return NucleotidePairwiseStrategy.INSTANCE;
    }

    public static ResiduePairwiseStrategy<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinSequenceAlignment, ProteinPairwiseSequenceAlignment> getAminoAcidStrategy() {
        return ProteinPairwiseStrategy.INSTANCE;
    }

    protected abstract List<R> getResidueList();

    protected abstract P wrapPairwiseAlignment(PairwiseSequenceAlignment<R, S> var1);

    protected abstract R getGap();

    protected abstract SequenceAlignmentBuilder<R, S, B, A> createSequenceAlignmentBuilder(boolean var1, Integer var2);

    private static final class ProteinPairwiseStrategy
    extends ResiduePairwiseStrategy<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinSequenceAlignment, ProteinPairwiseSequenceAlignment> {
        private static final ProteinPairwiseStrategy INSTANCE = new ProteinPairwiseStrategy();

        private ProteinPairwiseStrategy() {
        }

        @Override
        protected List<AminoAcid> getResidueList() {
            return Arrays.asList(AminoAcid.values());
        }

        @Override
        protected ProteinPairwiseSequenceAlignment wrapPairwiseAlignment(PairwiseSequenceAlignment<AminoAcid, ProteinSequence> alignment) {
            return new ProteinPairwiseSequenceAlignmentImpl(alignment);
        }

        @Override
        protected AminoAcid getGap() {
            return AminoAcid.Gap;
        }

        @Override
        protected SequenceAlignmentBuilder<AminoAcid, ProteinSequence, ProteinSequenceBuilder, ProteinSequenceAlignment> createSequenceAlignmentBuilder(boolean builtFromTraceback, Integer subjectShiftAmount) {
            return new ProteinSequenceAlignmentBuilder(builtFromTraceback, subjectShiftAmount);
        }
    }

    private static final class NucleotidePairwiseStrategy
    extends ResiduePairwiseStrategy<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideSequenceAlignment, NucleotidePairwiseSequenceAlignment> {
        private static final NucleotidePairwiseStrategy INSTANCE = new NucleotidePairwiseStrategy();

        private NucleotidePairwiseStrategy() {
        }

        @Override
        protected List<Nucleotide> getResidueList() {
            return Nucleotide.getAllValues();
        }

        @Override
        protected NucleotidePairwiseSequenceAlignment wrapPairwiseAlignment(PairwiseSequenceAlignment<Nucleotide, NucleotideSequence> alignment) {
            return new NucleotidePairwiseSequenceAlignmentImpl(alignment);
        }

        @Override
        protected Nucleotide getGap() {
            return Nucleotide.Gap;
        }

        @Override
        protected SequenceAlignmentBuilder<Nucleotide, NucleotideSequence, NucleotideSequenceBuilder, NucleotideSequenceAlignment> createSequenceAlignmentBuilder(boolean builtFromTraceback, Integer subjectShiftAmount) {
            return new NucleotideSequenceAlignmentBuilder(builtFromTraceback, subjectShiftAmount);
        }
    }
}

