/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;

final class PairwiseSequenceAlignmentWrapper<R extends Residue, S extends ResidueSequence<R, S, ?>, A extends SequenceAlignment<R, S>>
implements PairwiseSequenceAlignment<R, S> {
    private final A delegate;
    private final float score;

    public static <R extends Residue, S extends ResidueSequence<R, S, ?>, A extends SequenceAlignment<R, S>> PairwiseSequenceAlignment<R, S> wrap(A alignment, float score) {
        return new PairwiseSequenceAlignmentWrapper<R, S, A>(alignment, score);
    }

    private PairwiseSequenceAlignmentWrapper(A delegate, float score) {
        this.delegate = delegate;
        this.score = score;
    }

    @Override
    public double getPercentIdentity() {
        return this.delegate.getPercentIdentity();
    }

    @Override
    public int getAlignmentLength() {
        return this.delegate.getAlignmentLength();
    }

    @Override
    public int getNumberOfMismatches() {
        return this.delegate.getNumberOfMismatches();
    }

    @Override
    public int getNumberOfGapOpenings() {
        return this.delegate.getNumberOfGapOpenings();
    }

    @Override
    public S getGappedQueryAlignment() {
        return this.delegate.getGappedQueryAlignment();
    }

    @Override
    public S getGappedSubjectAlignment() {
        return this.delegate.getGappedSubjectAlignment();
    }

    @Override
    public DirectedRange getQueryRange() {
        return this.delegate.getQueryRange();
    }

    @Override
    public DirectedRange getSubjectRange() {
        return this.delegate.getSubjectRange();
    }

    @Override
    public float getScore() {
        return this.score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        result = 31 * result + Float.floatToIntBits(this.score);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PairwiseSequenceAlignmentWrapper other = (PairwiseSequenceAlignmentWrapper)obj;
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return Float.floatToIntBits(this.score) == Float.floatToIntBits(other.score);
    }

    public String toString() {
        return "PairwiseSequenceAlignmentWrapper [delegate=" + this.delegate + ", score=" + this.score + "]";
    }
}

