/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jcvi.jillion.align.AminoAcidSubstitutionMatrix;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.align.SubstitutionMatrix;
import org.jcvi.jillion.align.pairwise.NucleotideNeedlemanWunschAligner;
import org.jcvi.jillion.align.pairwise.NucleotidePairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.NucleotideSmithWatermanAligner;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.ProteinNeedlemanWunschAligner;
import org.jcvi.jillion.align.pairwise.ProteinPairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.ProteinSmithWatermanAligner;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public final class PairwiseAlignmentBuilder<R extends Residue, S extends ResidueSequence<R, S, ?>, A extends PairwiseSequenceAlignment<R, S>> {
    private final S query;
    private final S subject;
    private final SubstitutionMatrix<R> matrix;
    private float gapOpen = 0.0f;
    private float gapExtension = 0.0f;
    private boolean local = true;

    public static PairwiseAlignmentBuilder<Nucleotide, NucleotideSequence, NucleotidePairwiseSequenceAlignment> createNucleotideAlignmentBuilder(NucleotideSequence query, NucleotideSequence subject, NucleotideSubstitutionMatrix matrix) {
        return new PairwiseAlignmentBuilder<Nucleotide, NucleotideSequence, NucleotidePairwiseSequenceAlignment>(query, subject, matrix);
    }

    public static PairwiseAlignmentBuilder<AminoAcid, ProteinSequence, ProteinPairwiseSequenceAlignment> createProtienAlignmentBuilder(ProteinSequence query, ProteinSequence subject, AminoAcidSubstitutionMatrix matrix) {
        return new PairwiseAlignmentBuilder<AminoAcid, ProteinSequence, ProteinPairwiseSequenceAlignment>(query, subject, matrix);
    }

    private PairwiseAlignmentBuilder(S query, S subject, SubstitutionMatrix<R> matrix) {
        if (query == null) {
            throw new NullPointerException("query can not be null");
        }
        if (subject == null) {
            throw new NullPointerException("subject can not be null");
        }
        if (matrix == null) {
            throw new NullPointerException("matrix can not be null");
        }
        this.query = query;
        this.subject = subject;
        this.matrix = matrix;
    }

    public PairwiseAlignmentBuilder<R, S, A> gapPenalty(float open) {
        return this.gapPenalty(open, 0.0f);
    }

    public PairwiseAlignmentBuilder<R, S, A> gapPenalty(float open, float extension) {
        this.gapOpen = open;
        this.gapExtension = extension;
        return this;
    }

    public PairwiseAlignmentBuilder<R, S, A> useGlobalAlignment() {
        this.local = false;
        return this;
    }

    public PairwiseAlignmentBuilder<R, S, A> useLocalAlignment() {
        this.local = true;
        return this;
    }

    public A build() {
        if (this.query instanceof NucleotideSequence) {
            if (this.local) {
                return (A)NucleotideSmithWatermanAligner.align((NucleotideSequence)this.query, (NucleotideSequence)this.subject, (NucleotideSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension);
            }
            return (A)NucleotideNeedlemanWunschAligner.align((NucleotideSequence)this.query, (NucleotideSequence)this.subject, (NucleotideSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension);
        }
        if (this.local) {
            return (A)ProteinSmithWatermanAligner.align((ProteinSequence)this.query, (ProteinSequence)this.subject, (AminoAcidSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension);
        }
        return (A)ProteinNeedlemanWunschAligner.align((ProteinSequence)this.query, (ProteinSequence)this.subject, (AminoAcidSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension);
    }

    public Stream<A> findMultiple() {
        if (!this.local) {
            return Stream.of(this.build());
        }
        ArrayList list = new ArrayList();
        if (this.query instanceof NucleotideSequence) {
            this.findMultiple((NucleotideSequence)this.subject, 0, list::add);
        } else {
            this.findMultiple((ProteinSequence)this.subject, 0, list::add);
        }
        return list.stream();
    }

    private void findMultiple(NucleotideSequence currentSubject, int currentShift, Consumer<A> consumer) {
        if (currentSubject.getLength() < this.query.getLength()) {
            return;
        }
        NucleotidePairwiseSequenceAlignment alignment = NucleotideSmithWatermanAligner.align((NucleotideSequence)this.query, currentSubject, (NucleotideSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension, currentShift);
        consumer.accept(alignment);
        long endOfAlignment = alignment.getSubjectRange().getEnd() + 1L - (long)currentShift;
        long startOfAlignment = alignment.getSubjectRange().getBegin() - (long)currentShift;
        this.findMultiple(currentSubject.toBuilder().delete(Range.ofLength(endOfAlignment)).build(), (int)((long)currentShift + endOfAlignment), consumer);
        this.findMultiple(currentSubject.toBuilder().trim(Range.ofLength(startOfAlignment)).build(), currentShift, consumer);
    }

    private void findMultiple(ProteinSequence currentSubject, int currentShift, Consumer<A> consumer) {
        if (currentSubject.getLength() < this.query.getLength()) {
            return;
        }
        ProteinPairwiseSequenceAlignment alignment = ProteinSmithWatermanAligner.align((ProteinSequence)this.query, currentSubject, (AminoAcidSubstitutionMatrix)this.matrix, this.gapOpen, this.gapExtension, currentShift);
        consumer.accept(alignment);
        long endOfAlignment = alignment.getSubjectRange().getEnd() + 1L - (long)currentShift;
        long startOfAlignment = alignment.getSubjectRange().getBegin() - (long)currentShift;
        this.findMultiple(currentSubject.toBuilder().delete(Range.ofLength(endOfAlignment)).build(), (int)((long)currentShift + endOfAlignment), consumer);
        this.findMultiple(currentSubject.toBuilder().trim(Range.ofLength(startOfAlignment)).build(), currentShift, consumer);
    }

    public PairwiseAlignmentBuilder<R, S, A> useGlobalAlignment(boolean useGlobal) {
        if (useGlobal) {
            return this.useGlobalAlignment();
        }
        return this.useLocalAlignment();
    }

    public PairwiseAlignmentBuilder<R, S, A> useLocalAlignment(boolean useLocal) {
        if (useLocal) {
            return this.useLocalAlignment();
        }
        return this.useGlobalAlignment();
    }
}

