/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;

abstract class AbstractPairwiseSequenceAlignment<R extends Residue, S extends ResidueSequence<R, S, ?>>
implements PairwiseSequenceAlignment<R, S> {
    private final PairwiseSequenceAlignment<R, S> delegate;

    public AbstractPairwiseSequenceAlignment(PairwiseSequenceAlignment<R, S> delegate) {
        this.delegate = delegate;
    }

    @Override
    public double getPercentIdentity() {
        return this.delegate.getPercentIdentity();
    }

    @Override
    public int getAlignmentLength() {
        return this.delegate.getAlignmentLength();
    }

    @Override
    public int getNumberOfMismatches() {
        return this.delegate.getNumberOfMismatches();
    }

    @Override
    public int getNumberOfGapOpenings() {
        return this.delegate.getNumberOfGapOpenings();
    }

    @Override
    public S getGappedQueryAlignment() {
        return this.delegate.getGappedQueryAlignment();
    }

    @Override
    public S getGappedSubjectAlignment() {
        return this.delegate.getGappedSubjectAlignment();
    }

    @Override
    public DirectedRange getQueryRange() {
        return this.delegate.getQueryRange();
    }

    @Override
    public DirectedRange getSubjectRange() {
        return this.delegate.getSubjectRange();
    }

    @Override
    public float getScore() {
        return this.delegate.getScore();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getScore());
        result = 31 * result + this.getAlignmentLength();
        result = 31 * result + this.getNumberOfGapOpenings();
        result = 31 * result + this.getNumberOfMismatches();
        long temp = Double.doubleToLongBits(this.getPercentIdentity());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.getGappedQueryAlignment() == null ? 0 : this.getGappedQueryAlignment().hashCode());
        result = 31 * result + (this.getQueryRange() == null ? 0 : this.getQueryRange().hashCode());
        result = 31 * result + (this.getGappedSubjectAlignment() == null ? 0 : this.getGappedSubjectAlignment().hashCode());
        result = 31 * result + (this.getSubjectRange() == null ? 0 : this.getSubjectRange().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PairwiseSequenceAlignment)) {
            return false;
        }
        PairwiseSequenceAlignment other = (PairwiseSequenceAlignment)obj;
        if (Float.floatToIntBits(this.getScore()) != Float.floatToIntBits(other.getScore())) {
            return false;
        }
        if (this.getAlignmentLength() != other.getAlignmentLength()) {
            return false;
        }
        if (this.getNumberOfGapOpenings() != other.getNumberOfGapOpenings()) {
            return false;
        }
        if (this.getNumberOfMismatches() != other.getNumberOfMismatches()) {
            return false;
        }
        if (Double.doubleToLongBits(this.getPercentIdentity()) != Double.doubleToLongBits(other.getPercentIdentity())) {
            return false;
        }
        if (this.getGappedQueryAlignment() == null ? other.getGappedQueryAlignment() != null : !this.getGappedQueryAlignment().equals(other.getGappedQueryAlignment())) {
            return false;
        }
        if (!this.getQueryRange().equals(other.getQueryRange())) {
            return false;
        }
        if (!this.getGappedSubjectAlignment().equals(other.getGappedSubjectAlignment())) {
            return false;
        }
        return this.getSubjectRange().equals(other.getSubjectRange());
    }

    public String toString() {
        return "AbstractPairwiseSequenceAlignment [delegate=" + this.delegate + ", getAlignmentLength()=" + this.getAlignmentLength() + ", getPercentIdentity()=" + this.getPercentIdentity() + ", getScore()=" + this.getScore() + ", getNumberOfMismatches()=" + this.getNumberOfMismatches() + ", getNumberOfGapOpenings()=" + this.getNumberOfGapOpenings() + ", getGappedQueryAlignment()=" + this.getGappedQueryAlignment() + ", getGappedSubjectAlignment()=" + this.getGappedSubjectAlignment() + ", getQueryRange()=" + this.getQueryRange() + ", getSubjectRange()=" + this.getSubjectRange() + "]";
    }
}

