/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.align.SubstitutionMatrix;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignmentWrapper;
import org.jcvi.jillion.align.pairwise.ResiduePairwiseStrategy;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;
import org.jcvi.jillion.internal.align.SequenceAlignmentBuilder;

abstract class AbstractPairwiseAligner<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>, A extends SequenceAlignment<R, S>, P extends PairwiseSequenceAlignment<R, S>> {
    private final TraceBackMatrix traceback;
    private final float[][] scoreCache;
    private final BitSet[] inAVerticalGapCache;
    private final P alignment;
    private final ResiduePairwiseStrategy<R, S, B, A, P> pairwiseStrategy;
    private static final int PREVIOUS_ROW = 0;
    private static final int CURRENT_ROW = 1;
    private Integer subjectShiftAmount;

    protected AbstractPairwiseAligner(S query, S subject, SubstitutionMatrix<R> matrix, float openGapPenalty, float extendGapPenalty, ResiduePairwiseStrategy<R, S, B, A, P> pairwiseStrategy) {
        this(query, subject, matrix, openGapPenalty, extendGapPenalty, pairwiseStrategy, null);
    }

    protected AbstractPairwiseAligner(S query, S subject, SubstitutionMatrix<R> matrix, float openGapPenalty, float extendGapPenalty, ResiduePairwiseStrategy<R, S, B, A, P> pairwiseStrategy, Integer subjectShiftAmount) {
        this.checkNotNull((Sequence<R>)query, (Sequence<R>)subject, matrix);
        this.pairwiseStrategy = pairwiseStrategy;
        this.subjectShiftAmount = subjectShiftAmount;
        TracebackDirection initialRowDirection = this.getInitialRowTracebackValue();
        if (initialRowDirection == null) {
            throw new NullPointerException("initialRowDirection can not be null");
        }
        TracebackDirection initialColDirection = this.getInitialColTracebackValue();
        if (initialColDirection == null) {
            throw new NullPointerException("initialColDirection can not be null");
        }
        int ungappedSubjectLength = (int)subject.getUngappedLength();
        int ungappedQueryLength = (int)query.getUngappedLength();
        this.traceback = new TraceBackMatrix(ungappedQueryLength + 1, ungappedSubjectLength + 1, initialRowDirection, initialColDirection);
        this.scoreCache = new float[2][ungappedSubjectLength + 1];
        this.inAVerticalGapCache = new BitSet[2];
        this.initializeFields(openGapPenalty, extendGapPenalty);
        byte[] seq1Bytes = this.convertToUngappedByteArray(query);
        byte[] seq2Bytes = this.convertToUngappedByteArray(subject);
        StartPoint currentStartPoint = this.populateTraceback(matrix, openGapPenalty, extendGapPenalty, seq1Bytes, seq2Bytes);
        this.alignment = this.traceBack(seq1Bytes, seq2Bytes, currentStartPoint);
    }

    private void checkNotNull(Sequence<R> query, Sequence<R> subject, SubstitutionMatrix<R> matrix) {
        if (query == null) {
            throw new NullPointerException("query sequence can not be null");
        }
        if (subject == null) {
            throw new NullPointerException("subject sequence can not be null");
        }
        if (matrix == null) {
            throw new NullPointerException("scoring matrix can not be null");
        }
    }

    private StartPoint populateTraceback(SubstitutionMatrix<R> matrix, float openGapPenalty, float extendGapPenalty, byte[] seq1Bytes, byte[] seq2Bytes) {
        int lengthOfSeq1 = seq1Bytes.length;
        int lengthOfSeq2 = seq2Bytes.length;
        float[] verticalGapPenaltiesSoFar = new float[lengthOfSeq2 + 1];
        Arrays.fill(verticalGapPenaltiesSoFar, Float.NEGATIVE_INFINITY);
        List<R> residuesByOrdinal = this.pairwiseStrategy.getResidueList();
        StartPoint currentStartPoint = new StartPoint();
        for (int i = 1; i <= lengthOfSeq1; ++i) {
            float cumulativeHorizontalGapPenalty = Float.NEGATIVE_INFINITY;
            BitSet inAHorizontalGap = new BitSet(lengthOfSeq2 + 1);
            for (int j = 1; j <= lengthOfSeq2; ++j) {
                float diagnol = this.scoreCache[0][j - 1];
                float verticalGapExtensionScore = this.inAVerticalGapCache[0].get(j) ? this.scoreCache[0][j] + extendGapPenalty : Float.NEGATIVE_INFINITY;
                float verticalOpenGapScore = this.scoreCache[0][j] + openGapPenalty;
                verticalGapPenaltiesSoFar[j] = verticalGapExtensionScore > verticalOpenGapScore ? verticalGapExtensionScore : verticalOpenGapScore;
                float horizontalGapExtensionScore = inAHorizontalGap.get(j - 1) ? this.scoreCache[1][j - 1] + extendGapPenalty : Float.NEGATIVE_INFINITY;
                float horizontalGapOpenScore = this.scoreCache[1][j - 1] + openGapPenalty;
                cumulativeHorizontalGapPenalty = horizontalGapExtensionScore >= horizontalGapOpenScore ? horizontalGapExtensionScore : horizontalGapOpenScore;
                float alignmentScore = diagnol + matrix.getValue((Residue)residuesByOrdinal.get(seq1Bytes[i - 1]), (Residue)residuesByOrdinal.get(seq2Bytes[j - 1]));
                WalkBack bestWalkBack = this.computeBestWalkBack(alignmentScore, cumulativeHorizontalGapPenalty, verticalGapPenaltiesSoFar[j]);
                this.scoreCache[1][j] = bestWalkBack.getBestScore();
                currentStartPoint = this.updateCurrentStartPoint(bestWalkBack.getBestScore(), currentStartPoint, i, j);
                if (currentStartPoint == null) {
                    throw new NullPointerException("current start point can not be set to null");
                }
                switch (bestWalkBack.getTracebackDirection()) {
                    case HORIZONTAL: {
                        inAHorizontalGap.set(j, true);
                        break;
                    }
                    case VERTICAL: {
                        this.inAVerticalGapCache[1].set(j, true);
                        break;
                    }
                    case DIAGNOL: {
                        inAHorizontalGap.set(j, false);
                        this.inAVerticalGapCache[1].set(j, false);
                        break;
                    }
                }
                this.traceback.set(i, j, bestWalkBack.getTracebackDirection());
                diagnol = this.traceback.get(i - 1, j).ordinal();
            }
            this.updateCaches();
        }
        return currentStartPoint;
    }

    private void initializeFields(float openGapPenalty, float extendGapPenalty) {
        this.initializeVerticalGapCache();
        this.initializeScoreCache(openGapPenalty, extendGapPenalty);
    }

    private void initializeScoreCache(float openGapPenalty, float extendGapPenalty) {
        this.scoreCache[0] = this.getInitialGapScores(this.traceback.getYLength(), openGapPenalty, extendGapPenalty);
        this.scoreCache[1][1] = this.scoreCache[0][1];
    }

    private void initializeVerticalGapCache() {
        this.inAVerticalGapCache[0] = new BitSet(this.traceback.getYLength());
        this.inAVerticalGapCache[1] = new BitSet(this.traceback.getYLength());
    }

    protected abstract TracebackDirection getInitialRowTracebackValue();

    protected abstract TracebackDirection getInitialColTracebackValue();

    protected abstract float[] getInitialGapScores(int var1, float var2, float var3);

    private void updateCaches() {
        for (int j = 0; j < this.scoreCache[1].length; ++j) {
            this.scoreCache[0][j] = this.scoreCache[1][j];
            this.inAVerticalGapCache[0].set(j, this.inAVerticalGapCache[1].get(j));
        }
    }

    protected abstract StartPoint updateCurrentStartPoint(float var1, StartPoint var2, int var3, int var4);

    protected abstract WalkBack computeBestWalkBack(float var1, float var2, float var3);

    private P traceBack(byte[] seq1Bytes, byte[] seq2Bytes, StartPoint currentStartPoint) {
        boolean done = false;
        int x = currentStartPoint.getX();
        int y = currentStartPoint.getY();
        float score = currentStartPoint.getScore();
        SequenceAlignmentBuilder<Residue, S, B, A> alignmentBuilder = this.pairwiseStrategy.createSequenceAlignmentBuilder(true, this.subjectShiftAmount);
        alignmentBuilder.setAlignmentOffsets(x - 1, y - 1);
        R gap = this.pairwiseStrategy.getGap();
        List<R> residuesByOrdinal = this.pairwiseStrategy.getResidueList();
        block6: while (!done) {
            TracebackDirection tracebackDirection = this.traceback.get(x, y);
            switch (tracebackDirection) {
                case VERTICAL: {
                    alignmentBuilder.addGap((Residue)residuesByOrdinal.get(seq1Bytes[x - 1]), (Residue)gap);
                    --x;
                    continue block6;
                }
                case HORIZONTAL: {
                    alignmentBuilder.addGap((Residue)gap, (Residue)residuesByOrdinal.get(seq2Bytes[y - 1]));
                    --y;
                    continue block6;
                }
                case DIAGNOL: {
                    boolean isMatch;
                    boolean bl = isMatch = seq1Bytes[x - 1] == seq2Bytes[y - 1];
                    if (isMatch) {
                        alignmentBuilder.addMatch((Residue)residuesByOrdinal.get(seq1Bytes[x - 1]));
                    } else {
                        alignmentBuilder.addMismatch((Residue)residuesByOrdinal.get(seq1Bytes[x - 1]), (Residue)residuesByOrdinal.get(seq2Bytes[y - 1]));
                    }
                    --x;
                    --y;
                    continue block6;
                }
                case TERMINAL: {
                    done = true;
                    continue block6;
                }
            }
            throw new IllegalStateException("invalid Traceback direction " + (Object)((Object)tracebackDirection));
        }
        return this.pairwiseStrategy.wrapPairwiseAlignment(PairwiseSequenceAlignmentWrapper.wrap((SequenceAlignment)alignmentBuilder.build(), score));
    }

    public P getPairwiseSequenceAlignment() {
        return this.alignment;
    }

    private byte[] convertToUngappedByteArray(S sequence) {
        ByteBuffer buf = ByteBuffer.allocate((int)sequence.getUngappedLength());
        for (Residue residue : sequence) {
            if (residue.isGap()) continue;
            buf.put(residue.getOrdinalAsByte());
        }
        buf.flip();
        return buf.array();
    }

    private static final class TraceBackMatrix {
        private final byte[][] matrix;
        private final int xLength;
        private final int yLength;
        private static final TracebackDirection[] ORDINALS = TracebackDirection.values();

        TraceBackMatrix(int x, int y, TracebackDirection initialRowDirection, TracebackDirection initialColDirection) {
            this.xLength = x;
            this.yLength = y;
            this.matrix = new byte[(x + 1) / 2][(y + 1) / 2];
            this.initialize(initialRowDirection, initialColDirection);
        }

        private void initialize(TracebackDirection initialRowDirection, TracebackDirection initialColDirection) {
            byte origin;
            int rowOrdinal = initialRowDirection.ordinal();
            int colOrdinal = initialColDirection.ordinal();
            byte rowValue = (byte)(rowOrdinal << 6 | rowOrdinal << 4);
            for (int i = 1; i < this.matrix[0].length; ++i) {
                this.matrix[0][i] = rowValue;
            }
            byte colValue = (byte)(colOrdinal << 6 | colOrdinal << 2);
            for (int i = 1; i < this.matrix.length; ++i) {
                this.matrix[i][0] = colValue;
            }
            this.matrix[0][0] = origin = (byte)(TracebackDirection.TERMINAL.ordinal() << 6 | rowOrdinal << 4 | colOrdinal << 2);
        }

        public TracebackDirection get(int x, int y) {
            byte matrixValue = this.matrix[x / 2][y / 2];
            if ((x & 1) == 0) {
                if ((y & 1) == 0) {
                    return ORDINALS[(matrixValue & 0xC0) >> 6];
                }
                return ORDINALS[(matrixValue & 0x30) >> 4];
            }
            if ((y & 1) == 0) {
                return ORDINALS[(matrixValue & 0xC) >> 2];
            }
            return ORDINALS[matrixValue & 3];
        }

        public void set(int x, int y, TracebackDirection value) {
            byte matrixValue = this.matrix[x / 2][y / 2];
            this.matrix[x / 2][y / 2] = (x & 1) == 0 ? ((y & 1) == 0 ? (byte)(matrixValue & 0x3F | value.ordinal() << 6) : (byte)(matrixValue & 0xCF | value.ordinal() << 4)) : ((y & 1) == 0 ? (byte)(matrixValue & 0xF3 | value.ordinal() << 2) : (byte)(matrixValue & 0xFC | value.ordinal()));
        }

        public int getXLength() {
            return this.xLength;
        }

        public int getYLength() {
            return this.yLength;
        }
    }

    protected static enum TracebackDirection {
        TERMINAL,
        HORIZONTAL,
        VERTICAL,
        DIAGNOL;

    }

    protected static final class WalkBack {
        private final TracebackDirection tracebackDirection;
        private final float bestScore;

        public WalkBack(float bestScore, TracebackDirection tracebackDirection) {
            if (tracebackDirection == null) {
                throw new NullPointerException("traceback direction can not be null");
            }
            this.bestScore = bestScore;
            this.tracebackDirection = tracebackDirection;
        }

        public TracebackDirection getTracebackDirection() {
            return this.tracebackDirection;
        }

        public float getBestScore() {
            return this.bestScore;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Float.floatToIntBits(this.bestScore);
            result = 31 * result + this.tracebackDirection.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WalkBack other = (WalkBack)obj;
            if (Float.floatToIntBits(this.bestScore) != Float.floatToIntBits(other.bestScore)) {
                return false;
            }
            return this.tracebackDirection == other.tracebackDirection;
        }
    }

    protected static final class StartPoint {
        private final int x;
        private final int y;
        private final float score;

        public StartPoint() {
            this(0, 0, Float.NEGATIVE_INFINITY);
        }

        public StartPoint(int x, int y, float score) {
            this.x = x;
            this.y = y;
            this.score = score;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public float getScore() {
            return this.score;
        }

        public StartPoint updateIfWorseThan(int x, int y, float score) {
            if (score >= this.score) {
                return new StartPoint(x, y, score);
            }
            return this;
        }

        public String toString() {
            return "CurrentStartPoint [x=" + this.x + ", y=" + this.y + ", score=" + this.score + "]";
        }
    }
}

