/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.pairwise;

import java.util.Arrays;
import org.jcvi.jillion.align.SequenceAlignment;
import org.jcvi.jillion.align.SubstitutionMatrix;
import org.jcvi.jillion.align.pairwise.AbstractPairwiseAligner;
import org.jcvi.jillion.align.pairwise.PairwiseSequenceAlignment;
import org.jcvi.jillion.align.pairwise.ResiduePairwiseStrategy;
import org.jcvi.jillion.core.residue.Residue;
import org.jcvi.jillion.core.residue.ResidueSequence;
import org.jcvi.jillion.core.residue.ResidueSequenceBuilder;

abstract class AbstractNeedlemanWunschAligner<R extends Residue, S extends ResidueSequence<R, S, B>, B extends ResidueSequenceBuilder<R, S>, A extends SequenceAlignment<R, S>, P extends PairwiseSequenceAlignment<R, S>>
extends AbstractPairwiseAligner<R, S, B, A, P> {
    protected AbstractNeedlemanWunschAligner(S query, S subject, SubstitutionMatrix<R> matrix, float openGapPenalty, float extendGapPenalty, ResiduePairwiseStrategy<R, S, B, A, P> pairwiseStrategy) {
        super(query, subject, matrix, openGapPenalty, extendGapPenalty, pairwiseStrategy);
    }

    @Override
    protected float[] getInitialGapScores(int length, float openGapPenalty, float extendGapPenalty) {
        float[] array = new float[length];
        array[0] = 0.0f;
        array[1] = openGapPenalty;
        float currentScore = openGapPenalty;
        for (int i = 2; i < length; ++i) {
            array[i] = currentScore += extendGapPenalty;
        }
        return array;
    }

    @Override
    protected AbstractPairwiseAligner.TracebackDirection getInitialRowTracebackValue() {
        return AbstractPairwiseAligner.TracebackDirection.HORIZONTAL;
    }

    @Override
    protected AbstractPairwiseAligner.TracebackDirection getInitialColTracebackValue() {
        return AbstractPairwiseAligner.TracebackDirection.VERTICAL;
    }

    @Override
    protected AbstractPairwiseAligner.WalkBack computeBestWalkBack(float alignmentScore, float horrizontalGapPenalty, float verticalGapPenalty) {
        double[] array = new double[]{alignmentScore, horrizontalGapPenalty, verticalGapPenalty};
        float bestScore = (float)Arrays.stream(array).max().getAsDouble();
        AbstractPairwiseAligner.TracebackDirection dir = bestScore == alignmentScore ? AbstractPairwiseAligner.TracebackDirection.DIAGNOL : (bestScore == horrizontalGapPenalty ? AbstractPairwiseAligner.TracebackDirection.HORIZONTAL : AbstractPairwiseAligner.TracebackDirection.VERTICAL);
        return new AbstractPairwiseAligner.WalkBack(bestScore, dir);
    }

    @Override
    protected AbstractPairwiseAligner.StartPoint updateCurrentStartPoint(float currentBestScore, AbstractPairwiseAligner.StartPoint currentStartPoint, int i, int j) {
        return new AbstractPairwiseAligner.StartPoint(i, j, currentBestScore);
    }
}

