/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.exonerate.vulgar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarElement;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarOperation;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.aa.AminoAcid;
import org.jcvi.jillion.core.residue.aa.IupacTranslationTables;
import org.jcvi.jillion.core.residue.aa.ProteinSequence;
import org.jcvi.jillion.core.residue.aa.ProteinSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public class VulgarProtein2Genome {
    private final List<VulgarElement> elements;
    private final List<Range> targetExons;
    private final List<Range> targetGaps;
    private final List<Range> queryRanges;
    private final List<Range> queryGaps;
    private final String queryId;
    private final String targetId;
    private final float score;
    private Direction queryStrand;
    private Direction targetStrand;
    private final DirectedRange queryRange;
    private final DirectedRange targetRange;

    public VulgarProtein2Genome(String queryId, String targetId, List<VulgarElement> elements, float score, String queryStrand, DirectedRange queryRange, String targetStrand, DirectedRange targetRange) {
        this.elements = elements;
        this.queryId = Objects.requireNonNull(queryId);
        this.targetId = Objects.requireNonNull(targetId);
        this.score = score;
        this.queryRange = Objects.requireNonNull(queryRange);
        this.targetRange = Objects.requireNonNull(targetRange);
        this.targetExons = new ArrayList<Range>();
        this.targetGaps = new ArrayList<Range>();
        this.queryRanges = new ArrayList<Range>();
        this.queryGaps = new ArrayList<Range>();
        long queryOffset = 0L;
        long targetOffset = 0L;
        for (VulgarElement e : elements) {
            if (e.getOp() == VulgarOperation.Match || e.getOp() == VulgarOperation.Split_Codon || e.getOp() == VulgarOperation.Gap) {
                this.queryRanges.add(new Range.Builder(e.getQueryLength()).shift(queryOffset).build());
                this.targetExons.add(new Range.Builder(e.getTargetLength()).shift(targetOffset).build());
                if (e.getOp() == VulgarOperation.Gap) {
                    this.queryGaps.add(new Range.Builder(e.getTargetLength() / 3).shift(queryOffset).build());
                    this.targetGaps.add(new Range.Builder(e.getQueryLength() * 3).shift(targetOffset).build());
                }
            }
            queryOffset += (long)e.getQueryLength();
            targetOffset += (long)e.getTargetLength();
        }
        this.queryStrand = this.parseStrand(queryStrand);
        this.targetStrand = this.parseStrand(targetStrand);
    }

    private Direction parseStrand(String strand) {
        if (".".equals(strand)) {
            return null;
        }
        if ("+".equals(strand)) {
            return Direction.FORWARD;
        }
        return Direction.REVERSE;
    }

    public Optional<Direction> getQueryStrand() {
        return Optional.ofNullable(this.queryStrand);
    }

    public Optional<Direction> getTargetStrand() {
        return Optional.ofNullable(this.targetStrand);
    }

    public float getScore() {
        return this.score;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public List<VulgarElement> getElements() {
        return this.elements;
    }

    public List<Range> getTargetExons() {
        return this.targetExons;
    }

    public List<Range> getQueryRanges() {
        return this.queryRanges;
    }

    private void computeRanges(long startOffset, ToIntFunction<VulgarElement> function, List<Range> exons, BiConsumer<Long, VulgarElement> gapConsumer) {
        long currentOffset = startOffset;
        for (VulgarElement e : this.elements) {
            int len = function.applyAsInt(e);
            if (e.getOp() == VulgarOperation.Match || e.getOp() == VulgarOperation.Split_Codon) {
                exons.add(new Range.Builder(len).shift(currentOffset).build());
            } else if (e.getOp() == VulgarOperation.Gap) {
                gapConsumer.accept(currentOffset, e);
                exons.add(new Range.Builder(len).shift(currentOffset).build());
            }
            currentOffset += (long)len;
        }
        VulgarProtein2Genome.mergeInPlace(exons);
    }

    private static void mergeInPlace(List<Range> ranges) {
        List<Range> merged = Ranges.merge(ranges);
        ranges.clear();
        ranges.addAll(merged);
    }

    public <E extends Exception, E2 extends Exception> AlignmentResult align(ToSequenceFunction<NucleotideSequence, E> targetFunction, ToSequenceFunction<ProteinSequence, E2> queryFunction) throws E, E2 {
        return this.align(targetFunction.apply(this.targetId), queryFunction.apply(this.queryId));
    }

    public AlignmentResult align(NucleotideSequence target, ProteinSequence query) {
        NucleotideSequence cds = this.getExonSequence(target, this.targetExons, this.targetGaps);
        ProteinSequence translated = IupacTranslationTables.STANDARD.translate(cds);
        ProteinSequenceBuilder queryBuilder = (ProteinSequenceBuilder)query.toBuilder(this.queryRange.asRange());
        for (int i = this.queryGaps.size() - 1; i >= 0; --i) {
            Range gap = this.queryGaps.get(i);
            char[] gaps = new char[(int)gap.getLength()];
            if (gaps.length > 1) {
                System.out.println("here");
            }
            Arrays.fill(gaps, AminoAcid.Gap.asChar());
            queryBuilder.insert((int)gap.getBegin(), new String(gaps));
        }
        ProteinSequence querySeq = queryBuilder.build();
        String queryAlignment = querySeq.toString(AminoAcid::get3LetterAbbreviation).replaceAll("(.{62})", "$1\n");
        String translatedAlignment = translated.toString(AminoAcid::get3LetterAbbreviation).replaceAll("(.{62})", "$1\n");
        String cdsAlignment = cds.toString().replaceAll("(.{62})", "$1\n");
        try (BufferedReader qr = new BufferedReader(new StringReader(queryAlignment));
             BufferedReader tr = new BufferedReader(new StringReader(translatedAlignment));
             BufferedReader cdsr = new BufferedReader(new StringReader(cdsAlignment));){
            String tLine;
            String qLine;
            while ((qLine = qr.readLine()) != null && (tLine = tr.readLine()) != null) {
                System.out.println(qLine);
                System.out.println(tLine);
                System.out.println(cdsr.readLine() + "\n");
            }
            System.out.println("======");
            while ((qLine = qr.readLine()) != null) {
                System.out.println(" QLINE REMAINING = " + qLine);
            }
            while ((tLine = tr.readLine()) != null) {
                System.out.println(" T_LINE REMAINING = " + tLine);
            }
        }
        catch (IOException impossible) {
            impossible.printStackTrace();
        }
        Iterator queryIter = querySeq.iterator();
        Iterator subIter = translated.iterator();
        int matches = 0;
        int misMatches = 0;
        while (queryIter.hasNext() && subIter.hasNext()) {
            if (queryIter.next() == subIter.next()) {
                ++matches;
                continue;
            }
            ++misMatches;
        }
        while (queryIter.hasNext()) {
            queryIter.next();
            ++misMatches;
        }
        while (subIter.hasNext()) {
            subIter.next();
            ++misMatches;
        }
        System.out.println("matches = " + matches);
        System.out.println("misMatches = " + misMatches);
        double ident = (double)matches / (double)(matches + misMatches) * 100.0;
        System.out.println("percent ident = " + ident);
        return new AlignmentResult(this.queryId, this.targetId, ident, matches, misMatches);
    }

    private NucleotideSequence getExonSequence(NucleotideSequence t, List<Range> rangesToKeep, List<Range> gaps) {
        NucleotideSequenceBuilder builder = (NucleotideSequenceBuilder)t.toBuilder(this.targetRange.asRange());
        ListIterator<Range> iter = gaps.listIterator(gaps.size());
        while (iter.hasPrevious()) {
            Range g = iter.previous();
            int offset = (int)g.getBegin();
            Object[] array = new Nucleotide[(int)g.getLength()];
            Arrays.fill(array, Nucleotide.Gap);
            builder.insert(offset, (Nucleotide[])array);
        }
        ArrayList<Range.Builder> gappedRangesToKeep = new ArrayList<Range.Builder>();
        for (Range r : rangesToKeep) {
            gappedRangesToKeep.add(r.toBuilder());
        }
        for (Range gap : gaps) {
            for (Range.Builder b : gappedRangesToKeep) {
                if (!b.startsAfter(gap)) continue;
                b.shift(gap.getLength());
            }
        }
        return builder.build();
    }

    public static class AlignmentResult {
        private final double percentIdentity;
        private final int matches;
        private final int misMatches;
        private final String queryId;
        private final String targetId;

        protected AlignmentResult(String queryId, String targetId, double percentIdentity, int matches, int misMatches) {
            this.percentIdentity = percentIdentity;
            this.matches = matches;
            this.misMatches = misMatches;
            this.queryId = queryId;
            this.targetId = targetId;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public double getPercentIdentity() {
            return this.percentIdentity;
        }

        public int getMatches() {
            return this.matches;
        }

        public int getMisMatches() {
            return this.misMatches;
        }

        public String toString() {
            return "AlignmentResult [percentIdentity=" + this.percentIdentity + ", matches=" + this.matches + ", misMatches=" + this.misMatches + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.matches;
            result = 31 * result + this.misMatches;
            long temp = Double.doubleToLongBits(this.percentIdentity);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.queryId == null ? 0 : this.queryId.hashCode());
            result = 31 * result + (this.targetId == null ? 0 : this.targetId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AlignmentResult)) {
                return false;
            }
            AlignmentResult other = (AlignmentResult)obj;
            if (this.matches != other.matches) {
                return false;
            }
            if (this.misMatches != other.misMatches) {
                return false;
            }
            if (Double.doubleToLongBits(this.percentIdentity) != Double.doubleToLongBits(other.percentIdentity)) {
                return false;
            }
            if (this.queryId == null ? other.queryId != null : !this.queryId.equals(other.queryId)) {
                return false;
            }
            return !(this.targetId == null ? other.targetId != null : !this.targetId.equals(other.targetId));
        }
    }

    @FunctionalInterface
    public static interface ToSequenceFunction<T extends Sequence<?>, E extends Exception> {
        public T apply(String var1) throws E;
    }
}

