/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.exonerate.vulgar;

import java.util.Objects;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarOperation;

public class VulgarElement {
    private final VulgarOperation op;
    private final int queryLength;
    private final int targetLength;

    public VulgarElement(VulgarOperation op, int queryLength, int targetLength) {
        this.op = Objects.requireNonNull(op);
        if (queryLength < 0) {
            throw new IllegalArgumentException("query length can not be negative : " + queryLength);
        }
        if (targetLength < 0) {
            throw new IllegalArgumentException("target length can not be negative : " + targetLength);
        }
        this.queryLength = queryLength;
        this.targetLength = targetLength;
    }

    public VulgarOperation getOp() {
        return this.op;
    }

    public int getQueryLength() {
        return this.queryLength;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + this.queryLength;
        result = 31 * result + this.targetLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulgarElement)) {
            return false;
        }
        VulgarElement other = (VulgarElement)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.queryLength != other.queryLength) {
            return false;
        }
        return this.targetLength == other.targetLength;
    }

    public String toString() {
        return "VulgarElement [op=" + (Object)((Object)this.op) + ", queryLength=" + this.queryLength + ", targetLength=" + this.targetLength + "]";
    }
}

