/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align.exonerate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarElement;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarOperation;
import org.jcvi.jillion.align.exonerate.vulgar.VulgarProtein2Genome2;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.io.PushBackBufferedReader;

public class Exonerate2 {
    private static String BLOCK_START = "C4 Alignment:";

    public static List<VulgarProtein2Genome2> parseVulgarOutput(File vulgarOutput) throws IOException {
        return Exonerate2.parseVulgarOutput(InputStreamSupplier.forFile(vulgarOutput));
    }

    public static List<VulgarProtein2Genome2> parseVulgarOutput(InputStreamSupplier vulgarOutput) throws IOException {
        ArrayList<VulgarProtein2Genome2> list = new ArrayList<VulgarProtein2Genome2>();
        try (PushBackBufferedReader reader = new PushBackBufferedReader(new BufferedReader(new InputStreamReader(vulgarOutput.get())));){
            String currentBlock = Exonerate2.readNextBlock(reader);
            while (currentBlock != null) {
                VulgarProtein2Genome2 v = Exonerate2.handleBlock(currentBlock);
                if (v != null) {
                    list.add(v);
                }
                currentBlock = Exonerate2.readNextBlock(reader);
            }
        }
        return list;
    }

    private static VulgarProtein2Genome2 handleBlock(String block) throws IOException {
        Pattern splitPattern = Pattern.compile("\\s+");
        try (BufferedReader reader = new BufferedReader(new StringReader(block));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("vulgar:")) continue;
                String[] fields = splitPattern.split(line);
                String queryId = fields[1];
                DirectedRange queryRange = DirectedRange.parse(Long.parseLong(fields[2]), Long.parseLong(fields[3]), Range.CoordinateSystem.SPACE_BASED);
                String queryStrand = fields[4];
                String targetId = fields[5];
                DirectedRange targetRange = DirectedRange.parse(Long.parseLong(fields[6]), Long.parseLong(fields[7]), Range.CoordinateSystem.SPACE_BASED);
                String targetStrand = fields[8];
                float score = Float.parseFloat(fields[9]);
                ArrayList<VulgarElement> vulgarElements = new ArrayList<VulgarElement>((fields.length - 10) / 3);
                for (int i = 10; i < fields.length; i += 3) {
                    vulgarElements.add(new VulgarElement(VulgarOperation.getByCode(fields[i]), Integer.parseInt(fields[i + 1]), Integer.parseInt(fields[i + 2])));
                }
                VulgarProtein2Genome2 vulgarProtein2Genome2 = new VulgarProtein2Genome2(queryId, targetId, vulgarElements, score, queryStrand, queryRange, targetStrand, targetRange);
                return vulgarProtein2Genome2;
            }
        }
        return null;
    }

    private static String readNextBlock(PushBackBufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !BLOCK_START.equals(line)) {
        }
        if (line == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(5000);
        builder.append(line).append('\n');
        while ((line = reader.readLine()) != null) {
            if (BLOCK_START.equals(line)) {
                reader.pushBack(line);
                break;
            }
            builder.append(line).append('\n');
        }
        return builder.toString();
    }
}

