/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align;

import java.util.Arrays;
import java.util.List;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.Builder;

public final class NucleotideSubstitutionMatrixBuilder
implements Builder<NucleotideSubstitutionMatrix> {
    private final float[][] matrix;

    public NucleotideSubstitutionMatrixBuilder(float defaultScore) {
        int size = Nucleotide.getAllValues().size();
        this.matrix = new float[size][size];
        for (int i = 0; i < size; ++i) {
            Arrays.fill(this.matrix[i], defaultScore);
        }
    }

    public NucleotideSubstitutionMatrixBuilder setMatch(float matchScore) {
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i][i] = matchScore;
        }
        return this;
    }

    public NucleotideSubstitutionMatrixBuilder ambiguityScore(float ambiguityScore) {
        List<Nucleotide> values = Nucleotide.getDnaValues();
        for (int i = 0; i < values.size(); ++i) {
            Nucleotide n = values.get(i);
            if (!n.isAmbiguity()) continue;
            Arrays.fill(this.matrix[i], ambiguityScore);
            for (int row = 0; row < this.matrix[0].length; ++row) {
                this.matrix[row][i] = ambiguityScore;
            }
        }
        return this;
    }

    public NucleotideSubstitutionMatrixBuilder set(Nucleotide a, Nucleotide b, float score) {
        int i = a.ordinal();
        int j = b.ordinal();
        this.matrix[i][j] = score;
        this.matrix[j][i] = score;
        return this;
    }

    @Override
    public NucleotideSubstitutionMatrix build() {
        return new NucleotideSubstitutionMatrixImpl(this.matrix);
    }

    private static final class NucleotideSubstitutionMatrixImpl
    implements NucleotideSubstitutionMatrix {
        private final float[][] matrix;

        private NucleotideSubstitutionMatrixImpl(float[][] matrix) {
            this.matrix = matrix;
        }

        @Override
        public float getValue(Nucleotide a, Nucleotide b) {
            return this.getScore(a.getOrdinalAsByte(), b.getOrdinalAsByte());
        }

        private float getScore(byte ordinalOfBase1, byte ordinalOfBase2) {
            return this.matrix[ordinalOfBase1][ordinalOfBase2];
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode((Object[])this.matrix);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NucleotideSubstitutionMatrixImpl)) {
                return false;
            }
            NucleotideSubstitutionMatrixImpl other = (NucleotideSubstitutionMatrixImpl)obj;
            return Arrays.deepEquals((Object[])this.matrix, (Object[])other.matrix);
        }
    }
}

