/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.align.NucleotidePropertyFileScoringMatrixParser;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrixBuilder;

public final class NucleotideSubstitutionMatrices {
    private static final NucleotideSubstitutionMatrix NUC_4_4;
    private static final NucleotideSubstitutionMatrix IDENTITY;

    private NucleotideSubstitutionMatrices() {
    }

    public static NucleotideSubstitutionMatrix getNuc44() {
        return NUC_4_4;
    }

    public static NucleotideSubstitutionMatrix getIdentityMatrix() {
        return IDENTITY;
    }

    public static NucleotideSubstitutionMatrix parsePropertyFile(InputStream in) throws IOException {
        return NucleotidePropertyFileScoringMatrixParser.parse(in);
    }

    static {
        IDENTITY = new NucleotideSubstitutionMatrixBuilder(-4.0f).setMatch(1.0f).build();
        try {
            NUC_4_4 = NucleotidePropertyFileScoringMatrixParser.parse(NucleotideSubstitutionMatrices.class.getResourceAsStream("nuc4.4.matrix"));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("could not parse nuc4.4.matrix file", e);
        }
    }
}

