/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jcvi.jillion.align.AbstractSubstitutionMatrixFileParser;
import org.jcvi.jillion.align.NucleotideSubstitutionMatrix;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

final class NucleotidePropertyFileScoringMatrixParser
extends AbstractSubstitutionMatrixFileParser<Nucleotide>
implements NucleotideSubstitutionMatrix {
    public static NucleotidePropertyFileScoringMatrixParser parse(File maxtrix) throws FileNotFoundException {
        NucleotidePropertyFileScoringMatrixParser nucleotidePropertyFileScoringMatrixParser;
        block3: {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(maxtrix));
                nucleotidePropertyFileScoringMatrixParser = new NucleotidePropertyFileScoringMatrixParser(in);
                if (in == null) break block3;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    IOUtil.closeAndIgnoreErrors(in);
                }
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
        return nucleotidePropertyFileScoringMatrixParser;
    }

    public static NucleotidePropertyFileScoringMatrixParser parse(InputStream maxtrix) throws FileNotFoundException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(maxtrix);
            NucleotidePropertyFileScoringMatrixParser nucleotidePropertyFileScoringMatrixParser = new NucleotidePropertyFileScoringMatrixParser(in);
            return nucleotidePropertyFileScoringMatrixParser;
        }
        finally {
            if (in != null) {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }
    }

    private NucleotidePropertyFileScoringMatrixParser(InputStream in) {
        super(in);
    }

    @Override
    protected Nucleotide parse(String s) {
        return Nucleotide.parse(s);
    }

    @Override
    protected int getNumberOfValues() {
        return Nucleotide.getAllValues().size();
    }

    @Override
    protected Sequence<Nucleotide> parseColumns(String columns) {
        return new NucleotideSequenceBuilder(columns).build();
    }
}

