/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align;

import java.io.IOException;
import org.jcvi.jillion.align.AminoAcidSubstitutionMatrix;
import org.jcvi.jillion.align.AminoAcidSubstitutionMatrixFileParser;
import org.jcvi.jillion.internal.ResourceHelper;

public final class BlosumMatrices {
    private static AminoAcidSubstitutionMatrix BLOSUM_30;
    private static AminoAcidSubstitutionMatrix BLOSUM_40;
    private static AminoAcidSubstitutionMatrix BLOSUM_50;
    private static AminoAcidSubstitutionMatrix BLOSUM_62;
    private static AminoAcidSubstitutionMatrix BLOSUM_90;
    private static ResourceHelper RESOURCE_HELPER;

    private BlosumMatrices() {
    }

    public static synchronized AminoAcidSubstitutionMatrix blosum30() {
        if (BLOSUM_30 == null) {
            BLOSUM_30 = BlosumMatrices.getBlosumMatrix(30);
        }
        return BLOSUM_30;
    }

    public static synchronized AminoAcidSubstitutionMatrix blosum40() {
        if (BLOSUM_40 == null) {
            BLOSUM_40 = BlosumMatrices.getBlosumMatrix(40);
        }
        return BLOSUM_40;
    }

    public static synchronized AminoAcidSubstitutionMatrix blosum50() {
        if (BLOSUM_50 == null) {
            BLOSUM_50 = BlosumMatrices.getBlosumMatrix(50);
        }
        return BLOSUM_50;
    }

    public static synchronized AminoAcidSubstitutionMatrix blosum62() {
        if (BLOSUM_62 == null) {
            BLOSUM_62 = BlosumMatrices.getBlosumMatrix(62);
        }
        return BLOSUM_62;
    }

    public static synchronized AminoAcidSubstitutionMatrix blosum90() {
        if (BLOSUM_90 == null) {
            BLOSUM_90 = BlosumMatrices.getBlosumMatrix(90);
        }
        return BLOSUM_90;
    }

    private static final AminoAcidSubstitutionMatrix getBlosumMatrix(int value) {
        String file = String.format("blosum%d.matrix", value);
        try {
            return AminoAcidSubstitutionMatrixFileParser.parse(RESOURCE_HELPER.getFileAsStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException("could not parse substitution matrix file", e);
        }
    }

    static {
        RESOURCE_HELPER = new ResourceHelper(BlosumMatrices.class);
    }
}

