/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.align;

import java.io.InputStream;
import java.util.Scanner;
import org.jcvi.jillion.align.SubstitutionMatrix;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.residue.Residue;

abstract class AbstractSubstitutionMatrixFileParser<R extends Residue>
implements SubstitutionMatrix<R> {
    private final float[][] matrix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSubstitutionMatrixFileParser(InputStream in) {
        try (Scanner scanner = null;){
            scanner = new Scanner(in, "UTF-8");
            String headerLine = this.parseColumns(scanner);
            Sequence<R> header = this.parseColumns(headerLine);
            long headerLength = header.getLength();
            int n = this.getNumberOfValues();
            this.matrix = new float[n][n];
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Scanner lineScanner = null;
                try {
                    lineScanner = new Scanner(line);
                    while (lineScanner.hasNext()) {
                        String next = lineScanner.next();
                        R aa = this.parse(next);
                        byte x = aa.getOrdinalAsByte();
                        int i = 0;
                        while ((long)i < headerLength) {
                            float value = lineScanner.nextFloat();
                            byte y = ((Residue)header.get(i)).getOrdinalAsByte();
                            this.matrix[x][y] = value;
                            ++i;
                        }
                    }
                }
                finally {
                    if (lineScanner == null) continue;
                    lineScanner.close();
                }
            }
        }
    }

    protected abstract R parse(String var1);

    protected abstract int getNumberOfValues();

    private String parseColumns(Scanner scanner) {
        String line;
        boolean done = false;
        do {
            if ((line = scanner.nextLine()).isEmpty()) continue;
            boolean bl = done = line.charAt(0) != '#';
        } while (!done);
        return line;
    }

    protected abstract Sequence<R> parseColumns(String var1);

    @Override
    public float getValue(R a, R b) {
        return this.getValue(a.getOrdinalAsByte(), b.getOrdinalAsByte());
    }

    @Override
    private float getValue(byte a, byte b) {
        return this.matrix[a][b];
    }
}

