### Contributing
We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

### Code of conduct

Please note that this project is released with a [Contributor Code of Conduct](https://github.com/RiteshPuvvada/Virtue-Wheel/blob/main/.github/CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms.

 ### Create an issue
 - Before filing a new issue, search existing open and closed issues first. It is  likely someone else has found the problem you're seeing, and someone may be working on or have already contributed a fix!
 - Don't know whether you're reporting an issue or requesting a feature? File an issue.
 - Have a question that you don't see answered in docs, videos, etc.? File an issue.
 - Want to know if we're planning on building a particular feature? File an issue.
 - Got a great idea for a new feature? File an issue.
 - Found an existing issue that describes yours? Great - upvote and add additional commentary / info / repro-steps / etc.
 
We may have additional questions and will communicate through the GitHub issue, so please respond back to our questions to help reproduce and resolve the issue as quickly as possible.

### Pull Request Process

 -  Check if there's already a pull request assigned to someone that solves a similar problem to yours.
 - Ensure that the pull request is being sent from a hotfix/feature branch and not from `master`.
 - Check the issue page if the feature you are trying to add/bug you are trying to fix is already in the list. If it does, mention the issue number in parentheses with the pull request.
 - Provide a clear, concise description of why this pull request is necessary and what value it adds. Make sure that your pull request doesn't contain any more or less than what the pull request description says.
 - One pull request should do only one thing. No more, no less. If you want to implement two new features, open two pull requests.
   
The reviewer may have additional questions and will communicate through conversations in the GitHub PR, so please respond back to our questions or changes requested during review.
 
### Any contributions you make will be under the MIT Software License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](https://github.com/RiteshPuvvada/Real-Time-Chat-Supabase-NextJs/blob/main/LICENSE) that covers the project. Feel free to contact the maintainers if that's a concern.
