# 📄 Internal Steam Web API Documentation
> Documenting the unofficial and internal Steam Web API


<div align="center">
  <hr />
  <b><a href="https://github.com/Revadike/UnofficialSteamWebAPI/wiki">ACCESS HERE</a></b>
  <hr />
</div>

## Official API
This [wiki](https://github.com/Revadike/UnofficialSteamWebAPI/wiki) is **not** intended to list or document any "official" API that typically use an [API key](https://steamcommunity.com/dev/apikey). If you are interested in that, I recommend this lovely [Steam Web API Documentation](https://steamapi.xpaw.me/) by [@xPaw](https://github.com/xPaw).

## Contribution
**WE NEED YOUR HELP!**

Because of the nature of this kind of API, we desparately seek contributions to the [wiki](https://github.com/Revadike/UnofficialSteamWebAPI/wiki) to keep the documentation up-to-date and complete!
If this documentation was helpful to you in any way, please consider taking a few minutes to add a new wiki entry or update an existing one (look out for `TODO`). Also, a [☆ Star](https://github.com/Revadike/UnofficialSteamWebAPI/stargazers) is much appreciated!

## Generation
[This JavaScript script](https://github.com/Revadike/UnofficialSteamWebAPI/blob/master/generate_docs.js) may help you generate a proposal of the API documentation of an endpoint.
Unfortunately, it is not able to detect variables (such as appids and steamids), you have to correct this manually.

## Sources
Most of these unofficial API endpoints can be found by [reverse engineering](https://en.wikipedia.org/wiki/Reverse_engineering). Check out [this tutorial](https://developer.chrome.com/docs/devtools/network/) by [@Google](https://github.com/google).

There are also other sources that are tracking them (undocumented), here are a few of them:

 * [SteamTracking's Client URL List](https://github.com/SteamDatabase/SteamTracking/blob/master/ClientExtracted/public/url_list.txt)
 * [SteamTracking's JavaScript URL List](https://github.com/SteamDatabase/SteamTracking/blob/master/API/JavascriptUrls.txt)

## License
[MIT License](https://github.com/Revadike/UnofficialSteamWebAPI/blob/master/LICENSE)
