## AppDaemon入门
## 第二部分（日出日落）

我猜我让你对编程这事情感兴趣了。棒极了。现在让我们创建另一个App。

当我编程时，百度是我最好的朋友。我不再是一名专业的程序员了，在过去的几年里我必须学写新东西。你我不了解，但我每年都要老一岁的。所以有时我需要获取帮助，因为我忘记或者根本还没有学会。AppDaemon的API文档要一直开着，以便查找如何正确使用，以及百度其他事情。

但是暂且先别百度索，否则你可能会找到一个比这个更好的教程。：wink：（译者注：自谦了，找不到更好的了。）

好的，让我们回到主题，然后更进一步。
在HA中，你找到的第一个自动化就是日落和日出。很好玩，很有趣。你可以在晚上让室外灯光大亮，或在夜晚让室内灯光昏暗。
我可以告诉你，自从我开始使用HA以来，我的客厅灯没手动开过。
Andrew提供给了我们一些在AppDaemon中日落和日出的易用的函数。
首先两个是 **self.sunset() :one:** 和 **self.sunrise() :one:**  
所见即所得。就是在太阳升起或落下的时刻。当你在HA一切设置正确时:blink:
我们可以在python脚本中的任何位置使用它即可完成和你当地时间进行的比较。

等下还有更多函数！
Andrew还创建了 **self.run_at_sunset(The_function_you want_to_start, offset, kwargs) :one:** 和 **self.run_at_sunrise(The_function_you want_tostart, offset, kwargs) :one:**  
我想你明白这些都可以作为触发器，均放在initialize函数中。  
看到这词 **kwargs :two:** 别害怕。它不是克林贡语（是的，我是星际迷航的粉丝）Kwargs是一个python词汇，用于你需要多个传递函数变量的地方。  
所以在那个地方你可以为你的功能提供一些东西。 也许你想给你的灯光描述或颜色。 我实际上并没有经常使用它，但它确实存在。
就是给函数传递参数的地方。说不定你可以给你灯设置描述或者颜色。我用的不多，不过这功能一直有。

你觉得这就完了？AppDaemon东西多了去了。我们还有 **self.sun_up() :one:** 和 **self.sun_down() :one:** 这样我们不用计算和思考就能获取太阳是否已经升起或降落了。  

## 参数

OK，这就是日出日落。之后我们会用到，不过首先我想告诉你AppDaemon里另一个非常重要的事情。  
Args（参数）！它依然不是克林贡语。Args是参数的简写。 好的争论（arguments的一般翻译）是对话的基础（坏争论也是），不过我们这里只不过是我们要传递的东西。  
举个例子：x + 1 = ?  
我猜你解不出来吧。但是如果我告诉你x为4你就解出来了，x为67你也能解出来。  
这就是参数的意义。  
在python脚本里我们使用 **self.args["your_arg_name"] :one:** 然后我们把这些参数放在yaml文件里。  
注意着并非是函数。函数是把变量放()里而这里用的[]。这都不重要，但是现在你就懂干嘛不用()了。
在yaml文件里我们写入"your_arg_name: Mr. Bean" ，其他地方写入"your_argname: Queen Elisabeth".
当然我们不是真的要去自动化控制这两个人，不过我学会用特殊的名字去帮助记忆。
在本例中用他们来写一个小脚本（像我们的第一个App）然后反复调用。

记得这行吗？

```
      self.turnon("light.somelight")
```

我们可以重写成这样：

```
      self.turnon(self.args["lightID"])
```

然后加上

```
  lightID: light.some_light
```

到yaml文件。
之后我们不用更改app直接改some_light到其他some_other_light就可以了。
在yaml文件里像这样：

```
some_light_on:  
  module: some_app  
  class: your_class_name  
  lightID: light.some_light  

some_other_light_on:  
  module: some_app  
  class: your_class_name  
  lightID: light.some_other_light  
```

之后你可以再加一个灯，再加一个...
很棒不是吗？我想我们已经学到可以写第二个app了，是不是？

让我们动手吧。

## 第二个App

现在让我们根据日落开一下灯，让它在日出时关闭。 我们要做到HA中的任何灯都可以实现这功能，并且我们希望能够使用一个偏移时间来打开和关闭每个灯光。这是完整的app（我们也可以创建2个app应用程序，一个日出用一个日落用，不过还是合在一起吧）：

```
import appdaemon.plugins.hass.hassapi as hass

class sun_down_lights(hass.Hass):

  def initialize(self):
    self.run_at_sunset(self.light_on_function, ,offset = int(self.args["sunset_offset"])
    self.run_at_sunrise(self.light_off_function, ,offset = int(self.args["sunrise_offset"])

  def light_onfunction (self, kwargs):
      self.turn_on(self.args["lightID"])

  def light_offfunction (self, kwargs):
      self.turn_off(self.args["lightID"])
```

就是这样。再次拆分后解释：

前三行和第一个App一样，复制黏贴就行。
然后看到：

```
    self.run_at_sunset(self.light_on_function,offset = int(self.args["sunset_offset"]))
    self.run_at_sunrise(self.light_off_function,offset = int(self.args["sunrise_offset"]))
```

实际上只有一样东西我还没讲到就是 **int() :two:** 部分  
你可以看到括号。所以这就是个标准的python函数，作用是把 **string (text) :two:** 字符串类型转换 **integer (number) :two:** 整型。   
你从self.args获取的所有参数都能作为字符串型变量。而函数run_at_sunset和run_at_sunrise我们需要的是一个整型变量。所以我们把字符串转换成整型。  
显然只有变量本来就含有数字而不仅仅是字符时才有用。  
我用了 **'offset=' :one:** 偏移在代码里。由于我们还能传递其他变量比如 **random=... :one:** ，关键字offset写明就格外重要。
sunset_offset和sunrise_offset两个参数可以之后添加到yaml文件中。

下一行：

```
  def light_onfunction (self, kwargs):
```
这行用来命名我们的函数。记不记得我说过括号内可以有很多种方法表示？
(self, kwargs)就是用来表示基本的回调函数(callbacks)。

然后一行是：

```
      self.turn_on(self.args["lightID"])
```

这行没什么可以讲的。讲参数的时候已经提到过了。
最后两行也没什么可以讲的，相信你都懂。

很简单，是不是？

还有一件事情要做。再次编辑yaml文件。  
太阳一下山我们就开灯吧。  
第一个App设置日落前一个小时到日出后一个小时，第二个App设置正好日出日落时。

要死我又忘记什么事情了。我们的App还没保存。所以它没有名字。在丢掉存档前保存并命名成sun_lights.py。

现在编辑yaml文件在最后加这几行：

```
sun_down_some_light_on:
  module: sun_lights
  class: sun_down_lights
  sunset_offset: -3600
  sunrise_offset: 3600
  lightID: light.some_light

sun_down_some_other_light_on
  module: sun_lights
  class: sun_down_lights
  sunset_offset: 0
  sunrise_offset: 0
  lightID: light.some_other_light
```

提醒一小下：offset的单位是秒。

你现在明白怎么让灯在晚上打开在早上关闭了。  
我觉得还是别开太多的灯，否则睡眠会有障碍。 :smile:

自己动手试试吧。玩的开心。

**:one: 这些都是AppDaemon特有词汇，请到API手册查询**   
**:two: 这些词汇用百度配合关键词Python查询**
