# <img src="images/logo.svg" alt="logo" style="width: 2em; vertical-align: middle;"/> RedisAI
[![Forum](https://img.shields.io/badge/Forum-RedisAI-blue)](https://forum.redislabs.com/c/modules/redisai)
[![Discord](https://img.shields.io/discord/697882427875393627?style=flat-square)](https://discord.gg/rTQm7UZ)

RedisAI is a Redis module for executing Deep Learning/Machine Learning models and managing their data. Its purpose is being a "workhorse" for model serving, by providing out-of-the-box support for popular DL/ML frameworks and unparalleled performance. **RedisAI both maximizes computation throughput and reduces latency by adhering to the principle of data locality**, as well as simplifies the deployment and serving of graphs by leveraging on Redis' production-proven infrastructure.

## Where Next?
  * The [Introduction](intro.md) is the recommended starting point
  * The [Quickstart](quickstart.md) page provides information about building, installing and running RedisAI
  * The [Commands](commands.md) page is a reference of the RedisAI API 
  * The [RedisGears integration](https://oss.redis.com/redisgears/master/redisai.html) page is a reference of the built-in integration of [RedisGears](https://oss.redis.com/redisgears/) with RedisAI via a Python plugin.
  * The [Clients](clients.md) page lists RedisAI clients by programming language
  * The [Configuration](configuration.md) page explains how to configure RedisAI 
  * The [Performance](performance.md) page provides instructions for running benchmarks with RedisAI
  * The [Developer](developer.md) page has more information about the design and implementation of the RedisAI module

## Quick Links
  * [Source code repository](https://github.com/RedisAI/RedisAI)
  * [Releases](https://github.com/RedisAI/RedisAI/releases)
  * [Docker image](https://hub.docker.com/r/redislabs/redisai/)

## Contact Us
If you have questions, want to provide feedback or perhaps report an issue or [contribute some code](contrib.md), here's where we're listening to you:

  * [Forum](https://forum.redis.com/c/modules/redisai)
  * [Repository](https://github.com/RedisAI/RedisAI/issues)

## License
RedisAI is licensed under the [Redis Source Available License Agreement](https://github.com/RedisAI/RedisAI/blob/master/LICENSE).
