## Simple react(-native) app

## JS Topics

- Imperatve and Declaractive JS
- Let, Var and Const
- Scopes
- State and Props
- Function Declaration and Function Expression
- Stateless and Stateful components
- Lifecycle methods and Hooks
- Synchronous and Asynchronous Functions

### Basics

- Components in React
- Data and UI synced automatically
- Interface
- State and Props in React
- Changing the value of a local variable doesn't cause component(function) to be called again. Use State (and more ways to come in future).

Ref - https://snack.expo.dev/@ankushdharkar/simple-react

```tsx
import React, { useState } from 'react';
import { Button, Text, View, StyleSheet } from 'react-native';

// Ideally components should be in separate files.

interface GreetUserProps {
  firstName: string;
  age?: number;
}

const GreetUser: React.FC<GreetUserProps> = ({ firstName, age }) => {
  return (
    <View style={styles.container}>
      <Text style={styles.paragraph}>
        Greetings {firstName}, Age: {age}
      </Text>
    </View>
  );
};

// App called 1st time name=undefined, useState: name=Rahul
// onPress = setName(Ankush), name= Ankush
// State change detected!~!!! Call App() again
// App called 2nd time name=Ankush, from previous useState

// Props or State'
const App: React.FC<{}> = () => {
  const [name, setName] = useState<string>('Rahul'); // Hook  {name: Ankush}
  const [count, setCount] = useState<number>(100); // count = 99

  return (
    <View style={styles.container}>
      <GreetUser firstName={name} age={count} />

      <Button
        title="Click Me"
        onPress={() => {
          setName("Ankush");
          setCount(count - 1);
        }}
      />
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    justifyContent: 'center',
    paddingTop: 40,
    backgroundColor: '#ecf0f1',
    padding: 8,
    borderColor: 'purple',
    borderWidth: 2,
  },
  heading: {
    margin: 10,
    fontSize: 30,
    fontWeight: 'bold',
    textAlign: 'center',
  },
  paragraph: {
    margin: 24,
    fontSize: 18,
    fontWeight: 'bold',
    textAlign: 'center',
  },
});

export default App;
```
