﻿using NUnit.Framework;

//// ncrunch: rdi off
namespace MiKoSolutions.Analyzers.Linguistics
{
    [TestFixture]
    public static class PluralizerTests
    {
        [TestCase("_bases", ExpectedResult = "_items")]
        [TestCase("_sources", ExpectedResult = "_source")]
        [TestCase("Access", ExpectedResult = "Accesses")]
        [TestCase("aircraft", ExpectedResult = null)]
        [TestCase("analysis", ExpectedResult = "analyses")]
        [TestCase("Array", ExpectedResult = "Arrays")]
        [TestCase("baby", ExpectedResult = "babies")]
        [TestCase("bacterium", ExpectedResult = "bacteria")]
        [TestCase("bases", ExpectedResult = "items")]
        [TestCase("cactus", ExpectedResult = "cacti")]
        [TestCase("Child", ExpectedResult = "Children")]
        [TestCase("Children", ExpectedResult = null)]
        [TestCase("city", ExpectedResult = "cities")]
        [TestCase("complete", ExpectedResult = "all")]
        [TestCase("criterion", ExpectedResult = "criteria")]
        [TestCase("Data", ExpectedResult = null)]
        [TestCase("Datas", ExpectedResult = "Data")]
        [TestCase("foot", ExpectedResult = "feet")]
        [TestCase("fox", ExpectedResult = "foxes")]
        [TestCase("fungus", ExpectedResult = "fungi")]
        [TestCase("goose", ExpectedResult = "geese")]
        [TestCase("Hash", ExpectedResult = "Hashes")]
        [TestCase("Index", ExpectedResult = "Indices")]
        [TestCase("Indices", ExpectedResult = "Indices")]
        [TestCase("Information", ExpectedResult = null)]
        [TestCase("Informations", ExpectedResult = "Information")]
        [TestCase("itemModels", ExpectedResult = "items")]
        [TestCase("itemsToModel", ExpectedResult = "items")]
        [TestCase("Key", ExpectedResult = "Keys")]
        [TestCase("Keys", ExpectedResult = "Keys")]
        [TestCase("life", ExpectedResult = "lives")]
        [TestCase("loot", ExpectedResult = "loot")]
        [TestCase("m_bases", ExpectedResult = "m_items")]
        [TestCase("m_sources", ExpectedResult = "m_source")]
        [TestCase("Mech", ExpectedResult = "Mechs")]
        [TestCase("moose", ExpectedResult = null)]
        [TestCase("mouse", ExpectedResult = "mice")]
        [TestCase("namesToConvert", ExpectedResult = "names")]
        [TestCase("Nested", ExpectedResult = null)]
        [TestCase("octopus", ExpectedResult = "octopi")]
        [TestCase("person", ExpectedResult = "people")]
        [TestCase("phenomenon", ExpectedResult = "phenomena")]
        [TestCase("quiz", ExpectedResult = "quizzes")]
        [TestCase("ray", ExpectedResult = "rays")]
        [TestCase("Security", ExpectedResult = "Securities")]
        [TestCase("Securitys", ExpectedResult = "Securities")]
        [TestCase("sheep", ExpectedResult = null)]
        [TestCase("sources", ExpectedResult = "source")]
        [TestCase("toe", ExpectedResult = "toes")]
        [TestCase("tooth", ExpectedResult = "teeth")]
        [TestCase("toy", ExpectedResult = "toys")]
        [TestCase("waltz", ExpectedResult = "waltzes")]
        [TestCase("wolf", ExpectedResult = "wolves")]
        [TestCase("woman", ExpectedResult = "women")]
        public static string Creates_correct_plural_name_(string singularName) => Pluralizer.GetPluralName(singularName);

        [TestCase("access", ExpectedResult = "accesses")]
        [TestCase("accesses", ExpectedResult = "accesses")]
        [TestCase("aircraft", ExpectedResult = "aircraft")]
        [TestCase("Child", ExpectedResult = "Children")]
        [TestCase("Children", ExpectedResult = "Children")]
        [TestCase("Data", ExpectedResult = "Data")]
        [TestCase("Indices", ExpectedResult = "Indices")]
        [TestCase("Information", ExpectedResult = "Information")]
        [TestCase("Keys", ExpectedResult = "Keys")]
        [TestCase("loot", ExpectedResult = "loot")]
        [TestCase("Message", ExpectedResult = "Messages")]
        [TestCase("Messages", ExpectedResult = "Messages")]
        [TestCase("moose", ExpectedResult = "moose")]
        [TestCase("Nested", ExpectedResult = "Nested")]
        [TestCase("sheep", ExpectedResult = "sheep")]
        [TestCase("SyntaxTrivia", ExpectedResult = "SyntaxTrivia")]
        [TestCase("trivia", ExpectedResult = "trivia")]
        [TestCase("Trivia", ExpectedResult = "Trivia")]
        public static string Makes_correct_plural_name_(string singularName) => Pluralizer.MakePluralName(singularName);

        [TestCase("accesses", ExpectedResult = false)]
        [TestCase("Adoptors", ExpectedResult = true)]
        [TestCase("adopts", ExpectedResult = false)]
        [TestCase("aircraft", ExpectedResult = true)]
        [TestCase("Ancestors", ExpectedResult = true)]
        [TestCase("bacteria", ExpectedResult = true)]
        [TestCase("bacterium", ExpectedResult = false)]
        [TestCase("bridges", ExpectedResult = true)]
        [TestCase("Butchers", ExpectedResult = true)]
        [TestCase("Caches", ExpectedResult = true)]
        [TestCase("cacti", ExpectedResult = true)]
        [TestCase("cactus", ExpectedResult = false)]
        [TestCase("capabilities", ExpectedResult = true)]
        [TestCase("cars", ExpectedResult = true)]
        [TestCase("cartridges", ExpectedResult = true)]
        [TestCase("children", ExpectedResult = true)]
        [TestCase("Children", ExpectedResult = true)]
        [TestCase("collets", ExpectedResult = true)]
        [TestCase("colors", ExpectedResult = true)]
        [TestCase("colours", ExpectedResult = true)]
        [TestCase("continues", ExpectedResult = false)]
        [TestCase("criteria", ExpectedResult = true)]
        [TestCase("criterion", ExpectedResult = false)]
        [TestCase("cursors", ExpectedResult = true)]
        [TestCase("Descendants", ExpectedResult = true)]
        [TestCase("dogs", ExpectedResult = true)]
        [TestCase("edges", ExpectedResult = true)]
        [TestCase("feet", ExpectedResult = true)]
        [TestCase("fixtures", ExpectedResult = true)]
        [TestCase("flood", ExpectedResult = false)]
        [TestCase("foot", ExpectedResult = false)]
        [TestCase("forms", ExpectedResult = true)]
        [TestCase("fungi", ExpectedResult = true)]
        [TestCase("fungus", ExpectedResult = false)]
        [TestCase("Hashes", ExpectedResult = true)]
        [TestCase("helicopters", ExpectedResult = true)]
        [TestCase("idea", ExpectedResult = false)]
        [TestCase("ideas", ExpectedResult = true)]
        [TestCase("inform", ExpectedResult = false)]
        [TestCase("information", ExpectedResult = true)]
        [TestCase("Information", ExpectedResult = true)]
        [TestCase("informs", ExpectedResult = false)]
        [TestCase("invite", ExpectedResult = false)]
        [TestCase("invites", ExpectedResult = true)] // such as in 'our invites'
        [TestCase("lets", ExpectedResult = false)]
        [TestCase("Managers", ExpectedResult = true)]
        [TestCase("manages", ExpectedResult = false)]
        [TestCase("merges", ExpectedResult = true)]
        [TestCase("message", ExpectedResult = false)]
        [TestCase("Message", ExpectedResult = false)]
        [TestCase("messages", ExpectedResult = true)]
        [TestCase("Messages", ExpectedResult = true)]
        [TestCase("messaging", ExpectedResult = false)]
        [TestCase("Messaging", ExpectedResult = false)]
        [TestCase("mice", ExpectedResult = true)]
        [TestCase("mood", ExpectedResult = false)]
        [TestCase("moose", ExpectedResult = true)]
        [TestCase("mouse", ExpectedResult = false)]
        [TestCase("occurs", ExpectedResult = false)]
        [TestCase("pens", ExpectedResult = true)]
        [TestCase("people", ExpectedResult = true)]
        [TestCase("person", ExpectedResult = false)]
        [TestCase("phenomena", ExpectedResult = true)]
        [TestCase("phenomenon", ExpectedResult = false)]
        [TestCase("prompts", ExpectedResult = true)]
        [TestCase("reposities", ExpectedResult = true)]
        [TestCase("Reposities", ExpectedResult = true)]
        [TestCase("rules", ExpectedResult = true)]
        [TestCase("runs", ExpectedResult = true)] // such as in 'test runs'
        [TestCase("sheep", ExpectedResult = true)]
        [TestCase("tables", ExpectedResult = true)]
        [TestCase("teeth", ExpectedResult = true)]
        [TestCase("terms", ExpectedResult = true)]
        [TestCase("tests", ExpectedResult = true)]
        [TestCase("tooth", ExpectedResult = false)]
        [TestCase("Transcriptors", ExpectedResult = true)]
        [TestCase("trees", ExpectedResult = true)]
        [TestCase("triplets", ExpectedResult = true)]
        [TestCase("umbrellas", ExpectedResult = true)]
        [TestCase("wolves", ExpectedResult = true)]
        [TestCase("woman", ExpectedResult = false)]
        [TestCase("women", ExpectedResult = true)]
        [TestCase("worms", ExpectedResult = true)]
        public static bool IsPlural_detects_plural_word_(string name) => Pluralizer.IsPlural(name);
    }
}