﻿using NUnit.Framework;

namespace MiKoSolutions.Analyzers.Linguistics
{
    [TestFixture]
    public static class AbbreviationDetectorTests
    {
        [TestCase("alt", ExpectedResult = "alternative")]
        [TestCase("app", ExpectedResult = "application")]
        [TestCase("apps", ExpectedResult = "applications")]
        [TestCase("assoc", ExpectedResult = "association")]
        [TestCase("auth", ExpectedResult = "authorization")]
        [TestCase("btn", ExpectedResult = "button")]
        [TestCase("cb", ExpectedResult = "checkBox")]
        [TestCase("cert", ExpectedResult = "certificate")]
        [TestCase("chk", ExpectedResult = "checkBox")]
        [TestCase("cls", ExpectedResult = "class")]
        [TestCase("cmb", ExpectedResult = "comboBox")]
        [TestCase("cmd", ExpectedResult = "command")]
        [TestCase("conf", ExpectedResult = "configuration")]
        [TestCase("config", ExpectedResult = "configuration")]
        [TestCase("configs", ExpectedResult = "configurations")]
        [TestCase("conn", ExpectedResult = "connection")]
        [TestCase("ctg", ExpectedResult = "category")]
        [TestCase("ctl", ExpectedResult = "control")]
        [TestCase("ctlg", ExpectedResult = "catalog")]
        [TestCase("ctrl", ExpectedResult = "control")]
        [TestCase("ctx", ExpectedResult = "context")]
        [TestCase("db", ExpectedResult = "database")]
        [TestCase("ddl", ExpectedResult = "dropDownList")]
        [TestCase("decl", ExpectedResult = "declaration")]
        [TestCase("decr", ExpectedResult = "decrypt")]
        [TestCase("def", ExpectedResult = "definition")]
        [TestCase("defs", ExpectedResult = "definitions")]
        [TestCase("desc", ExpectedResult = "description")]
        [TestCase("dest", ExpectedResult = "destination")]
        [TestCase("diag", ExpectedResult = "diagnostic")]
        [TestCase("diags", ExpectedResult = "diagnostics")]
        [TestCase("dict", ExpectedResult = "dictionary")]
        [TestCase("diff", ExpectedResult = "difference")]
        [TestCase("diffs", ExpectedResult = "differences")]
        [TestCase("dir", ExpectedResult = "directory")]
        [TestCase("dirs", ExpectedResult = "directories")]
        [TestCase("dlg", ExpectedResult = "dialog")]
        [TestCase("doc", ExpectedResult = "document")]
        [TestCase("docs", ExpectedResult = "documents")]
        [TestCase("dst", ExpectedResult = "destination")]
        [TestCase("dto", ExpectedResult = "")]
        [TestCase("env", ExpectedResult = "environment")]
        [TestCase("encr", ExpectedResult = "encrypt")]
        [TestCase("environ", ExpectedResult = "environment")]
        [TestCase("err", ExpectedResult = "error")]
        [TestCase("ext", ExpectedResult = "extension")]
        [TestCase("frm", ExpectedResult = "form")]
        [TestCase("hdls", ExpectedResult = "headless")]
        [TestCase("ident", ExpectedResult = "identification")]
        [TestCase("idents", ExpectedResult = "identifications")]
        [TestCase("idx", ExpectedResult = "index")]
        [TestCase("init", ExpectedResult = "initialize")]
        [TestCase("itf", ExpectedResult = "interface")]
        [TestCase("lang", ExpectedResult = "language")]
        [TestCase("lbl", ExpectedResult = "label")]
        [TestCase("lib", ExpectedResult = "library")]
        [TestCase("libs", ExpectedResult = "libraries")]
        [TestCase("lv", ExpectedResult = "listView")]
        [TestCase("max", ExpectedResult = "maximum")]
        [TestCase("meth", ExpectedResult = "method")]
        [TestCase("mgmt", ExpectedResult = "management")]
        [TestCase("mgr", ExpectedResult = "manager")]
        [TestCase("mgrs", ExpectedResult = "managers")]
        [TestCase("min", ExpectedResult = "minimum")]
        [TestCase("mngr", ExpectedResult = "manager")]
        [TestCase("mngrs", ExpectedResult = "managers")]
        [TestCase("mnu", ExpectedResult = "menuItem")]
        [TestCase("msg", ExpectedResult = "message")]
        [TestCase("msgs", ExpectedResult = "messages")]
        [TestCase("num", ExpectedResult = "number")]
        [TestCase("nums", ExpectedResult = "numbers")]
        [TestCase("obj", ExpectedResult = "object")]
        [TestCase("param", ExpectedResult = "parameter")]
        [TestCase("params", ExpectedResult = "parameters")]
        [TestCase("perc", ExpectedResult = "percentage")]
        [TestCase("perf", ExpectedResult = "performance")]
        [TestCase("phys", ExpectedResult = "physical")]
        [TestCase("pos", ExpectedResult = "position")]
        [TestCase("pow", ExpectedResult = "power")]
        [TestCase("proc", ExpectedResult = "process")]
        [TestCase("procs", ExpectedResult = "processes")]
        [TestCase("prop", ExpectedResult = "property")]
        [TestCase("props", ExpectedResult = "properties")]
        [TestCase("pt", ExpectedResult = "point")]
        [TestCase("pts", ExpectedResult = "points")]
        [TestCase("qty", ExpectedResult = "quantity")]
        [TestCase("ref", ExpectedResult = "reference")]
        [TestCase("refs", ExpectedResult = "references")]
        [TestCase("repo", ExpectedResult = "repository")]
        [TestCase("repos", ExpectedResult = "repositories")]
        [TestCase("req", ExpectedResult = "request")]
        [TestCase("res", ExpectedResult = "result")]
        [TestCase("resp", ExpectedResult = "response")]
        [TestCase("sem", ExpectedResult = "semantic")]
        [TestCase("spec", ExpectedResult = "specification")]
        [TestCase("specs", ExpectedResult = "specifications")]
        [TestCase("src", ExpectedResult = "source")]
        [TestCase("std", ExpectedResult = "standard")]
        [TestCase("str", ExpectedResult = "string")]
        [TestCase("sync", ExpectedResult = "synchronization")]
        [TestCase("svc", ExpectedResult = "service")]
        [TestCase("tm", ExpectedResult = "time")]
        [TestCase("tmp", ExpectedResult = "temp")]
        [TestCase("txt", ExpectedResult = "text")]
        [TestCase("txts", ExpectedResult = "texts")]
        [TestCase("var", ExpectedResult = "variable")]
        [TestCase("ver", ExpectedResult = "version")]
        [TestCase("vol", ExpectedResult = "volume")]
        public static string Finds_prefix_abbreviation_in_(string value)
        {
            var findings = AbbreviationDetector.Find(value + "SomeName");

            Assert.That(findings.Length, Is.EqualTo(1));

            return findings[0].Value;
        }

        [TestCase("Alt", ExpectedResult = "Alternative")]
        [TestCase("App", ExpectedResult = "Application")]
        [TestCase("Apps", ExpectedResult = "Applications")]
        [TestCase("Assoc", ExpectedResult = "Association")]
        [TestCase("Auth", ExpectedResult = "Authorization")]
        [TestCase("Btn", ExpectedResult = "Button")]
        [TestCase("Btns", ExpectedResult = "Buttons")]
        [TestCase("Cb", ExpectedResult = "CheckBox")]
        [TestCase("Cert", ExpectedResult = "Certificate")]
        [TestCase("Certs", ExpectedResult = "Certificates")]
        [TestCase("Chk", ExpectedResult = "CheckBox")]
        [TestCase("Cli", ExpectedResult = "CommandLineInterface")]
        [TestCase("CLI", ExpectedResult = "CommandLineInterface")]
        [TestCase("Cls", ExpectedResult = "Class")]
        [TestCase("Cmb", ExpectedResult = "ComboBox")]
        [TestCase("Cmd", ExpectedResult = "Command")]
        [TestCase("Conf", ExpectedResult = "Configuration")]
        [TestCase("Config", ExpectedResult = "Configuration")]
        [TestCase("Configs", ExpectedResult = "Configurations")]
        [TestCase("Conn", ExpectedResult = "Connection")]
        [TestCase("Conns", ExpectedResult = "Connections")]
        [TestCase("Ctg", ExpectedResult = "Category")]
        [TestCase("Ctl", ExpectedResult = "Control")]
        [TestCase("Ctlg", ExpectedResult = "Catalog")]
        [TestCase("Ctrl", ExpectedResult = "Control")]
        [TestCase("Ctx", ExpectedResult = "Context")]
        [TestCase("Db", ExpectedResult = "Database")]
        [TestCase("Ddl", ExpectedResult = "DropDownList")]
        [TestCase("Decl", ExpectedResult = "Declaration")]
        [TestCase("Decr", ExpectedResult = "Decrypt")]
        [TestCase("Def", ExpectedResult = "Definition")]
        [TestCase("Defs", ExpectedResult = "Definitions")]
        [TestCase("Desc", ExpectedResult = "Description")]
        [TestCase("Dest", ExpectedResult = "Destination")]
        [TestCase("Diag", ExpectedResult = "Diagnostic")]
        [TestCase("Diags", ExpectedResult = "Diagnostics")]
        [TestCase("Dict", ExpectedResult = "Dictionary")]
        [TestCase("Diff", ExpectedResult = "Difference")]
        [TestCase("Diffs", ExpectedResult = "Differences")]
        [TestCase("Dir", ExpectedResult = "Directory")]
        [TestCase("Dirs", ExpectedResult = "Directories")]
        [TestCase("Dlg", ExpectedResult = "Dialog")]
        [TestCase("Doc", ExpectedResult = "Document")]
        [TestCase("Docs", ExpectedResult = "Documents")]
        [TestCase("Dst", ExpectedResult = "Destination")]
        [TestCase("Dto", ExpectedResult = "")]
        [TestCase("DTO", ExpectedResult = "")]
        [TestCase("Ef", ExpectedResult = "EntityFramework")]
        [TestCase("EF", ExpectedResult = "EntityFramework")]
        [TestCase("Encr", ExpectedResult = "Encrypt")]
        [TestCase("Env", ExpectedResult = "Environment")]
        [TestCase("Environ", ExpectedResult = "Environment")]
        [TestCase("Err", ExpectedResult = "Error")]
        [TestCase("Ext", ExpectedResult = "Extension")]
        [TestCase("Frm", ExpectedResult = "Form")]
        [TestCase("Hdls", ExpectedResult = "Headless")]
        [TestCase("Ident", ExpectedResult = "Identification")]
        [TestCase("Idents", ExpectedResult = "Identifications")]
        [TestCase("Idx", ExpectedResult = "Index")]
        [TestCase("Init", ExpectedResult = "Initialize")]
        [TestCase("Itf", ExpectedResult = "Interface")]
        [TestCase("Lang", ExpectedResult = "Language")]
        [TestCase("Lbl", ExpectedResult = "Label")]
        [TestCase("Lib", ExpectedResult = "Library")]
        [TestCase("Libs", ExpectedResult = "Libraries")]
        [TestCase("Lv", ExpectedResult = "ListView")]
        [TestCase("Max", ExpectedResult = "Maximum")]
        [TestCase("Meth", ExpectedResult = "Method")]
        [TestCase("Mgmt", ExpectedResult = "Management")]
        [TestCase("Mgr", ExpectedResult = "Manager")]
        [TestCase("Mgrs", ExpectedResult = "Managers")]
        [TestCase("Min", ExpectedResult = "Minimum")]
        [TestCase("Mngr", ExpectedResult = "Manager")]
        [TestCase("Mngrs", ExpectedResult = "Managers")]
        [TestCase("Mnu", ExpectedResult = "MenuItem")]
        [TestCase("Msg", ExpectedResult = "Message")]
        [TestCase("Num", ExpectedResult = "Number")]
        [TestCase("Obj", ExpectedResult = "Object")]
        [TestCase("Objs", ExpectedResult = "Objects")]
        [TestCase("Op", ExpectedResult = "Operation")]
        [TestCase("Ops", ExpectedResult = "Operations")]
        [TestCase("Param", ExpectedResult = "Parameter")]
        [TestCase("Params", ExpectedResult = "Parameters")]
        [TestCase("Perc", ExpectedResult = "Percentage")]
        [TestCase("Perf", ExpectedResult = "Performance")]
        [TestCase("Phys", ExpectedResult = "Physical")]
        [TestCase("Pos", ExpectedResult = "Position")]
        [TestCase("Pow", ExpectedResult = "Power")]
        [TestCase("Proc", ExpectedResult = "Process")]
        [TestCase("Procs", ExpectedResult = "Processes")]
        [TestCase("Prop", ExpectedResult = "Property")]
        [TestCase("Props", ExpectedResult = "Properties")]
        [TestCase("Pt", ExpectedResult = "Point")]
        [TestCase("Pts", ExpectedResult = "Points")]
        [TestCase("Qty", ExpectedResult = "Quantity")]
        [TestCase("Ref", ExpectedResult = "Reference")]
        [TestCase("Refs", ExpectedResult = "References")]
        [TestCase("Repo", ExpectedResult = "Repository")]
        [TestCase("Repos", ExpectedResult = "Repositories")]
        [TestCase("Req", ExpectedResult = "Request")]
        [TestCase("Res", ExpectedResult = "Result")]
        [TestCase("Resp", ExpectedResult = "Response")]
        [TestCase("Sem", ExpectedResult = "Semantic")]
        [TestCase("Spec", ExpectedResult = "Specification")]
        [TestCase("Src", ExpectedResult = "Source")]
        [TestCase("Std", ExpectedResult = "Standard")]
        [TestCase("Str", ExpectedResult = "String")]
        [TestCase("Sync", ExpectedResult = "Synchronization")]
        [TestCase("Svc", ExpectedResult = "Service")]
        [TestCase("Tm", ExpectedResult = "Time")]
        [TestCase("Tmp", ExpectedResult = "Temp")]
        [TestCase("Txt", ExpectedResult = "Text")]
        [TestCase("Var", ExpectedResult = "Variable")]
        [TestCase("Ver", ExpectedResult = "Version")]
        [TestCase("Vol", ExpectedResult = "Volume")]
        [TestCase("BL", ExpectedResult = "BusinessLogic")]
        [TestCase("Bl", ExpectedResult = "BusinessLogic")]
        [TestCase("VM", ExpectedResult = "ViewModel")]
        [TestCase("VMs", ExpectedResult = "ViewModels")]
        [TestCase("Vm", ExpectedResult = "ViewModel")]
        [TestCase("Vms", ExpectedResult = "ViewModels")]
        public static string Finds_postfix_abbreviation_in_(string value)
        {
            var findings = AbbreviationDetector.Find("someName" + value);

            Assert.That(findings.Length, Is.EqualTo(1));

            return findings[0].Value;
        }

        [TestCase("appSomeName", ExpectedResult = "applicationSomeName")]
        [TestCase("appsSomeName", ExpectedResult = "applicationsSomeName")]
        [TestCase("assocSomeName", ExpectedResult = "associationSomeName")]
        [TestCase("authSomeName", ExpectedResult = "authorizationSomeName")]
        [TestCase("btnSomeName", ExpectedResult = "buttonSomeName")]
        [TestCase("cbSomeName", ExpectedResult = "checkBoxSomeName")]
        [TestCase("certSomeName", ExpectedResult = "certificateSomeName")]
        [TestCase("chkSomeName", ExpectedResult = "checkBoxSomeName")]
        [TestCase("clsSomeName", ExpectedResult = "classSomeName")]
        [TestCase("cmbSomeName", ExpectedResult = "comboBoxSomeName")]
        [TestCase("cmdSomeName", ExpectedResult = "commandSomeName")]
        [TestCase("confSomeName", ExpectedResult = "configurationSomeName")]
        [TestCase("configSomeName", ExpectedResult = "configurationSomeName")]
        [TestCase("configsSomeName", ExpectedResult = "configurationsSomeName")]
        [TestCase("connSomeName", ExpectedResult = "connectionSomeName")]
        [TestCase("ctgSomeName", ExpectedResult = "categorySomeName")]
        [TestCase("ctlSomeName", ExpectedResult = "controlSomeName")]
        [TestCase("ctlgSomeName", ExpectedResult = "catalogSomeName")]
        [TestCase("ctrlSomeName", ExpectedResult = "controlSomeName")]
        [TestCase("ctxSomeName", ExpectedResult = "contextSomeName")]
        [TestCase("dbSomeName", ExpectedResult = "databaseSomeName")]
        [TestCase("ddlSomeName", ExpectedResult = "dropDownListSomeName")]
        [TestCase("declSomeName", ExpectedResult = "declarationSomeName")]
        [TestCase("decrSomeName", ExpectedResult = "decryptSomeName")]
        [TestCase("defSomeName", ExpectedResult = "definitionSomeName")]
        [TestCase("defsSomeName", ExpectedResult = "definitionsSomeName")]
        [TestCase("descSomeName", ExpectedResult = "descriptionSomeName")]
        [TestCase("destSomeName", ExpectedResult = "destinationSomeName")]
        [TestCase("diagSomeName", ExpectedResult = "diagnosticSomeName")]
        [TestCase("diagsSomeName", ExpectedResult = "diagnosticsSomeName")]
        [TestCase("dictSomeName", ExpectedResult = "dictionarySomeName")]
        [TestCase("diffSomeName", ExpectedResult = "differenceSomeName")]
        [TestCase("diffsSomeName", ExpectedResult = "differencesSomeName")]
        [TestCase("dirSomeName", ExpectedResult = "directorySomeName")]
        [TestCase("dirsSomeName", ExpectedResult = "directoriesSomeName")]
        [TestCase("dlgSomeName", ExpectedResult = "dialogSomeName")]
        [TestCase("docSomeName", ExpectedResult = "documentSomeName")]
        [TestCase("docsSomeName", ExpectedResult = "documentsSomeName")]
        [TestCase("dstSomeName", ExpectedResult = "destinationSomeName")]
        [TestCase("dtoSomeName", ExpectedResult = "SomeName")]
        [TestCase("envSomeName", ExpectedResult = "environmentSomeName")]
        [TestCase("encrSomeName", ExpectedResult = "encryptSomeName")]
        [TestCase("environSomeName", ExpectedResult = "environmentSomeName")]
        [TestCase("errSomeName", ExpectedResult = "errorSomeName")]
        [TestCase("extSomeName", ExpectedResult = "extensionSomeName")]
        [TestCase("frmSomeName", ExpectedResult = "formSomeName")]
        [TestCase("hdlsSomeName", ExpectedResult = "headlessSomeName")]
        [TestCase("identSomeName", ExpectedResult = "identificationSomeName")]
        [TestCase("identsSomeName", ExpectedResult = "identificationsSomeName")]
        [TestCase("idxSomeName", ExpectedResult = "indexSomeName")]
        [TestCase("initSomeName", ExpectedResult = "initializeSomeName")]
        [TestCase("itfSomeName", ExpectedResult = "interfaceSomeName")]
        [TestCase("langSomeName", ExpectedResult = "languageSomeName")]
        [TestCase("lblSomeName", ExpectedResult = "labelSomeName")]
        [TestCase("libSomeName", ExpectedResult = "librarySomeName")]
        [TestCase("libsSomeName", ExpectedResult = "librariesSomeName")]
        [TestCase("lvSomeName", ExpectedResult = "listViewSomeName")]
        [TestCase("maxSomeName", ExpectedResult = "maximumSomeName")]
        [TestCase("methSomeName", ExpectedResult = "methodSomeName")]
        [TestCase("mgmtSomeName", ExpectedResult = "managementSomeName")]
        [TestCase("mgrSomeName", ExpectedResult = "managerSomeName")]
        [TestCase("mgrsSomeName", ExpectedResult = "managersSomeName")]
        [TestCase("minSomeName", ExpectedResult = "minimumSomeName")]
        [TestCase("mngrSomeName", ExpectedResult = "managerSomeName")]
        [TestCase("mngrsSomeName", ExpectedResult = "managersSomeName")]
        [TestCase("mnuSomeName", ExpectedResult = "menuItemSomeName")]
        [TestCase("msgSomeName", ExpectedResult = "messageSomeName")]
        [TestCase("msgsSomeName", ExpectedResult = "messagesSomeName")]
        [TestCase("numSomeName", ExpectedResult = "numberSomeName")]
        [TestCase("numsSomeName", ExpectedResult = "numbersSomeName")]
        [TestCase("objSomeName", ExpectedResult = "objectSomeName")]
        [TestCase("paramSomeName", ExpectedResult = "parameterSomeName")]
        [TestCase("paramsSomeName", ExpectedResult = "parametersSomeName")]
        [TestCase("percSomeName", ExpectedResult = "percentageSomeName")]
        [TestCase("perfSomeName", ExpectedResult = "performanceSomeName")]
        [TestCase("physSomeName", ExpectedResult = "physicalSomeName")]
        [TestCase("posSomeName", ExpectedResult = "positionSomeName")]
        [TestCase("powSomeName", ExpectedResult = "powerSomeName")]
        [TestCase("procSomeName", ExpectedResult = "processSomeName")]
        [TestCase("procsSomeName", ExpectedResult = "processesSomeName")]
        [TestCase("propSomeName", ExpectedResult = "propertySomeName")]
        [TestCase("propsSomeName", ExpectedResult = "propertiesSomeName")]
        [TestCase("ptSomeName", ExpectedResult = "pointSomeName")]
        [TestCase("ptsSomeName", ExpectedResult = "pointsSomeName")]
        [TestCase("qtySomeName", ExpectedResult = "quantitySomeName")]
        [TestCase("refSomeName", ExpectedResult = "referenceSomeName")]
        [TestCase("refsSomeName", ExpectedResult = "referencesSomeName")]
        [TestCase("repoSomeName", ExpectedResult = "repositorySomeName")]
        [TestCase("reposSomeName", ExpectedResult = "repositoriesSomeName")]
        [TestCase("reqSomeName", ExpectedResult = "requestSomeName")]
        [TestCase("resSomeName", ExpectedResult = "resultSomeName")]
        [TestCase("respSomeName", ExpectedResult = "responseSomeName")]
        [TestCase("semSomeName", ExpectedResult = "semanticSomeName")]
        [TestCase("specSomeName", ExpectedResult = "specificationSomeName")]
        [TestCase("specsSomeName", ExpectedResult = "specificationsSomeName")]
        [TestCase("srcSomeName", ExpectedResult = "sourceSomeName")]
        [TestCase("stdSomeName", ExpectedResult = "standardSomeName")]
        [TestCase("strSomeName", ExpectedResult = "stringSomeName")]
        [TestCase("syncSomeName", ExpectedResult = "synchronizationSomeName")]
        [TestCase("svcSomeName", ExpectedResult = "serviceSomeName")]
        [TestCase("tmSomeName", ExpectedResult = "timeSomeName")]
        [TestCase("tmpSomeName", ExpectedResult = "tempSomeName")]
        [TestCase("txtSomeName", ExpectedResult = "textSomeName")]
        [TestCase("txtsSomeName", ExpectedResult = "textsSomeName")]
        [TestCase("varSomeName", ExpectedResult = "variableSomeName")]
        [TestCase("verSomeName", ExpectedResult = "versionSomeName")]
        [TestCase("volSomeName", ExpectedResult = "volumeSomeName")]
        public static string Finds_prefix_abbreviations_and_fixes_them_in_(string value) => AbbreviationDetector.FindAndReplaceAllAbbreviations(value);

        [TestCase("someNameApp", ExpectedResult = "someNameApplication")]
        [TestCase("someNameApps", ExpectedResult = "someNameApplications")]
        [TestCase("someNameAssoc", ExpectedResult = "someNameAssociation")]
        [TestCase("someNameAuth", ExpectedResult = "someNameAuthorization")]
        [TestCase("someNameBtn", ExpectedResult = "someNameButton")]
        [TestCase("someNameBtns", ExpectedResult = "someNameButtons")]
        [TestCase("someNameCb", ExpectedResult = "someNameCheckBox")]
        [TestCase("someNameCert", ExpectedResult = "someNameCertificate")]
        [TestCase("someNameCerts", ExpectedResult = "someNameCertificates")]
        [TestCase("someNameChk", ExpectedResult = "someNameCheckBox")]
        [TestCase("someNameCli", ExpectedResult = "someNameCommandLineInterface")]
        [TestCase("someNameCLI", ExpectedResult = "someNameCommandLineInterface")]
        [TestCase("someNameCls", ExpectedResult = "someNameClass")]
        [TestCase("someNameCmb", ExpectedResult = "someNameComboBox")]
        [TestCase("someNameCmd", ExpectedResult = "someNameCommand")]
        [TestCase("someNameConf", ExpectedResult = "someNameConfiguration")]
        [TestCase("someNameConfig", ExpectedResult = "someNameConfiguration")]
        [TestCase("someNameConfigs", ExpectedResult = "someNameConfigurations")]
        [TestCase("someNameConn", ExpectedResult = "someNameConnection")]
        [TestCase("someNameConns", ExpectedResult = "someNameConnections")]
        [TestCase("someNameCtg", ExpectedResult = "someNameCategory")]
        [TestCase("someNameCtl", ExpectedResult = "someNameControl")]
        [TestCase("someNameCtlg", ExpectedResult = "someNameCatalog")]
        [TestCase("someNameCtrl", ExpectedResult = "someNameControl")]
        [TestCase("someNameCtx", ExpectedResult = "someNameContext")]
        [TestCase("someNameDb", ExpectedResult = "someNameDatabase")]
        [TestCase("someNameDdl", ExpectedResult = "someNameDropDownList")]
        [TestCase("someNameDecl", ExpectedResult = "someNameDeclaration")]
        [TestCase("someNameDecr", ExpectedResult = "someNameDecrypt")]
        [TestCase("someNameDef", ExpectedResult = "someNameDefinition")]
        [TestCase("someNameDefs", ExpectedResult = "someNameDefinitions")]
        [TestCase("someNameDesc", ExpectedResult = "someNameDescription")]
        [TestCase("someNameDest", ExpectedResult = "someNameDestination")]
        [TestCase("someNameDiag", ExpectedResult = "someNameDiagnostic")]
        [TestCase("someNameDiags", ExpectedResult = "someNameDiagnostics")]
        [TestCase("someNameDict", ExpectedResult = "someNameDictionary")]
        [TestCase("someNameDiff", ExpectedResult = "someNameDifference")]
        [TestCase("someNameDiffs", ExpectedResult = "someNameDifferences")]
        [TestCase("someNameDir", ExpectedResult = "someNameDirectory")]
        [TestCase("someNameDirs", ExpectedResult = "someNameDirectories")]
        [TestCase("someNameDlg", ExpectedResult = "someNameDialog")]
        [TestCase("someNameDoc", ExpectedResult = "someNameDocument")]
        [TestCase("someNameDocs", ExpectedResult = "someNameDocuments")]
        [TestCase("someNameDst", ExpectedResult = "someNameDestination")]
        [TestCase("someNameDto", ExpectedResult = "someName")]
        [TestCase("someNameDTO", ExpectedResult = "someName")]
        [TestCase("someNameEf", ExpectedResult = "someNameEntityFramework")]
        [TestCase("someNameEF", ExpectedResult = "someNameEntityFramework")]
        [TestCase("someNameEncr", ExpectedResult = "someNameEncrypt")]
        [TestCase("someNameEnv", ExpectedResult = "someNameEnvironment")]
        [TestCase("someNameEnviron", ExpectedResult = "someNameEnvironment")]
        [TestCase("someNameErr", ExpectedResult = "someNameError")]
        [TestCase("someNameExt", ExpectedResult = "someNameExtension")]
        [TestCase("someNameFrm", ExpectedResult = "someNameForm")]
        [TestCase("someNameHdls", ExpectedResult = "someNameHeadless")]
        [TestCase("someNameIdent", ExpectedResult = "someNameIdentification")]
        [TestCase("someNameIdents", ExpectedResult = "someNameIdentifications")]
        [TestCase("someNameIdx", ExpectedResult = "someNameIndex")]
        [TestCase("someNameInit", ExpectedResult = "someNameInitialize")]
        [TestCase("someNameItf", ExpectedResult = "someNameInterface")]
        [TestCase("someNameLang", ExpectedResult = "someNameLanguage")]
        [TestCase("someNameLbl", ExpectedResult = "someNameLabel")]
        [TestCase("someNameLib", ExpectedResult = "someNameLibrary")]
        [TestCase("someNameLibs", ExpectedResult = "someNameLibraries")]
        [TestCase("someNameLv", ExpectedResult = "someNameListView")]
        [TestCase("someNameMax", ExpectedResult = "someNameMaximum")]
        [TestCase("someNameMeth", ExpectedResult = "someNameMethod")]
        [TestCase("someNameMgmt", ExpectedResult = "someNameManagement")]
        [TestCase("someNameMgr", ExpectedResult = "someNameManager")]
        [TestCase("someNameMgrs", ExpectedResult = "someNameManagers")]
        [TestCase("someNameMin", ExpectedResult = "someNameMinimum")]
        [TestCase("someNameMngr", ExpectedResult = "someNameManager")]
        [TestCase("someNameMngrs", ExpectedResult = "someNameManagers")]
        [TestCase("someNameMnu", ExpectedResult = "someNameMenuItem")]
        [TestCase("someNameMsg", ExpectedResult = "someNameMessage")]
        [TestCase("someNameNum", ExpectedResult = "someNameNumber")]
        [TestCase("someNameObj", ExpectedResult = "someNameObject")]
        [TestCase("someNameObjs", ExpectedResult = "someNameObjects")]
        [TestCase("someNameOp", ExpectedResult = "someNameOperation")]
        [TestCase("someNameOps", ExpectedResult = "someNameOperations")]
        [TestCase("someNameParam", ExpectedResult = "someNameParameter")]
        [TestCase("someNameParams", ExpectedResult = "someNameParameters")]
        [TestCase("someNamePerc", ExpectedResult = "someNamePercentage")]
        [TestCase("someNamePerf", ExpectedResult = "someNamePerformance")]
        [TestCase("someNamePhys", ExpectedResult = "someNamePhysical")]
        [TestCase("someNamePos", ExpectedResult = "someNamePosition")]
        [TestCase("someNamePow", ExpectedResult = "someNamePower")]
        [TestCase("someNameProc", ExpectedResult = "someNameProcess")]
        [TestCase("someNameProcs", ExpectedResult = "someNameProcesses")]
        [TestCase("someNameProp", ExpectedResult = "someNameProperty")]
        [TestCase("someNameProps", ExpectedResult = "someNameProperties")]
        [TestCase("someNamePt", ExpectedResult = "someNamePoint")]
        [TestCase("someNamePts", ExpectedResult = "someNamePoints")]
        [TestCase("someNameQty", ExpectedResult = "someNameQuantity")]
        [TestCase("someNameRef", ExpectedResult = "someNameReference")]
        [TestCase("someNameRefs", ExpectedResult = "someNameReferences")]
        [TestCase("someNameRepo", ExpectedResult = "someNameRepository")]
        [TestCase("someNameRepos", ExpectedResult = "someNameRepositories")]
        [TestCase("someNameReq", ExpectedResult = "someNameRequest")]
        [TestCase("someNameRes", ExpectedResult = "someNameResult")]
        [TestCase("someNameResp", ExpectedResult = "someNameResponse")]
        [TestCase("someNameSem", ExpectedResult = "someNameSemantic")]
        [TestCase("someNameSpec", ExpectedResult = "someNameSpecification")]
        [TestCase("someNameSrc", ExpectedResult = "someNameSource")]
        [TestCase("someNameStd", ExpectedResult = "someNameStandard")]
        [TestCase("someNameStr", ExpectedResult = "someNameString")]
        [TestCase("someNameSync", ExpectedResult = "someNameSynchronization")]
        [TestCase("someNameSvc", ExpectedResult = "someNameService")]
        [TestCase("someNameTm", ExpectedResult = "someNameTime")]
        [TestCase("someNameTmp", ExpectedResult = "someNameTemp")]
        [TestCase("someNameTxt", ExpectedResult = "someNameText")]
        [TestCase("someNameVar", ExpectedResult = "someNameVariable")]
        [TestCase("someNameVer", ExpectedResult = "someNameVersion")]
        [TestCase("someNameVol", ExpectedResult = "someNameVolume")]
        [TestCase("someNameBL", ExpectedResult = "someNameBusinessLogic")]
        [TestCase("someNameBl", ExpectedResult = "someNameBusinessLogic")]
        [TestCase("someNameVM", ExpectedResult = "someNameViewModel")]
        [TestCase("someNameVMs", ExpectedResult = "someNameViewModels")]
        [TestCase("someNameVm", ExpectedResult = "someNameViewModel")]
        [TestCase("someNameVms", ExpectedResult = "someNameViewModels")]
        public static string Finds_postfix_abbreviations_and_fixes_them_in_(string value) => AbbreviationDetector.FindAndReplaceAllAbbreviations(value);
    }
}