# Copyright (c) Microsoft. All rights reserved.
from sklearn.metrics import matthews_corrcoef
from sklearn.metrics import accuracy_score, f1_score
from scipy.stats import pearsonr, spearmanr
from torch.nn.functional import cross_entropy

def compute_acc(predicts, labels):
    return 100.0 * accuracy_score(labels, predicts)

def compute_f1(predicts, labels):
    return 100.0 * f1_score(labels, predicts)

def compute_mcc(predicts, labels):
    return 100.0 * matthews_corrcoef(labels, predicts)

def compute_pearson(predicts, labels):
    pcof = pearsonr(labels, predicts)[0]
    return 100.0 * pcof

def compute_spearman(predicts, labels):
    scof = spearmanr(labels, predicts)[0]
    return 100.0 * scof

def compute_cross_entropy(predicts, labels):
    return cross_entropy(predicts, labels)
