/// <summary>
/// Unit generated using the Delphi Wmi class generator tool, Copyright Rodrigo Ruz V. 2010-2012
/// Application version 1.0.4674.62299
/// WMI version 7601.17514
/// Creation Date 17-10-2012 18:19:47
/// Namespace root\CIMV2 Class Win32_SerialPort
/// MSDN info about this class http://msdn2.microsoft.com/library/default.asp?url=/library/en-us/wmisdk/wmi/Win32_SerialPort.asp
/// </summary>


unit uWin32_SerialPort;

interface

uses
 Classes,
 Activex,
 Variants,
 ComObj,
 uWmiDelphiClass;

type
  {$REGION 'Documentation'}
  /// <summary>
  /// The Win32_SerialPort class represents a serial port on a Win32 system.
  /// </summary>
  {$ENDREGION}
  TWin32_SerialPort=class(TWmiClass)
  private
    FAvailability                       : Word;
    FBinary                             : Boolean;
    FCapabilities                       : TWordArray;
    FCapabilityDescriptions             : TStrings;
    FCaption                            : String;
    FConfigManagerErrorCode             : Cardinal;
    FConfigManagerUserConfig            : Boolean;
    FCreationClassName                  : String;
    FDescription                        : String;
    FDeviceID                           : String;
    FErrorCleared                       : Boolean;
    FErrorDescription                   : String;
    FInstallDate                        : TDateTime;
    FLastErrorCode                      : Cardinal;
    FMaxBaudRate                        : Cardinal;
    FMaximumInputBufferSize             : Cardinal;
    FMaximumOutputBufferSize            : Cardinal;
    FMaxNumberControlled                : Cardinal;
    FName                               : String;
    FOSAutoDiscovered                   : Boolean;
    FPNPDeviceID                        : String;
    FPowerManagementCapabilities        : TWordArray;
    FPowerManagementSupported           : Boolean;
    FProtocolSupported                  : Word;
    FProviderType                       : String;
    FSettableBaudRate                   : Boolean;
    FSettableDataBits                   : Boolean;
    FSettableFlowControl                : Boolean;
    FSettableParity                     : Boolean;
    FSettableParityCheck                : Boolean;
    FSettableRLSD                       : Boolean;
    FSettableStopBits                   : Boolean;
    FStatus                             : String;
    FStatusInfo                         : Word;
    FSupports16BitMode                  : Boolean;
    FSupportsDTRDSR                     : Boolean;
    FSupportsElapsedTimeouts            : Boolean;
    FSupportsIntTimeouts                : Boolean;
    FSupportsParityCheck                : Boolean;
    FSupportsRLSD                       : Boolean;
    FSupportsRTSCTS                     : Boolean;
    FSupportsSpecialCharacters          : Boolean;
    FSupportsXOnXOff                    : Boolean;
    FSupportsXOnXOffSet                 : Boolean;
    FSystemCreationClassName            : String;
    FSystemName                         : String;
    FTimeOfLastReset                    : TDateTime;
  public
   constructor Create(LoadWmiData : boolean=True); overload;
   destructor Destroy;Override;
   {$REGION 'Documentation'}
   /// <summary>
   /// The availability and status of the device.  For example, the Availability 
   /// property indicates that the device is running and has full power (value=3), or 
   /// is in a warning (4), test (5), degraded (10) or power save state (values 13-15 
   /// and 17). Regarding the power saving states, these are defined as follows: Value 
   /// 13 ("Power Save - Unknown") indicates that the device is known to be in a power 
   /// save mode, but its exact status in this mode is unknown; 14 
   /// ("Power Save - Low Power Mode") indicates that the device is in a power save 
   /// state but still functioning, and may exhibit degraded performance; 15 
   /// ("Power Save - Standby") describes that the device is not functioning but could 
   /// be brought to full power 'quickly'; and value 17 ("Power Save - Warning") 
   /// indicates that the device is in a warning state, though also in a power save 
   /// mode.
   /// </summary>
   {$ENDREGION}
   property Availability : Word read FAvailability;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Binary property indicates whether the serial port is configured for binary 
   /// data transfer. Since the Win32 API does not support non-binary mode transfers, 
   /// this property must be TRUE. Specifying FALSE will not work. Values: TRUE or 
   /// FALSE. A value of TRUE indicates the serial port is configured for binary data 
   /// transfer.
   /// </summary>
   {$ENDREGION}
   property Binary : Boolean read FBinary;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Capabilities property defines chip level compatibility for the serial 
   /// controller.  Therefore, this property describes the buffering and other 
   /// capabilities of the serial controller, that may be inherent in the chip 
   /// hardware. The property is an enumerated integer.
   /// </summary>
   {$ENDREGION}
   property Capabilities : TWordArray read FCapabilities;
   {$REGION 'Documentation'}
   /// <summary>
   /// An array of free-form strings providing more detailed explanations for any of 
   /// the serial controller features indicated in the Capabilities array. Note, each 
   /// entry of this array is related to the entry in the Capabilities array that is 
   /// located at the same index.
   /// </summary>
   {$ENDREGION}
   property CapabilityDescriptions : TStrings read FCapabilityDescriptions;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Caption property is a short textual description (one-line string) of the 
   /// object.
   /// </summary>
   {$ENDREGION}
   property Caption : String read FCaption;
   {$REGION 'Documentation'}
   /// <summary>
   /// Indicates the Win32 Configuration Manager error code.  The following values may be returned: 
   /// 0      This device is working properly. 
   /// 1      This device is not configured correctly. 
   /// 2      Windows cannot load the driver for this device. 
   /// 3      The driver for this device might be corrupted, or your system may be running low on memory or other resources. 
   /// 4      This device is not working properly. One of its drivers or your registry might be corrupted. 
   /// 5      The driver for this device needs a resource that Windows cannot manage. 
   /// 6      The boot configuration for this device conflicts with other devices. 
   /// 7      Cannot filter. 
   /// 8      The driver loader for the device is missing. 
   /// 9      This device is not working properly because the controlling firmware is reporting the resources for the device incorrectly. 
   /// 10     This device cannot start. 
   /// 11     This device failed. 
   /// 12     This device cannot find enough free resources that it can use. 
   /// 13     Windows cannot verify this device's resources. 
   /// 14     This device cannot work properly until you restart your computer. 
   /// 15     This device is not working properly because there is probably a re-enumeration problem. 
   /// 16     Windows cannot identify all the resources this device uses. 
   /// 17     This device is asking for an unknown resource type. 
   /// 18     Reinstall the drivers for this device. 
   /// 19     Your registry might be corrupted. 
   /// 20     Failure using the VxD loader. 
   /// 21     System failure: Try changing the driver for this device. If that does not work, see your hardware documentation. Windows is removing this device. 
   /// 22     This device is disabled. 
   /// 23     System failure: Try changing the driver for this device. If that doesn't work, see your hardware documentation. 
   /// 24     This device is not present, is not working properly, or does not have all its drivers installed. 
   /// 25     Windows is still setting up this device. 
   /// 26     Windows is still setting up this device. 
   /// 27     This device does not have valid log configuration. 
   /// 28     The drivers for this device are not installed. 
   /// 29     This device is disabled because the firmware of the device did not give it the required resources. 
   /// 30     This device is using an Interrupt Request (IRQ) resource that another device is using. 
   /// 31     This device is not working properly because Windows cannot load the drivers required for this device.
   /// </summary>
   {$ENDREGION}
   property ConfigManagerErrorCode : Cardinal read FConfigManagerErrorCode;
   {$REGION 'Documentation'}
   /// <summary>
   /// Indicates whether the device is using a user-defined configuration.
   /// </summary>
   {$ENDREGION}
   property ConfigManagerUserConfig : Boolean read FConfigManagerUserConfig;
   {$REGION 'Documentation'}
   /// <summary>
   /// CreationClassName indicates the name of the class or the subclass used in the 
   /// creation of an instance. When used with the other key properties of this class, 
   /// this property allows all instances of this class and its subclasses to be 
   /// uniquely identified.
   /// </summary>
   {$ENDREGION}
   property CreationClassName : String read FCreationClassName;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Description property provides a textual description of the object. 
   /// </summary>
   {$ENDREGION}
   property Description : String read FDescription;
   {$REGION 'Documentation'}
   /// <summary>
   /// The DeviceID property contains a string uniquely identifying the serial port 
   /// with other devices on the system.
   /// </summary>
   {$ENDREGION}
   property DeviceID : String read FDeviceID;
   {$REGION 'Documentation'}
   /// <summary>
   /// ErrorCleared is a boolean property indicating that the error reported in 
   /// LastErrorCode property is now cleared.
   /// </summary>
   {$ENDREGION}
   property ErrorCleared : Boolean read FErrorCleared;
   {$REGION 'Documentation'}
   /// <summary>
   /// ErrorDescription is a free-form string supplying more information about the 
   /// error recorded in LastErrorCode property, and information on any corrective 
   /// actions that may be taken.
   /// </summary>
   {$ENDREGION}
   property ErrorDescription : String read FErrorDescription;
   {$REGION 'Documentation'}
   /// <summary>
   /// The InstallDate property is datetime value indicating when the object was 
   /// installed. A lack of a value does not indicate that the object is not installed.
   /// </summary>
   {$ENDREGION}
   property InstallDate : TDateTime read FInstallDate;
   {$REGION 'Documentation'}
   /// <summary>
   /// LastErrorCode captures the last error code reported by the logical device.
   /// </summary>
   {$ENDREGION}
   property LastErrorCode : Cardinal read FLastErrorCode;
   {$REGION 'Documentation'}
   /// <summary>
   /// Maximum baud rate in bits per second supported by the SerialController.
   /// </summary>
   {$ENDREGION}
   property MaxBaudRate : Cardinal read FMaxBaudRate;
   {$REGION 'Documentation'}
   /// <summary>
   /// The MaximumInputBufferSize property specifies the maximum size of the serial 
   /// port driver's internal input buffer. A value of zero indicates that no maximum value is imposed by the serial provider.
   /// </summary>
   {$ENDREGION}
   property MaximumInputBufferSize : Cardinal read FMaximumInputBufferSize;
   {$REGION 'Documentation'}
   /// <summary>
   /// The MaximumOutputBufferSize property specifies the maximum size of the serial 
   /// port driver's internal output buffer. A value of zero indicates that no maximum value is imposed by the serial provider.
   /// </summary>
   {$ENDREGION}
   property MaximumOutputBufferSize : Cardinal read FMaximumOutputBufferSize;
   {$REGION 'Documentation'}
   /// <summary>
   /// Maximum number of directly addressable entities supported by this Controller.  
   /// A value of 0 should be used if the number is unknown or unlimited.
   /// </summary>
   {$ENDREGION}
   property MaxNumberControlled : Cardinal read FMaxNumberControlled;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Name property defines the label by which the object is known. When 
   /// subclassed, the Name property can be overridden to be a Key property.
   /// </summary>
   {$ENDREGION}
   property Name : String read FName;
   {$REGION 'Documentation'}
   /// <summary>
   /// The OSAutoDiscovered property distinguishes the instances of this class that 
   /// were automatically discovered by the operating system. If, for example, 
   /// hardware was added through the Control Panel, the operating system finds 
   /// instances of this class by querying hardware from the instances of this class. 
   /// A value of TRUE indicates that the instance was automatically discovered.
   /// </summary>
   {$ENDREGION}
   property OSAutoDiscovered : Boolean read FOSAutoDiscovered;
   {$REGION 'Documentation'}
   /// <summary>
   /// Indicates the Win32 Plug and Play device ID of the logical device.  Example: 
   /// *PNP030b
   /// </summary>
   {$ENDREGION}
   property PNPDeviceID : String read FPNPDeviceID;
   {$REGION 'Documentation'}
   /// <summary>
   /// Indicates the specific power-related capabilities of the logical device. The 
   /// array values, 0="Unknown", 1="Not Supported" and 2="Disabled" are self-
   /// explanatory. The value, 3="Enabled" indicates that the power management 
   /// features are currently enabled but the exact feature set is unknown or the 
   /// information is unavailable. "Power Saving Modes Entered Automatically" (4) 
   /// describes that a device can change its power state based on usage or other 
   /// criteria. "Power State Settable" (5) indicates that the SetPowerState method is 
   /// supported. "Power Cycling Supported" (6) indicates that the SetPowerState 
   /// method can be invoked with the PowerState input variable set to 5 
   /// ("Power Cycle"). "Timed Power On Supported" (7) indicates that the 
   /// SetPowerState method can be invoked with the PowerState input variable set to 5 
   /// ("Power Cycle") and the Time parameter set to a specific date and time, or 
   /// interval, for power-on.
   /// </summary>
   {$ENDREGION}
   property PowerManagementCapabilities : TWordArray read FPowerManagementCapabilities;
   {$REGION 'Documentation'}
   /// <summary>
   /// Boolean indicating that the Device can be power managed - ie, put into a power 
   /// save state. This boolean does not indicate that power management features are 
   /// currently enabled, or if enabled, what features are supported. Refer to the 
   /// PowerManagementCapabilities array for this information. If this boolean is 
   /// false, the integer value 1, for the string, "Not Supported", should be the only 
   /// entry in the PowerManagementCapabilities array.
   /// </summary>
   {$ENDREGION}
   property PowerManagementSupported : Boolean read FPowerManagementSupported;
   {$REGION 'Documentation'}
   /// <summary>
   /// The protocol used by the controller to access 'controlled' devices.
   /// </summary>
   {$ENDREGION}
   property ProtocolSupported : Word read FProtocolSupported;
   {$REGION 'Documentation'}
   /// <summary>
   /// The ProviderType property specifies the communications provider type.
   /// </summary>
   {$ENDREGION}
   property ProviderType : String read FProviderType;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableBaudRate property indicates whether the baud rate can be changed for this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates the baud rate can be changed.
   /// </summary>
   {$ENDREGION}
   property SettableBaudRate : Boolean read FSettableBaudRate;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableDataBits property indicates whether data bits can be set for this serial port.
   /// Values: TRUE or FALSE. A value of  TRUE indicates the data bits can be set.
   /// </summary>
   {$ENDREGION}
   property SettableDataBits : Boolean read FSettableDataBits;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableFlowControl property indicates whether flow control can be set for this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates the flow control can be set.
   /// </summary>
   {$ENDREGION}
   property SettableFlowControl : Boolean read FSettableFlowControl;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableParity property indicates whether parity can be set for this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates the parity can be set.
   /// </summary>
   {$ENDREGION}
   property SettableParity : Boolean read FSettableParity;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableParityCheck property indicates whether parity checking can be set for this serial port (if parity checking is supported). 
   /// Values: TRUE or FALSE. A value of TRUE indicates parity checking can be set.
   /// </summary>
   {$ENDREGION}
   property SettableParityCheck : Boolean read FSettableParityCheck;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableRLSD property indicates whether RLSD can be set for this serial port (if Received Line Signal Detect (RLSD) is supported). 
   /// Values: TRUE or FALSE.  A value of TRUE indicates the RLSD can be set.
   /// </summary>
   {$ENDREGION}
   property SettableRLSD : Boolean read FSettableRLSD;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SettableStopBits property indicates whether stop bits can be set for this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates the stop bits can be set.
   /// </summary>
   {$ENDREGION}
   property SettableStopBits : Boolean read FSettableStopBits;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Status property is a string indicating the current status of the object. 
   /// Various operational and non-operational statuses can be defined. Operational 
   /// statuses are "OK", "Degraded" and "Pred Fail". "Pred Fail" indicates that an 
   /// element may be functioning properly but predicting a failure in the near 
   /// future. An example is a SMART-enabled hard drive. Non-operational statuses can 
   /// also be specified. These are "Error", "Starting", "Stopping" and "Service". The 
   /// latter, "Service", could apply during mirror-resilvering of a disk, reload of a 
   /// user permissions list, or other administrative work. Not all such work is on-
   /// line, yet the managed element is neither "OK" nor in one of the other states.
   /// </summary>
   {$ENDREGION}
   property Status : String read FStatus;
   {$REGION 'Documentation'}
   /// <summary>
   /// StatusInfo is a string indicating whether the logical device is in an enabled 
   /// (value = 3), disabled (value = 4) or some other (1) or unknown (2) state. If 
   /// this property does not apply to the logical device, the value, 5 
   /// ("Not Applicable"), should be used.
   /// </summary>
   {$ENDREGION}
   property StatusInfo : Word read FStatusInfo;
   {$REGION 'Documentation'}
   /// <summary>
   /// The Supports16BitMode property indicates whether 16-bit mode is supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates 16-bit mode is supported.
   /// </summary>
   {$ENDREGION}
   property Supports16BitMode : Boolean read FSupports16BitMode;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsDTRDSR property indicates whether Data Terminal Ready (DTR) and Data Set Ready (DSR) signals are supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates DTR and DSR signals are supported.
   /// </summary>
   {$ENDREGION}
   property SupportsDTRDSR : Boolean read FSupportsDTRDSR;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsElapsedTimeouts property indicates whether elapsed timeouts are supported on this serial port. Elapsed timeouts track the total amount of time between data transmissions.
   /// Values: TRUE or FALSE.  A value of TRUE indicates elapsed timeouts are supported.
   /// </summary>
   {$ENDREGION}
   property SupportsElapsedTimeouts : Boolean read FSupportsElapsedTimeouts;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsIntTimeouts property indicates whether interval time-outs are supported. An interval timeout is the amount of time allowed to elapse between the arrival of each piece of data.
   /// Values: TRUE or FALSE. A value of TRUE indicates interval timeouts are supported.
   /// </summary>
   {$ENDREGION}
   property SupportsIntTimeouts : Boolean read FSupportsIntTimeouts;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsParityCheck property indicates whether parity checking is supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates parity checking is supported.
   /// </summary>
   {$ENDREGION}
   property SupportsParityCheck : Boolean read FSupportsParityCheck;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsRLSD property indicates whether Received Line Signal Detect (RLSD) is supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates RLSD is supported.
   /// </summary>
   {$ENDREGION}
   property SupportsRLSD : Boolean read FSupportsRLSD;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsRTSCTS property indicates whether Ready To Send (RTS) and Clear To Send (CTS) signals are supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates RTS and CTS signals are supported.
   /// </summary>
   {$ENDREGION}
   property SupportsRTSCTS : Boolean read FSupportsRTSCTS;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsSpecialCharacters property indicates whether serial port control characters are supported. These characters signal events rather than data. These characters are not displayable and are set by the driver. They include EofChar, ErrorChar, BreakChar, EventChar, XonChar, and XoffChar.
   /// Values: TRUE or FALSE. A value of TRUE indicates special characters are supported.
   /// </summary>
   {$ENDREGION}
   property SupportsSpecialCharacters : Boolean read FSupportsSpecialCharacters;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsXOnXOff property indicates whether XON/XOFF flow control is supported on this serial port.
   /// Values: TRUE or FALSE. A value of TRUE indicates XON/XOFF is supported.
   /// </summary>
   {$ENDREGION}
   property SupportsXOnXOff : Boolean read FSupportsXOnXOff;
   {$REGION 'Documentation'}
   /// <summary>
   /// The SupportsXOnXOffSet property indicates whether the communications provider supports configuration of the XON/XOFF flow control setting.
   /// Values: TRUE or FALSE. A value of TRUE indicates  XON/XOFF flow control setting is supported.
   /// </summary>
   {$ENDREGION}
   property SupportsXOnXOffSet : Boolean read FSupportsXOnXOffSet;
   {$REGION 'Documentation'}
   /// <summary>
   /// The scoping System's CreationClassName.
   /// </summary>
   {$ENDREGION}
   property SystemCreationClassName : String read FSystemCreationClassName;
   {$REGION 'Documentation'}
   /// <summary>
   /// The scoping System's Name.
   /// </summary>
   {$ENDREGION}
   property SystemName : String read FSystemName;
   {$REGION 'Documentation'}
   /// <summary>
   /// The TimeOfLastReset property indicates the date and time this controller was 
   /// last reset.  This could mean the controller was powered down, or reinitialized.
   /// </summary>
   {$ENDREGION}
   property TimeOfLastReset : TDateTime read FTimeOfLastReset;
   {$REGION 'Documentation'}
   /// <summary>
   /// SetPowerState defines the desired power state for a logical device and when a 
   /// device should be put into that state. The desired power state is specified by 
   /// setting the PowerState parameter to one of the following integer values: 
   /// 1="Full Power", 2="Power Save - Low Power Mode", 3="Power Save - Standby", 
   /// 4="Power Save - Other", 5="Power Cycle" or 6="Power Off". The Time parameter 
   /// (for all state changes, except 5, "Power Cycle") indicates when the power state 
   /// should be set, either as a regular date-time value or as an interval value 
   /// (where the interval begins when the method invocation is received). When the 
   /// PowerState parameter is equal to 5, "Power Cycle", the Time parameter indicates 
   /// when the device should power on again. Power off is immediate. SetPowerState 
   /// should return 0 if successful, 1 if the specified PowerState and Time request 
   /// is not supported, and some other value if any other error occurred. In a 
   /// subclass, the set of possible return codes could be specified, using a ValueMap 
   /// qualifier on the method. The strings to which the ValueMap contents are 
   /// 'translated' may also be specified in the subclass as a Values array qualifier.
   /// </summary>
   {$ENDREGION}
   function SetPowerState(const PowerState : Word;const Time : TDateTime): Integer;
   {$REGION 'Documentation'}
   /// <summary>
   /// Requests a reset of the logical device. The return value should be 0 if the 
   /// request was successfully executed, 1 if the request is not supported and some 
   /// other value if an error occurred.
   /// </summary>
   {$ENDREGION}
   function Reset: Integer;
   procedure SetCollectionIndex(Index : Integer); override;
  end;


  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.Availability
  /// </summary>
  {$ENDREGION}
  function GetAvailabilityAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.Capabilities
  /// </summary>
  {$ENDREGION}
  function GetCapabilitiesAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.ConfigManagerErrorCode
  /// </summary>
  {$ENDREGION}
  function GetConfigManagerErrorCodeAsString(const APropValue:Cardinal) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.PowerManagementCapabilities
  /// </summary>
  {$ENDREGION}
  function GetPowerManagementCapabilitiesAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.ProtocolSupported
  /// </summary>
  {$ENDREGION}
  function GetProtocolSupportedAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_SerialPort.StatusInfo
  /// </summary>
  {$ENDREGION}
  function GetStatusInfoAsString(const APropValue:Word) : string;

implementation


function GetAvailabilityAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    1 : Result:='Other';
    2 : Result:='Unknown';
    3 : Result:='Running/Full Power';
    4 : Result:='Warning';
    5 : Result:='In Test';
    6 : Result:='Not Applicable';
    7 : Result:='Power Off';
    8 : Result:='Off Line';
    9 : Result:='Off Duty';
    10 : Result:='Degraded';
    11 : Result:='Not Installed';
    12 : Result:='Install Error';
    13 : Result:='Power Save - Unknown';
    14 : Result:='Power Save - Low Power Mode';
    15 : Result:='Power Save - Standby';
    16 : Result:='Power Cycle';
    17 : Result:='Power Save - Warning';
    18 : Result:='Paused';
    19 : Result:='Not Ready';
    20 : Result:='Not Configured';
    21 : Result:='Quiesced';
  end;
end;

function GetCapabilitiesAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    1 : Result:='Other';
    2 : Result:='Unknown';
    3 : Result:='XT/AT Compatible';
    4 : Result:='16450 Compatible';
    5 : Result:='16550 Compatible';
    6 : Result:='16550A Compatible';
    160 : Result:='8251 Compatible';
    161 : Result:='8251FIFO Compatible';
  end;
end;

function GetConfigManagerErrorCodeAsString(const APropValue:Cardinal) : string;
begin
Result:='';
  case APropValue of
    0 : Result:='This device is working properly.';
    1 : Result:='This device is not configured correctly.';
    2 : Result:='Windows cannot load the driver for this device.';
    3 : Result:='The driver for this device might be corrupted, or your system may be running low on memory or other resources.';
    4 : Result:='This device is not working properly. One of its drivers or your registry might be corrupted.';
    5 : Result:='The driver for this device needs a resource that Windows cannot manage.';
    6 : Result:='The boot configuration for this device conflicts with other devices.';
    7 : Result:='Cannot filter.';
    8 : Result:='The driver loader for the device is missing.';
    9 : Result:='This device is not working properly because the controlling firmware is reporting the resources for the device incorrectly.';
    10 : Result:='This device cannot start.';
    11 : Result:='This device failed.';
    12 : Result:='This device cannot find enough free resources that it can use.';
    13 : Result:='Windows cannot verify this device''s resources.';
    14 : Result:='This device cannot work properly until you restart your computer.';
    15 : Result:='This device is not working properly because there is probably a re-enumeration problem.';
    16 : Result:='Windows cannot identify all the resources this device uses.';
    17 : Result:='This device is asking for an unknown resource type.';
    18 : Result:='Reinstall the drivers for this device.';
    19 : Result:='Failure using the VxD loader.';
    20 : Result:='Your registry might be corrupted.';
    21 : Result:='System failure: Try changing the driver for this device. If that does not work, see your hardware documentation. Windows is removing this device.';
    22 : Result:='This device is disabled.';
    23 : Result:='System failure: Try changing the driver for this device. If that doesn''t work, see your hardware documentation.';
    24 : Result:='This device is not present, is not working properly, or does not have all its drivers installed.';
    25 : Result:='Windows is still setting up this device.';
    26 : Result:='Windows is still setting up this device.';
    27 : Result:='This device does not have valid log configuration.';
    28 : Result:='The drivers for this device are not installed.';
    29 : Result:='This device is disabled because the firmware of the device did not give it the required resources.';
    30 : Result:='This device is using an Interrupt Request (IRQ) resource that another device is using.';
    31 : Result:='This device is not working properly because Windows cannot load the drivers required for this device.';
  end;
end;

function GetPowerManagementCapabilitiesAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    0 : Result:='Unknown';
    1 : Result:='Not Supported';
    2 : Result:='Disabled';
    3 : Result:='Enabled';
    4 : Result:='Power Saving Modes Entered Automatically';
    5 : Result:='Power State Settable';
    6 : Result:='Power Cycling Supported';
    7 : Result:='Timed Power On Supported';
  end;
end;

function GetProtocolSupportedAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    1 : Result:='Other';
    2 : Result:='Unknown';
    3 : Result:='EISA';
    4 : Result:='ISA';
    5 : Result:='PCI';
    6 : Result:='ATA/ATAPI';
    7 : Result:='Flexible Diskette';
    8 : Result:='1496';
    9 : Result:='SCSI Parallel Interface';
    10 : Result:='SCSI Fibre Channel Protocol';
    11 : Result:='SCSI Serial Bus Protocol';
    12 : Result:='SCSI Serial Bus Protocol-2 (1394)';
    13 : Result:='SCSI Serial Storage Architecture';
    14 : Result:='VESA';
    15 : Result:='PCMCIA';
    16 : Result:='Universal Serial Bus';
    17 : Result:='Parallel Protocol';
    18 : Result:='ESCON';
    19 : Result:='Diagnostic';
    20 : Result:='I2C';
    21 : Result:='Power';
    22 : Result:='HIPPI';
    23 : Result:='MultiBus';
    24 : Result:='VME';
    25 : Result:='IPI';
    26 : Result:='IEEE-488';
    27 : Result:='RS232';
    28 : Result:='IEEE 802.3 10BASE5';
    29 : Result:='IEEE 802.3 10BASE2';
    30 : Result:='IEEE 802.3 1BASE5';
    31 : Result:='IEEE 802.3 10BROAD36';
    32 : Result:='IEEE 802.3 100BASEVG';
    33 : Result:='IEEE 802.5 Token-Ring';
    34 : Result:='ANSI X3T9.5 FDDI';
    35 : Result:='MCA';
    36 : Result:='ESDI';
    37 : Result:='IDE';
    38 : Result:='CMD';
    39 : Result:='ST506';
    40 : Result:='DSSI';
    41 : Result:='QIC2';
    42 : Result:='Enhanced ATA/IDE';
    43 : Result:='AGP';
    44 : Result:='TWIRP (two-way infrared)';
    45 : Result:='FIR (fast infrared)';
    46 : Result:='SIR (serial infrared)';
    47 : Result:='IrBus';
  end;
end;

function GetStatusInfoAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    1 : Result:='Other';
    2 : Result:='Unknown';
    3 : Result:='Enabled';
    4 : Result:='Disabled';
    5 : Result:='Not Applicable';
  end;
end;

{TWin32_SerialPort}

constructor TWin32_SerialPort.Create(LoadWmiData : boolean=True);
begin
  SetLength(FCapabilities,0);
  FCapabilityDescriptions:=TStringList.Create;
  SetLength(FPowerManagementCapabilities,0);
  inherited Create(LoadWmiData,'root\CIMV2','Win32_SerialPort');
end;

destructor TWin32_SerialPort.Destroy;
begin
  SetLength(FCapabilities,0);
  FCapabilityDescriptions.Free;
  SetLength(FPowerManagementCapabilities,0);
  inherited;
end;

procedure TWin32_SerialPort.SetCollectionIndex(Index : Integer);
begin
  if (Index>=0) and (Index<=FWmiCollection.Count-1) and (FWmiCollectionIndex<>Index) then
  begin
    FWmiCollectionIndex:=Index;
    FAvailability                     := VarWordNull(inherited Value['Availability']);
    FBinary                           := VarBoolNull(inherited Value['Binary']);
    VarArrayToArray(inherited Value['Capabilities'],FCapabilities);
    VarArrayToArray(inherited Value['CapabilityDescriptions'],FCapabilityDescriptions);
    FCaption                          := VarStrNull(inherited Value['Caption']);
    FConfigManagerErrorCode           := VarCardinalNull(inherited Value['ConfigManagerErrorCode']);
    FConfigManagerUserConfig          := VarBoolNull(inherited Value['ConfigManagerUserConfig']);
    FCreationClassName                := VarStrNull(inherited Value['CreationClassName']);
    FDescription                      := VarStrNull(inherited Value['Description']);
    FDeviceID                         := VarStrNull(inherited Value['DeviceID']);
    FErrorCleared                     := VarBoolNull(inherited Value['ErrorCleared']);
    FErrorDescription                 := VarStrNull(inherited Value['ErrorDescription']);
    FInstallDate                      := VarDateTimeNull(inherited Value['InstallDate']);
    FLastErrorCode                    := VarCardinalNull(inherited Value['LastErrorCode']);
    FMaxBaudRate                      := VarCardinalNull(inherited Value['MaxBaudRate']);
    FMaximumInputBufferSize           := VarCardinalNull(inherited Value['MaximumInputBufferSize']);
    FMaximumOutputBufferSize          := VarCardinalNull(inherited Value['MaximumOutputBufferSize']);
    FMaxNumberControlled              := VarCardinalNull(inherited Value['MaxNumberControlled']);
    FName                             := VarStrNull(inherited Value['Name']);
    FOSAutoDiscovered                 := VarBoolNull(inherited Value['OSAutoDiscovered']);
    FPNPDeviceID                      := VarStrNull(inherited Value['PNPDeviceID']);
    VarArrayToArray(inherited Value['PowerManagementCapabilities'],FPowerManagementCapabilities);
    FPowerManagementSupported         := VarBoolNull(inherited Value['PowerManagementSupported']);
    FProtocolSupported                := VarWordNull(inherited Value['ProtocolSupported']);
    FProviderType                     := VarStrNull(inherited Value['ProviderType']);
    FSettableBaudRate                 := VarBoolNull(inherited Value['SettableBaudRate']);
    FSettableDataBits                 := VarBoolNull(inherited Value['SettableDataBits']);
    FSettableFlowControl              := VarBoolNull(inherited Value['SettableFlowControl']);
    FSettableParity                   := VarBoolNull(inherited Value['SettableParity']);
    FSettableParityCheck              := VarBoolNull(inherited Value['SettableParityCheck']);
    FSettableRLSD                     := VarBoolNull(inherited Value['SettableRLSD']);
    FSettableStopBits                 := VarBoolNull(inherited Value['SettableStopBits']);
    FStatus                           := VarStrNull(inherited Value['Status']);
    FStatusInfo                       := VarWordNull(inherited Value['StatusInfo']);
    FSupports16BitMode                := VarBoolNull(inherited Value['Supports16BitMode']);
    FSupportsDTRDSR                   := VarBoolNull(inherited Value['SupportsDTRDSR']);
    FSupportsElapsedTimeouts          := VarBoolNull(inherited Value['SupportsElapsedTimeouts']);
    FSupportsIntTimeouts              := VarBoolNull(inherited Value['SupportsIntTimeouts']);
    FSupportsParityCheck              := VarBoolNull(inherited Value['SupportsParityCheck']);
    FSupportsRLSD                     := VarBoolNull(inherited Value['SupportsRLSD']);
    FSupportsRTSCTS                   := VarBoolNull(inherited Value['SupportsRTSCTS']);
    FSupportsSpecialCharacters        := VarBoolNull(inherited Value['SupportsSpecialCharacters']);
    FSupportsXOnXOff                  := VarBoolNull(inherited Value['SupportsXOnXOff']);
    FSupportsXOnXOffSet               := VarBoolNull(inherited Value['SupportsXOnXOffSet']);
    FSystemCreationClassName          := VarStrNull(inherited Value['SystemCreationClassName']);
    FSystemName                       := VarStrNull(inherited Value['SystemName']);
    FTimeOfLastReset                  := VarDateTimeNull(inherited Value['TimeOfLastReset']);
  end;
end;


//not static, OutParams=1, InParams>0
function TWin32_SerialPort.SetPowerState(const PowerState : Word;const Time : TDateTime): Integer;
var
  ReturnValue : OleVariant;
begin
  ReturnValue := GetInstanceOf.SetPowerState(PowerState,DateTimeToUTC(Time));
  Result      := VarIntegerNull(ReturnValue);
end;


//not static, OutParams=1, InParams=0
function TWin32_SerialPort.Reset: integer;
var
  ReturnValue : OleVariant;
begin
  ReturnValue := GetInstanceOf.Reset;
  Result      := VarIntegerNull(ReturnValue);
end;
end.
