/// <summary>
/// Unit generated using the Delphi Wmi class generator tool, Copyright Rodrigo Ruz V. 2010-2012
/// Application version 1.0.4674.62299
/// WMI version 7601.17514
/// Creation Date 17-10-2012 18:18:20
/// Namespace root\CIMV2 Class Win32_DirectorySpecification
/// MSDN info about this class http://msdn2.microsoft.com/library/default.asp?url=/library/en-us/wmisdk/wmi/Win32_DirectorySpecification.asp
/// </summary>


unit uWin32_DirectorySpecification;

interface

uses
 Classes,
 Activex,
 Variants,
 ComObj,
 uWmiDelphiClass;

type
  {$REGION 'Documentation'}
  /// <summary>
  /// This class represents the directory layout for the product. Each instance of 
  /// the class represents a directory in both the source image and the destination 
  /// image. Directory resolution is performed during the CostFinalize action and is 
  /// done as follows: Root destination directories: Root directories entries are 
  /// those with a null Directory_Parent value or a Directory_Parent value identical 
  /// to the Directory value. The value in the Directory property is interpreted as 
  /// the name of a property defining the location of the destination directory. If 
  /// the property is defined, the destination directory is resolved to the 
  /// property's value. If the property is undefined, the ROOTDRIVE property is used instead to resolve the path. Root source directorires: The value of the DefaultDir column for root entries is interpreted as the name of a property defining the source location of this directory. This property must be defined or an error will occur. Non-root destination directories: The Directory value for a non-root directory is also interpreted as the name of a property defining the location of the destination. If the property is defined, the destination directory is resolved to the property's 
  /// value. If the property is not defined, the destination directory is resolved to 
  /// a sub-directory beneath the resolved destination directory for the 
  /// Directory_Parent entry. The DefaultDir value defines the name of the sub-
  /// directory.  Non-root source directories: The source directory for a non-root 
  /// directory is resolved to a sub-directory of the resolved source directory for 
  /// the Directory_Parent entry. Again, the DefaultDir value defines the name of the 
  /// sub-directory.
  /// </summary>
  {$ENDREGION}
  TWin32_DirectorySpecification=class(TWmiClass)
  private
    FCaption                            : String;
    FCheckID                            : String;
    FCheckMode                          : Boolean;
    FDefaultDir                         : String;
    FDescription                        : String;
    FDirectory                          : String;
    FDirectoryPath                      : String;
    FDirectoryType                      : Word;
    FName                               : String;
    FSoftwareElementID                  : String;
    FSoftwareElementState               : Word;
    FTargetOperatingSystem              : Word;
    FVersion                            : String;
  public
   constructor Create(LoadWmiData : boolean=True); overload;
   destructor Destroy;Override;
   property Caption : String read FCaption;
   {$REGION 'Documentation'}
   /// <summary>
   /// An identifier used in conjunction with other keys to uniquely identify the check
   /// </summary>
   {$ENDREGION}
   property CheckID : String read FCheckID;
   {$REGION 'Documentation'}
   /// <summary>
   ///  The CheckMode property is used to indicate whether the condition is  expected 
   /// to exist or not exist in the environment.  When the value is True, the 
   /// condition is expected to exist  (e.g., a file is expected to be on a system) so 
   /// invoke() is expected to  return True.  When the value is False, the condition 
   /// is not expect to exist  (e.g., a file is not to be on a system) so invoke is 
   /// expected to return false 
   /// </summary>
   {$ENDREGION}
   property CheckMode : Boolean read FCheckMode;
   property DefaultDir : String read FDefaultDir;
   {$REGION 'Documentation'}
   /// <summary>
   ///  A description of the objects.
   /// </summary>
   {$ENDREGION}
   property Description : String read FDescription;
   property Directory : String read FDirectory;
   {$REGION 'Documentation'}
   /// <summary>
   /// The DirectoryPath property is used to capture the name of a directory.  The 
   /// value supplied by an application provider is actually a default or recommended 
   /// path name.  The value can be changed for a particular environment.
   /// </summary>
   {$ENDREGION}
   property DirectoryPath : String read FDirectoryPath;
   {$REGION 'Documentation'}
   /// <summary>
   ///  The DirectoryType property characterizes the type of directory being  
   /// described. 
   /// </summary>
   {$ENDREGION}
   property DirectoryType : Word read FDirectoryType;
   {$REGION 'Documentation'}
   /// <summary>
   /// The name used to identify this software element
   /// </summary>
   {$ENDREGION}
   property Name : String read FName;
   {$REGION 'Documentation'}
   /// <summary>
   ///  This is an identifier for this software element.
   /// </summary>
   {$ENDREGION}
   property SoftwareElementID : String read FSoftwareElementID;
   {$REGION 'Documentation'}
   /// <summary>
   ///  The software element state of a software element 
   /// </summary>
   {$ENDREGION}
   property SoftwareElementState : Word read FSoftwareElementState;
   {$REGION 'Documentation'}
   /// <summary>
   ///  The target operating system of the this software element.
   /// </summary>
   {$ENDREGION}
   property TargetOperatingSystem : Word read FTargetOperatingSystem;
   {$REGION 'Documentation'}
   /// <summary>
   /// Version should be in the form <Major>.<Minor>.<Revision> or 
   /// <Major>.<Minor><letter><revision>
   /// </summary>
   {$ENDREGION}
   property Version : String read FVersion;
   {$REGION 'Documentation'}
   /// <summary>
   ///  The invoke method is to evaluate a particular check. The  details of how the 
   /// method evaluates a particular check in   a CIM context is described by the non-
   /// abstract CIM_Check sub classes.  The results of the method are based on the 
   /// return value.    - A 0 (zero) is returned if the condition is satisfied.   - A 
   /// 1 (one) is returned if the method is not supported.    - Any other value 
   /// indicates the condition is not satisfied. 
   /// </summary>
   {$ENDREGION}
   function Invoke: Integer;
   procedure SetCollectionIndex(Index : Integer); override;
  end;


  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_DirectorySpecification.DirectoryType
  /// </summary>
  {$ENDREGION}
  function GetDirectoryTypeAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_DirectorySpecification.SoftwareElementState
  /// </summary>
  {$ENDREGION}
  function GetSoftwareElementStateAsString(const APropValue:Word) : string;
  {$REGION 'Documentation'}
  /// <summary>
  /// Return the description for the value of the property 
  /// TWin32_DirectorySpecification.TargetOperatingSystem
  /// </summary>
  {$ENDREGION}
  function GetTargetOperatingSystemAsString(const APropValue:Word) : string;

implementation


function GetDirectoryTypeAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    0 : Result:='Product base directory';
    1 : Result:='Product executable directory';
    2 : Result:='Product library directory';
    3 : Result:='Product configuration directory';
    4 : Result:='Product include directory';
    5 : Result:='Product working directory';
    6 : Result:='Product log directory';
    7 : Result:='Shared base directory';
    8 : Result:='Shared executable directory';
    9 : Result:='Shared library directory';
    10 : Result:='Shared include directory';
    11 : Result:='System base directory';
    12 : Result:='System executable directory';
    13 : Result:='System library directory';
    14 : Result:='System configuration directory';
    15 : Result:='System include directory';
    16 : Result:='System log directory';
    17 : Result:='Other';
  end;
end;

function GetSoftwareElementStateAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    0 : Result:='Deployable';
    1 : Result:='Installable';
    2 : Result:='Executable';
    3 : Result:='Running';
  end;
end;

function GetTargetOperatingSystemAsString(const APropValue:Word) : string;
begin
Result:='';
  case APropValue of
    0 : Result:='Unknown';
    1 : Result:='Other';
    2 : Result:='MACOS';
    3 : Result:='ATTUNIX';
    4 : Result:='DGUX';
    5 : Result:='DECNT';
    6 : Result:='Digital Unix';
    7 : Result:='OpenVMS';
    8 : Result:='HPUX';
    9 : Result:='AIX';
    10 : Result:='MVS';
    11 : Result:='OS400';
    12 : Result:='OS/2';
    13 : Result:='JavaVM';
    14 : Result:='MSDOS';
    15 : Result:='WIN3x';
    16 : Result:='WIN95';
    17 : Result:='WIN98';
    18 : Result:='WINNT';
    19 : Result:='WINCE';
    20 : Result:='NCR3000';
    21 : Result:='NetWare';
    22 : Result:='OSF';
    23 : Result:='DC/OS';
    24 : Result:='Reliant UNIX';
    25 : Result:='SCO UnixWare';
    26 : Result:='SCO OpenServer';
    27 : Result:='Sequent';
    28 : Result:='IRIX';
    29 : Result:='Solaris';
    30 : Result:='SunOS';
    31 : Result:='U6000';
    32 : Result:='ASERIES';
    33 : Result:='TandemNSK';
    34 : Result:='TandemNT';
    35 : Result:='BS2000';
    36 : Result:='LINUX';
    37 : Result:='Lynx';
    38 : Result:='XENIX';
    39 : Result:='VM/ESA';
    40 : Result:='Interactive UNIX';
    41 : Result:='BSDUNIX';
    42 : Result:='FreeBSD';
    43 : Result:='NetBSD';
    44 : Result:='GNU Hurd';
    45 : Result:='OS9';
    46 : Result:='MACH Kernel';
    47 : Result:='Inferno';
    48 : Result:='QNX';
    49 : Result:='EPOC';
    50 : Result:='IxWorks';
    51 : Result:='VxWorks';
    52 : Result:='MiNT';
    53 : Result:='BeOS';
    54 : Result:='HP MPE';
    55 : Result:='NextStep';
    56 : Result:='PalmPilot';
    57 : Result:='Rhapsody';
    58 : Result:='Windows 2000';
    59 : Result:='Dedicated';
    60 : Result:='VSE';
    61 : Result:='TPF';
  end;
end;

{TWin32_DirectorySpecification}

constructor TWin32_DirectorySpecification.Create(LoadWmiData : boolean=True);
begin
  inherited Create(LoadWmiData,'root\CIMV2','Win32_DirectorySpecification');
end;

destructor TWin32_DirectorySpecification.Destroy;
begin
  inherited;
end;

procedure TWin32_DirectorySpecification.SetCollectionIndex(Index : Integer);
begin
  if (Index>=0) and (Index<=FWmiCollection.Count-1) and (FWmiCollectionIndex<>Index) then
  begin
    FWmiCollectionIndex:=Index;
    FCaption                    := VarStrNull(inherited Value['Caption']);
    FCheckID                    := VarStrNull(inherited Value['CheckID']);
    FCheckMode                  := VarBoolNull(inherited Value['CheckMode']);
    FDefaultDir                 := VarStrNull(inherited Value['DefaultDir']);
    FDescription                := VarStrNull(inherited Value['Description']);
    FDirectory                  := VarStrNull(inherited Value['Directory']);
    FDirectoryPath              := VarStrNull(inherited Value['DirectoryPath']);
    FDirectoryType              := VarWordNull(inherited Value['DirectoryType']);
    FName                       := VarStrNull(inherited Value['Name']);
    FSoftwareElementID          := VarStrNull(inherited Value['SoftwareElementID']);
    FSoftwareElementState       := VarWordNull(inherited Value['SoftwareElementState']);
    FTargetOperatingSystem      := VarWordNull(inherited Value['TargetOperatingSystem']);
    FVersion                    := VarStrNull(inherited Value['Version']);
  end;
end;


//not static, OutParams=1, InParams=0
function TWin32_DirectorySpecification.Invoke: integer;
var
  ReturnValue : OleVariant;
begin
  ReturnValue := GetInstanceOf.Invoke;
  Result      := VarIntegerNull(ReturnValue);
end;
end.
