LOCAL_PATH := $(call my-dir)

MY_PACKAGE := RHVoice
MY_VERSION := 1.5.10
MY_COMMON_DEFINES := -DENABLE_PKG=1
MY_CORE_DEFINES := -DPACKAGE=\"$(MY_PACKAGE)\" -DVERSION=\"$(MY_VERSION)\" -DDATA_PATH=\"\" -DCONFIG_PATH=\"\" -DENABLE_SONIC=0 -DHTS_EMBEDDED -DMAX_VOLUME=MAX_MAX_VOLUME  -DDEFAULT_PUNCTUATION_MODE=RHVoice_punctuation_some -DMAX_RATE=3
MY_SRC_DIR := ../../../../..
MY_INCLUDE_DIR := $(MY_SRC_DIR)/include
MY_BOOST_INCLUDE_DIR := $(MY_SRC_DIR)/../external/libs/boost/include
MY_THIRD_PARTY_DIR := $(MY_SRC_DIR)/third-party
MY_HTS_ENGINE_DIR := $(MY_SRC_DIR)/hts_engine
MY_UTF8_DIR := $(MY_THIRD_PARTY_DIR)/utf8
MY_RAPIDXML_DIR := $(MY_THIRD_PARTY_DIR)/rapidxml
MY_CORE_DIR := $(MY_SRC_DIR)/core
MY_PKG_DIR := $(MY_SRC_DIR)/pkg

include $(CLEAR_VARS)
LOCAL_MODULE := hts_engine
LOCAL_C_INCLUDES := $(LOCAL_PATH)/$(MY_INCLUDE_DIR)
LOCAL_SRC_FILES := $(patsubst $(LOCAL_PATH)/%, %, $(wildcard $(LOCAL_PATH)/$(MY_HTS_ENGINE_DIR)/*.c))
LOCAL_EXPORT_C_INCLUDES := $(LOCAL_PATH)/$(MY_HTS_ENGINE_DIR)
include $(BUILD_STATIC_LIBRARY)

include $(CLEAR_VARS)
LOCAL_MODULE := RHVoice_core
LOCAL_C_INCLUDES := $(LOCAL_PATH)/$(MY_INCLUDE_DIR) $(LOCAL_PATH)/$(MY_UTF8_DIR) $(LOCAL_PATH)/$(MY_RAPIDXML_DIR) $(LOCAL_PATH)/$(MY_HTS_ENGINE_DIR) $(LOCAL_PATH)/$(MY_BOOST_INCLUDE_DIR)
LOCAL_SRC_FILES := $(patsubst $(LOCAL_PATH)/%, %, $(filter-out $(LOCAL_PATH)/$(MY_CORE_DIR)/unidata.cpp $(LOCAL_PATH)/$(MY_CORE_DIR)/emoji_data.cpp, $(wildcard $(LOCAL_PATH)/$(MY_CORE_DIR)/*.cpp)))
LOCAL_SRC_FILES += $(patsubst $(LOCAL_PATH)/%, %, $(wildcard $(LOCAL_PATH)/$(MY_PKG_DIR)/*.cpp))
LOCAL_CFLAGS := $(MY_CORE_DEFINES) $(MY_COMMON_DEFINES)
LOCAL_EXPORT_C_INCLUDES := $(LOCAL_C_INCLUDES)
LOCAL_STATIC_LIBRARIES := curl_static
include $(BUILD_STATIC_LIBRARY)

include $(CLEAR_VARS)
LOCAL_MODULE := RHVoice_jni
LOCAL_SRC_FILES := native.cpp
LOCAL_WHOLE_STATIC_LIBRARIES := RHVoice_core hts_engine
LOCAL_CFLAGS := $(MY_COMMON_DEFINES)
include $(BUILD_SHARED_LIBRARY)

$(call import-module,prefab/curl)
