<?php

namespace REBELinBLUE\Deployer\Repositories\Contracts;

interface UserRepositoryInterface
{
    /**
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function getAll();

    /**
     * @param array $fields
     *
     * @return \Illuminate\Database\Eloquent\Model
     */
    public function create(array $fields);

    /**
     * @param array $fields
     * @param int   $model_id
     *
     * @throws \Illuminate\Database\Eloquent\ModelNotFoundException
     * @return \Illuminate\Database\Eloquent\Model
     */
    public function updateById(array $fields, $model_id);

    /**
     * @param int $model_id
     *
     * @throws \Illuminate\Database\Eloquent\ModelNotFoundException
     * @return bool
     */
    public function deleteById($model_id);

    /**
     * @param string $token
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function findByEmailToken($token);

    /**
     * @param string $email
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function findByEmail($email);
}
