<?php

namespace REBELinBLUE\Deployer\Policies;

use Illuminate\Auth\Access\HandlesAuthorization;
use REBELinBLUE\Deployer\Project;
use REBELinBLUE\Deployer\User;

/**
 * Project policies.
 */
class ProjectPolicy
{
    use HandlesAuthorization;

    /**
     * Global policy with any action allowed for admins.
     * @param  User   $user
     * @param  string $ability
     * @return bool
     */
    public function before($user, $ability)
    {
        if ($user->isAdmin()) {
            return true;
        }
    }

    /**
     * Determine whether the user can view the project.
     *
     * @param  \REBELinBLUE\Deployer\User    $user
     * @param  \REBELinBLUE\Deployer\Project $project
     * @return mixed
     */
    public function view(User $user, Project $project)
    {
        return $project->users()->where('users.id', $user->id)->count() === 1;
    }

    /**
     * Determine whether the user can rollback the project.
     *
     * @param  \REBELinBLUE\Deployer\User    $user
     * @param  \REBELinBLUE\Deployer\Project $project
     * @return mixed
     */
    public function rollback(User $user, Project $project)
    {
        return $project->users()->where('role', 'manager')->where('users.id', $user->id)->count() === 1;
    }

    /**
     * Determine whether the user can create projects.
     *
     * @param  \REBELinBLUE\Deployer\User $user
     * @return mixed
     */
    public function create(User $user)
    {
        //
    }

    /**
     * Determine whether the user can update the project.
     *
     * @param  \REBELinBLUE\Deployer\User    $user
     * @param  \REBELinBLUE\Deployer\Project $project
     * @return mixed
     */
    public function update(User $user, Project $project)
    {
        return $project->users()->where('role', 'manager')->where('users.id', $user->id)->count() === 1;
    }

    /**
     * Determine whether the user can delete the project.
     *
     * @param  \REBELinBLUE\Deployer\User    $user
     * @param  \REBELinBLUE\Deployer\Project $project
     * @return mixed
     */
    public function delete(User $user, Project $project)
    {
        //
    }
}
