/*
 *  Copyright (C) 2022 github.com/REAndroid
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IntegerReference;

public class AddingIntegerReference implements IntegerReference {
    private final IntegerReference baseReference;
    private final Block byteSizeBlock;
    public AddingIntegerReference(IntegerReference baseReference, Block byteSizeBlock){
        this.baseReference = baseReference;
        this.byteSizeBlock = byteSizeBlock;
    }
    @Override
    public void set(int value) {
        baseReference.set(value - byteSizeBlock.countBytes());
    }
    @Override
    public int get() {
        return baseReference.get() + byteSizeBlock.countBytes();
    }
    @Override
    public String toString(){
        return baseReference + " + " + byteSizeBlock.countBytes() + " = " + get();
    }
}
