<p align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/QuiiBz/next-international/blob/main/assets/logo-white.png" />
    <source media="(prefers-color-scheme: light)" srcset="https://github.com/QuiiBz/next-international/blob/main/assets/logo-black.png" />
    <img alt="" height="100px" src="https://github.com/QuiiBz/next-international/blob/main/assets/logo-white.png" />
  </picture>
  <br />
  Type-safe internationalization (i18n) for Next.js
</p>

---

- [Features](#features)
- [Documentation](#documentation)
- [Sponsors](#sponsors)
- [License](#license)

## Features

- **100% Type-safe**: Locales in TS or JSON, type-safe `t()` & `scopedT()`, type-safe params, type-safe plurals, type-safe `changeLocale()`...
- **Small**: No dependencies, lazy-loaded
- **Simple**: No Webpack configuration, no CLI, no code generation, just pure TypeScript
- **Server and Client, Static Rendering**: Lazy-load server and client-side, support for Static Rendering
- **App or Pages Router**: With support for React Server Components

> **Note**: You can now build on top of the types used by next-international using [international-types](https://github.com/QuiiBz/next-international/tree/main/packages/international-types)!

Try it live on CodeSandbox:

[![Open with CodeSandbox](https://assets.codesandbox.io/github/button-edit-lime.svg)](https://codesandbox.io/p/sandbox/jovial-paper-skkprk?file=%2Fapp%2F%5Blocale%5D%2Fpage.tsx%3A1%2C1)

## Documentation

Check out the documentation at [https://next-international.vercel.app](https://next-international.vercel.app).

## Contributing

[See the contributing guide](./CONTRIBUTING.md).

## Sponsors

![Sponsors](https://github.com/QuiiBz/dotfiles/blob/main/sponsors.png?raw=true)

## License

[MIT](./LICENSE)
