import XCTest
import Nimble
import Quick

#if canImport(Darwin) && !SWIFT_PACKAGE

final class DescribeTests: XCTestCase, XCTestCaseProvider {
    static var allTests: [(String, (DescribeTests) -> () throws -> Void)] {
        return [
            ("testDescribeThrowsIfUsedOutsideOfQuickSpec", testDescribeThrowsIfUsedOutsideOfQuickSpec),
        ]
    }

    func testDescribeThrowsIfUsedOutsideOfQuickSpec() {
        expect { QuickSpec.describe("this should throw an exception", closure: {}) }.to(raiseException())
    }
}

class QuickDescribeTests: QuickSpec {
    override class func spec() {
        describe("Describe") {
            it("should throw an exception if used in an it block") {
                expect {
                    describe("A nested describe that should throw") { }
                }.to(raiseException { (exception: NSException) in
                    expect(exception.name).to(equal(NSExceptionName.internalInconsistencyException))
                    expect(exception.reason).to(equal("'describe' cannot be used inside 'it', 'describe' may only be used inside 'context' or 'describe'."))
                })
            }
        }
    }
}

#endif
