# Native QP/C Ports to ARM Cortex-M

## Supported ARM Cortex-M Architectures:

- ARMv6-M (**ARM Cortex-M0/M0+**)
- ARMv7-M (**ARM Cortex-M3/M4/M7**)
- ARMv8-M (**ARM Cortex-M23/M33**)

## Supported QP/C Kernels and Toolchains:
- [Cooperative QV kernel](https://www.state-machine.com/qpc/group__qv.html)
  + ARM/KEIL MDK, ARM Compiler 6 (ARM-CLANG)
  + IAR-ARM
  + GNU-ARM
- [Preemptive, non-locking QK kernel](https://www.state-machine.com/qpc/group__qk.html)
  + ARM/KEIL MDK, ARM Compiler 6 (ARM-CLANG)
  + IAR-ARM
  + GNU-ARM
- [Dual-mode (blocking/non-blocking) QXK kernel](https://www.state-machine.com/qpc/group__qxk.html)
  + ARM/KEIL MDK, ARM Compiler 6 (ARM-CLANG)
  + IAR-ARM
  + GNU-ARM

## Documentation:

Detailed documentation for these ports is available in the QP/C Manual at:

- https://www.state-machine.com/qpc/arm-cm.html
