//$file${.::main_qm.c} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//
// Model: model.qm
// File:  ${.::main_qm.c}
//
// This code has been generated by QM 5.3.0 <www.state-machine.com/qm>.
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// SPDX-License-Identifier: GPL-3.0-or-later
//
// This generated code is open source software: you can redistribute it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation.
//
// This code is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// NOTE:
// Alternatively, this generated code may be distributed under the terms
// of Quantum Leaps commercial licenses, which expressly supersede the GNU
// General Public License and are specifically designed for licensees
// interested in retaining the proprietary status of their code.
//
// Contact information:
// <www.state-machine.com/licensing>
// <info@state-machine.com>
//
//$endhead${.::main_qm.c} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#include "qpc.h"
#include "bsp.h"

Q_DEFINE_THIS_FILE

//$declare${AOs} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${AOs::BlinkPatternEvt} ....................................................
typedef struct {
// protected:
    QEvt super;

// public:
    uint8_t ticks;
    uint32_t iter;
} BlinkPatternEvt;

//${AOs::Blinky1} ............................................................
typedef struct Blinky1 {
// protected:
    QActive super;

// private:
    QTimeEvt te;

// public:
    uint32_t iter;
} Blinky1;

extern Blinky1 Blinky1_inst;

// public:
static void Blinky1_ctor(Blinky1 * const me);

// protected:
static QState Blinky1_initial(Blinky1 * const me, void const * const par);
static QState Blinky1_active(Blinky1 * const me, QEvt const * const e);

//${AOs::Blinky2} ............................................................
typedef struct Blinky2 {
// protected:
    QActive super;

// public:
    uint8_t seq;
} Blinky2;

extern Blinky2 Blinky2_inst;

// public:
static void Blinky2_ctor(Blinky2 * const me);

// protected:
static QState Blinky2_initial(Blinky2 * const me, void const * const par);
static QState Blinky2_active(Blinky2 * const me, QEvt const * const e);
//$enddecl${AOs} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

static QEvt const *blinky1_queue[10];
static QEvt const *blinky2_queue[10];
static BlinkPatternEvt evtPool[10];

int main() {
    BSP_init();
    QF_init();

    /* initialize the event pools... */
    QF_poolInit(evtPool, sizeof(evtPool), sizeof(evtPool[0]));

    /* initialize and start Blinky1 AO */
    Blinky1_ctor(&Blinky1_inst);
    QACTIVE_START(&Blinky1_inst,
                   5U, /* priority */
                   blinky1_queue, Q_DIM(blinky1_queue), /* event queue */
                   (void *)0, 0, /* stack memory, stack size (not used) */
                   (void *)0); /* extra parameter (not used) */

    /* initialize and start Blinky2 AO */
    Blinky2_ctor(&Blinky2_inst);
    QACTIVE_START(&Blinky2_inst,
                   2U, /* priority */
                   blinky2_queue, Q_DIM(blinky2_queue), /* event queue */
                   (void *)0, 0, /* stack memory, stack size (not used) */
                   (void *)0); /* extra parameter (not used) */

    /* transfer control to the RTOS to run the threads */
    return QF_run();
}

/*=======================================================================*/
//$skip${QP_VERSION} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
// Check for the minimum required QP version
#if (QP_VERSION < 730U) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8U))
#error qpc version 7.3.0 or higher required
#endif
//$endskip${QP_VERSION} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$define${AO_ptrs} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${AO_ptrs::AO_Blinky1} .....................................................
QActive * const AO_Blinky1 = &Blinky1_inst.super;

//${AO_ptrs::AO_Blinky2} .....................................................
QActive * const AO_Blinky2 = &Blinky2_inst.super;
//$enddef${AO_ptrs} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
//$define${AOs} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${AOs::Blinky1} ............................................................
Blinky1 Blinky1_inst;

//${AOs::Blinky1::ctor} ......................................................
static void Blinky1_ctor(Blinky1 * const me) {
    QActive_ctor(&me->super, Q_STATE_CAST(&Blinky1_initial));
    QTimeEvt_ctorX(&me->te, &me->super, TIMEOUT_SIG, 0U);
}

//${AOs::Blinky1::SM} ........................................................
static QState Blinky1_initial(Blinky1 * const me, void const * const par) {
    //${AOs::Blinky1::SM::initial}
    QTimeEvt_armX(&me->te, 2U, 2U);
    me->iter = 1500U;
    return Q_TRAN(&Blinky1_active);
}

//${AOs::Blinky1::SM::active} ................................................
static QState Blinky1_active(Blinky1 * const me, QEvt const * const e) {
    QState status_;
    switch (e->sig) {
        //${AOs::Blinky1::SM::active::BLINK_PATTERN}
        case BLINK_PATTERN_SIG: {
            QTimeEvt_disarm(&me->te);
            QTimeEvt_armX(&me->te, ((BlinkPatternEvt const *)e)->ticks,
                                   ((BlinkPatternEvt const *)e)->ticks);
            me->iter = ((BlinkPatternEvt const *)e)->iter;
            status_ = Q_HANDLED();
            break;
        }
        //${AOs::Blinky1::SM::active::TIMEOUT}
        case TIMEOUT_SIG: {
            for (uint32_t volatile i = me->iter; i != 0U; --i) {
                BSP_ledGreenOn();
                BSP_ledGreenOff();
            }
            status_ = Q_HANDLED();
            break;
        }
        default: {
            status_ = Q_SUPER(&QHsm_top);
            break;
        }
    }
    return status_;
}

//${AOs::Blinky2} ............................................................
Blinky2 Blinky2_inst;

//${AOs::Blinky2::ctor} ......................................................
static void Blinky2_ctor(Blinky2 * const me) {
    QActive_ctor(&me->super, Q_STATE_CAST(&Blinky2_initial));
}

//${AOs::Blinky2::SM} ........................................................
static QState Blinky2_initial(Blinky2 * const me, void const * const par) {
    //${AOs::Blinky2::SM::initial}
    me->seq = 0U;
    return Q_TRAN(&Blinky2_active);
}

//${AOs::Blinky2::SM::active} ................................................
static QState Blinky2_active(Blinky2 * const me, QEvt const * const e) {
    QState status_;
    switch (e->sig) {
        //${AOs::Blinky2::SM::active::BUTTON_PRESS}
        case BUTTON_PRESS_SIG: {
            enum { N_SEQ = 2 };
            static uint8_t const n_ticks[N_SEQ] = {    2U,   1U };
            static uint32_t const n_iter[N_SEQ] = { 1500U, 750U };

            /* advance and wrap-around the sequence counter */
            me->seq = (me->seq + 1U) % N_SEQ;

            BlinkPatternEvt *bpe = Q_NEW(BlinkPatternEvt,
                                         BLINK_PATTERN_SIG);
            bpe->ticks = n_ticks[me->seq];
            for (uint32_t volatile i = 1500U; i != 0U; --i) {
                BSP_ledBlueOn();
                BSP_ledBlueOff();
            }
            bpe->iter = n_iter[me->seq];
            QACTIVE_POST(AO_Blinky1, &bpe->super, 0U);

            for (uint32_t volatile i = 2*1500U; i != 0U; --i) {
                BSP_ledBlueOn();
                BSP_ledBlueOff();
            }
            status_ = Q_HANDLED();
            break;
        }
        default: {
            status_ = Q_SUPER(&QHsm_top);
            break;
        }
    }
    return status_;
}
//$enddef${AOs} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
