//$file${include::qk.h} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//
// Model: qpc.qm
// File:  ${include::qk.h}
//
// This code has been generated by QM 5.3.0 <www.state-machine.com/qm>.
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This code is covered by the following QP license:
// License #    : LicenseRef-QL-dual
// Issued to    : Any user of the QP/C real-time embedded framework
// Framework(s) : qpc
// Support ends : 2024-12-31
// License scope:
//
// Copyright (C) 2005 Quantum Leaps, LLC <state-machine.com>.
//
//                    Q u a n t u m  L e a P s
//                    ------------------------
//                    Modern Embedded Software
//
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-QL-commercial
//
// This software is dual-licensed under the terms of the open source GNU
// General Public License version 3 (or any later version), or alternatively,
// under the terms of one of the closed source Quantum Leaps commercial
// licenses.
//
// The terms of the open source GNU General Public License version 3
// can be found at: <www.gnu.org/licenses/gpl-3.0>
//
// The terms of the closed source Quantum Leaps commercial licenses
// can be found at: <www.state-machine.com/licensing>
//
// Redistributions in source code must retain this top-level comment block.
// Plagiarizing this software to sidestep the license obligations is illegal.
//
// Contact information:
// <www.state-machine.com/licensing>
// <info@state-machine.com>
//
//$endhead${include::qk.h} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#ifndef QK_H_
#define QK_H_

//$declare${QK::QK} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QK::QK} ..................................................................
// @class QK
typedef struct QK {
    //! @cond INTERNAL
    uint8_t dummy;
    //! @endcond
} QK;
//$enddecl${QK::QK} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QK::QSchedStatus} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QK::QSchedStatus} ........................................................
typedef uint_fast16_t QSchedStatus;
//$enddecl${QK::QSchedStatus} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QK::QK-base} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QK::QK-base::Attr} .......................................................
//! @class QK_Attr
typedef struct {
// public:

    //! @memberof QK_Attr
    QPSet readySet;

#ifndef Q_UNSAFE
    //! @memberof QK_Attr
    QPSet readySet_dis;
#endif // ndef Q_UNSAFE

    //! @memberof QK_Attr
    uint_fast8_t volatile actPrio;

    //! @memberof QK_Attr
    uint_fast8_t volatile nextPrio;

    //! @memberof QK_Attr
    uint_fast8_t volatile actThre;

// private:

    //! @memberof QK_Attr
    uint_fast8_t volatile lockCeil;

// public:

    //! @memberof QK_Attr
    uint_fast8_t volatile lockHolder;

    //! @memberof QK_Attr
    uint_fast8_t volatile intNest;
} QK_Attr;

//${QK::QK-base::priv_} ......................................................
//! @static @private @memberof QK
extern QK_Attr QK_priv_;

//${QK::QK-base::schedLock} ..................................................
//! @static @public @memberof QK
QSchedStatus QK_schedLock(uint_fast8_t const ceiling);

//${QK::QK-base::schedUnlock} ................................................
//! @static @public @memberof QK
void QK_schedUnlock(QSchedStatus const stat);

//${QK::QK-base::onIdle} .....................................................
//! @static @public @memberof QK
void QK_onIdle(void);

//${QK::QK-base::sched_} .....................................................
//! @static @private @memberof QK
uint_fast8_t QK_sched_(void);

//${QK::QK-base::activate_} ..................................................
//! @static @private @memberof QK
void QK_activate_(void);
//$enddecl${QK::QK-base} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//============================================================================
// interface used only for internal implementation, but not in applications
#ifdef QP_IMPL

//$declare${QK-impl} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QK-impl::QF_SCHED_STAT_} .................................................
#define QF_SCHED_STAT_ QSchedStatus lockStat_;

//${QK-impl::QF_SCHED_LOCK_} .................................................
#define QF_SCHED_LOCK_(ceil_) do { \
    if (QK_ISR_CONTEXT_()) { \
        lockStat_ = 0xFFU; \
    } else { \
        lockStat_ = QK_schedLock((ceil_)); \
    } \
} while (false)

//${QK-impl::QF_SCHED_UNLOCK_} ...............................................
#define QF_SCHED_UNLOCK_() do { \
    if (lockStat_ != 0xFFU) { \
        QK_schedUnlock(lockStat_); \
    } \
} while (false)

//${QK-impl::QACTIVE_EQUEUE_WAIT_} ...........................................
#define QACTIVE_EQUEUE_WAIT_(me_) \
    Q_ASSERT_INCRIT(320, (me_)->eQueue.frontEvt != (QEvt *)0)

//${QK-impl::QACTIVE_EQUEUE_SIGNAL_} .........................................
#ifndef Q_UNSAFE
#define QACTIVE_EQUEUE_SIGNAL_(me_) do { \
    QPSet_insert(&QK_priv_.readySet, (uint_fast8_t)(me_)->prio); \
    QPSet_update_(&QK_priv_.readySet, &QK_priv_.readySet_dis); \
    if (!QK_ISR_CONTEXT_()) { \
        if (QK_sched_() != 0U) { \
            QK_activate_(); \
        } \
    } \
} while (false)
#endif // ndef Q_UNSAFE

//${QK-impl::QACTIVE_EQUEUE_SIGNAL_} .........................................
#ifdef Q_UNSAFE
#define QACTIVE_EQUEUE_SIGNAL_(me_) do { \
    QPSet_insert(&QK_priv_.readySet, (uint_fast8_t)(me_)->prio); \
    if (!QK_ISR_CONTEXT_()) { \
        if (QK_sched_() != 0U) { \
            QK_activate_(); \
        } \
    } \
} while (false)
#endif // def Q_UNSAFE
//$enddecl${QK-impl} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF_EPOOL-impl} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF_EPOOL-impl::QF_EPOOL_TYPE_} ...........................................
#define QF_EPOOL_TYPE_ QMPool

//${QF_EPOOL-impl::QF_EPOOL_INIT_} ...........................................
#define QF_EPOOL_INIT_(p_, poolSto_, poolSize_, evtSize_) \
    (QMPool_init(&(p_), (poolSto_), (poolSize_), (evtSize_)))

//${QF_EPOOL-impl::QF_EPOOL_EVENT_SIZE_} .....................................
#define QF_EPOOL_EVENT_SIZE_(p_) ((uint_fast16_t)(p_).blockSize)

//${QF_EPOOL-impl::QF_EPOOL_GET_} ............................................
#define QF_EPOOL_GET_(p_, e_, m_, qs_id_) \
    ((e_) = (QEvt *)QMPool_get(&(p_), (m_), (qs_id_)))

//${QF_EPOOL-impl::QF_EPOOL_PUT_} ............................................
#define QF_EPOOL_PUT_(p_, e_, qs_id_) \
    (QMPool_put(&(p_), (e_), (qs_id_)))
//$enddecl${QF_EPOOL-impl} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

#endif // QP_IMPL

#endif // QK_H_
