//$file${include::qp.h} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//
// Model: qpc.qm
// File:  ${include::qp.h}
//
// This code has been generated by QM 5.3.0 <www.state-machine.com/qm>.
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This code is covered by the following QP license:
// License #    : LicenseRef-QL-dual
// Issued to    : Any user of the QP/C real-time embedded framework
// Framework(s) : qpc
// Support ends : 2024-12-31
// License scope:
//
// Copyright (C) 2005 Quantum Leaps, LLC <state-machine.com>.
//
//                    Q u a n t u m  L e a P s
//                    ------------------------
//                    Modern Embedded Software
//
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-QL-commercial
//
// This software is dual-licensed under the terms of the open source GNU
// General Public License version 3 (or any later version), or alternatively,
// under the terms of one of the closed source Quantum Leaps commercial
// licenses.
//
// The terms of the open source GNU General Public License version 3
// can be found at: <www.gnu.org/licenses/gpl-3.0>
//
// The terms of the closed source Quantum Leaps commercial licenses
// can be found at: <www.state-machine.com/licensing>
//
// Redistributions in source code must retain this top-level comment block.
// Plagiarizing this software to sidestep the license obligations is illegal.
//
// Contact information:
// <www.state-machine.com/licensing>
// <info@state-machine.com>
//
//$endhead${include::qp.h} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#ifndef QP_H_
#define QP_H_

//============================================================================
#define QP_VERSION     730U
#define QP_VERSION_STR "7.3.0"

//! Encrypted  current QP release (7.3.0) and date (2023-09-12)
#define QP_RELEASE     0x765D9D25U

//============================================================================
//! @cond INTERNAL

#ifndef Q_SIGNAL_SIZE
#define Q_SIGNAL_SIZE 2U
#endif

#ifndef QF_MAX_ACTIVE
#define QF_MAX_ACTIVE 32U
#endif

#if (QF_MAX_ACTIVE > 64U)
#error QF_MAX_ACTIVE exceeds the maximum of 64U;
#endif

#ifndef QF_MAX_TICK_RATE
#define QF_MAX_TICK_RATE 1U
#endif

#if (QF_MAX_TICK_RATE > 15U)
#error QF_MAX_TICK_RATE exceeds the maximum of 15U;
#endif

#ifndef QF_MAX_EPOOL
#define QF_MAX_EPOOL 3U
#endif

#if (QF_MAX_EPOOL > 15U)
#error QF_MAX_EPOOL exceeds the maximum of 15U;
#endif

#ifndef QF_TIMEEVT_CTR_SIZE
#define QF_TIMEEVT_CTR_SIZE 4U
#endif

#if (QF_TIMEEVT_CTR_SIZE > 4U)
#error QF_TIMEEVT_CTR_SIZE defined incorrectly, expected 1U, 2U, or 4U;
#endif

#ifndef QF_EVENT_SIZ_SIZE
#define QF_EVENT_SIZ_SIZE 2U
#endif

#if (QF_EVENT_SIZ_SIZE > 4U)
#error QF_EVENT_SIZ_SIZE defined incorrectly, expected 1U, 2U, or 4U;
#endif

//! @endcond
//============================================================================

//$declare${glob-types} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${glob-types::int_t} .......................................................
typedef int int_t;

//${glob-types::enum_t} ......................................................
typedef int enum_t;

//${glob-types::float32_t} ...................................................
typedef float float32_t;

//${glob-types::float64_t} ...................................................
typedef double float64_t;
//$enddecl${glob-types} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QEP} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QEP::QP_versionStr[8]} ...................................................
//! the current QP version number string in ROM, based on #QP_VERSION_STR
extern char const QP_versionStr[8];

//${QEP::QSignal} ............................................................
#if (Q_SIGNAL_SIZE == 1U)
typedef uint8_t QSignal;
#endif //  (Q_SIGNAL_SIZE == 1U)

//${QEP::QSignal} ............................................................
#if (Q_SIGNAL_SIZE == 2U)
typedef uint16_t QSignal;
#endif //  (Q_SIGNAL_SIZE == 2U)

//${QEP::QSignal} ............................................................
#if (Q_SIGNAL_SIZE == 4U)
typedef uint32_t QSignal;
#endif //  (Q_SIGNAL_SIZE == 4U)

//${QEP::QEVT_MARKER} ........................................................
#define QEVT_MARKER 0xE0U

//${QEP::QEVT_DYNAMIC} .......................................................
#define QEVT_DYNAMIC 0U

//${QEP::QEvt} ...............................................................
// ! @class QEvt
typedef struct QEvt {
// public:

    //! @public @memberof QEvt
    QSignal sig;

// private:

    //! @private @memberof QEvt
    uint8_t volatile refCtr_;

    //! @private @memberof QEvt
    uint8_t evtTag_;
} QEvt;

extern QEvt const QEvt_reserved_[4];

// public:

//! @public @memberof QEvt
static inline QEvt * QEvt_ctor(QEvt * const me,
    enum_t const sig)
{
    if (sig != QEVT_DYNAMIC) {
        me->sig     = (QSignal)sig;
        me->refCtr_ = 0U;
        me->evtTag_ = QEVT_MARKER;
    }
    return me;
}

// private:

//! @private @memberof QEvt
static inline bool QEvt_verify_(QEvt const * const me) {
    return (me != (QEvt const *)0)
           && ((me->evtTag_ & 0xF0U) == QEVT_MARKER);
}

//! @private @memberof QEvt
static inline uint_fast8_t QEvt_getPoolId_(QEvt const * const me) {
    return (uint_fast8_t)me->evtTag_ & 0x0FU;
}

//${QEP::QStateRet} ..........................................................
//! All possible values returned from state/action handlers
//! @note
//! The order of enumeration matters for algorithmic correctness.
enum QStateRet {
    // unhandled and need to "bubble up"
    Q_RET_SUPER,     //!< event passed to superstate to handle
    Q_RET_SUPER_SUB, //!< event passed to submachine superstate
    Q_RET_UNHANDLED, //!< event unhandled due to a guard

    // handled and do not need to "bubble up"
    Q_RET_HANDLED,   //!< event handled (internal transition)
    Q_RET_IGNORED,   //!< event silently ignored (bubbled up to top)

    // entry/exit
    Q_RET_ENTRY,     //!< state entry action executed
    Q_RET_EXIT,      //!< state exit  action executed

    // no side effects
    Q_RET_NULL,      //!< return value without any effect

    // transitions need to execute transition-action table in ::QMsm
    Q_RET_TRAN,      //!< regular transition
    Q_RET_TRAN_INIT, //!< initial transition in a state or submachine
    Q_RET_TRAN_EP,   //!< entry-point transition into a submachine

    // transitions that additionally clobber me->state
    Q_RET_TRAN_HIST, //!< transition to history of a given state
    Q_RET_TRAN_XP    //!< exit-point transition out of a submachine
};

//${QEP::QState} .............................................................
typedef enum QStateRet QState;

//${QEP::QStateHandler} ......................................................
typedef QState (* QStateHandler )(void * const me, QEvt const * const e);

//${QEP::QActionHandler} .....................................................
typedef QState (* QActionHandler )(void * const me);

//${QEP::QXThread} ...........................................................
// forward declaration
struct QXThread;

//${QEP::QXThreadHandler} ....................................................
typedef void (* QXThreadHandler )(struct QXThread * const me);

//${QEP::QMState} ............................................................
typedef struct QMState {
    struct QMState const *superstate; //!< @private @memberof QMState
    QStateHandler const stateHandler; //!< @private @memberof QMState
    QActionHandler const entryAction; //!< @private @memberof QMState
    QActionHandler const exitAction;  //!< @private @memberof QMState
    QActionHandler const initAction;  //!< @private @memberof QMState
} QMState;

//${QEP::QMTranActTable} .....................................................
typedef struct QMTranActTable {
    QMState const *target;       //!< @private @memberof QMTranActTable
    QActionHandler const act[1]; //!< @private @memberof QMTranActTable
} QMTranActTable;

//${QEP::QReservedSig} .......................................................
//! Reserved signals by the QHsm-style state machine implementation
enum QReservedSig {
    Q_EMPTY_SIG,     //!< signal to execute the default case
    Q_ENTRY_SIG,     //!< signal for coding entry actions
    Q_EXIT_SIG,      //!< signal for coding exit actions
    Q_INIT_SIG,      //!< signal for coding initial transitions
    Q_USER_SIG       //!< offset for the user signals (QP Application)
};

//${QEP::QAsmAttr} ...........................................................
union QAsmAttr {
    QStateHandler   fun;         //!< @private @memberof QAsmAttr
    QActionHandler  act;         //!< @private @memberof QAsmAttr
    QXThreadHandler thr;         //!< @private @memberof QAsmAttr
    QMTranActTable const *tatbl; //!< @private @memberof QAsmAttr
    struct QMState const *obj;   //!< @private @memberof QAsmAttr
#ifndef Q_UNSAFE
    uintptr_t      uint;         //!< @private @memberof QAsmAttr
#endif
};

//${QEP::QAsm} ...............................................................
//! @class QAsm
typedef struct {
// private:

    //! @protected @memberof QAsm
    struct QAsmVtable const * vptr;

// protected:

    //! @protected @memberof QAsm
    union QAsmAttr state;

    //! @protected @memberof QAsm
    union QAsmAttr temp;
} QAsm;

// protected:

//! @protected @memberof QAsm
void QAsm_ctor(QAsm * const me);

//${QEP::QAsmVtable} .........................................................
struct QAsmVtable {
    void (*init)(QAsm * const me, void const * const e,
                 uint_fast8_t const qs_id);
    void (*dispatch)(QAsm * const me, QEvt const * const e,
                     uint_fast8_t const qs_id);
#ifdef Q_SPY
    QStateHandler (*getStateHandler)(QAsm * const me);
#endif // Q_SPY
};

//${QEP::QHsm} ...............................................................
//! @class QHsm
//! @extends QAsm
typedef struct {
// protected:
    QAsm super;
} QHsm;

// protected:

//! @protected @memberof QHsm
void QHsm_ctor(QHsm * const me,
    QStateHandler const initial);

// private:

//! @private @memberof QHsm
void QHsm_init_(
    QAsm * const me,
    void const * const e,
    uint_fast8_t const qs_id);

//! @private @memberof QHsm
void QHsm_dispatch_(
    QAsm * const me,
    QEvt const * const e,
    uint_fast8_t const qs_id);

#ifdef Q_SPY
//! @private @memberof QHsm
QStateHandler QHsm_getStateHandler_(QAsm * const me);
#endif // def Q_SPY

// public:

//! @public @memberof QHsm
bool QHsm_isIn(QHsm * const me,
    QStateHandler const state);

//! @public @memberof QHsm
static inline QStateHandler QHsm_state(QHsm const * const me) {
    return me->super.state.fun;
}

//! @public @memberof QHsm
QStateHandler QHsm_childState(QHsm * const me,
    QStateHandler const parent);

// private:

//! @private @memberof QHsm
int_fast8_t QHsm_tran_(
    QAsm * const me,
    QStateHandler * const path,
    uint_fast8_t const qs_id);

// protected:

//! @protected @memberof QAsm
QState QHsm_top(QHsm const * const me,
    QEvt const * const e);

//${QEP::QMsm} ...............................................................
//! @class QMsm
//! @extends QAsm
typedef struct {
// protected:
    QAsm super;
} QMsm;

// protected:

//! @protected @memberof QMsm
void QMsm_ctor(QMsm * const me,
    QStateHandler const initial);

// public:

//! @private @memberof QMsm
void QMsm_init_(
    QAsm * const me,
    void const * const e,
    uint_fast8_t const qs_id);

// private:

//! @private @memberof QMsm
void QMsm_dispatch_(
    QAsm * const me,
    QEvt const * const e,
    uint_fast8_t const qs_id);

// public:

#ifdef Q_SPY
//! @public @memberof QMsm
static inline QStateHandler QMsm_getStateHandler_(QAsm * const me) {
    return me->state.obj->stateHandler;
}
#endif // def Q_SPY

//! @public @memberof QMsm
bool QMsm_isInState(QMsm const * const me,
    QMState const * const stateObj);

//! @public @memberof QMsm
static inline QMState const * QMsm_stateObj(QMsm * const me) {
    return me->super.state.obj;
}

//! @public @memberof QMsm
QMState const * QMsm_childStateObj(QMsm const * const me,
    QMState const * const parent);

// private:

//! @private @memberof QMsm
QState QMsm_execTatbl_(
    QAsm * const me,
    QMTranActTable const * const tatbl,
    uint_fast8_t const qs_id);

//! @private @memberof QMsm
void QMsm_exitToTranSource_(
    QAsm * const me,
    QMState const * const cs,
    QMState const * const ts,
    uint_fast8_t const qs_id);

//! @private @memberof QMsm
QState QMsm_enterHistory_(
    QAsm * const me,
    QMState const *const hist,
    uint_fast8_t const qs_id);
//$enddecl${QEP} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QEP-macros} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QEP-macros::QEVT_INITIALIZER} ............................................
#define QEVT_INITIALIZER(sig_) { (QSignal)(sig_), 0U, QEVT_MARKER }

//${QEP-macros::QASM_INIT} ...................................................
#ifdef Q_SPY
#define QASM_INIT(me_, par_, qs_id_) do { \
    Q_ASSERT(((QAsm *)(me_))->vptr); \
    (*((QAsm *)(me_))->vptr->init)((QAsm *)(me_), (par_), (qs_id_)); \
} while (false)
#endif // def Q_SPY

//${QEP-macros::QASM_INIT} ...................................................
#ifndef Q_SPY
#define QASM_INIT(me_, par_, dummy) do { \
    Q_ASSERT(((QAsm *)(me_))->vptr); \
    (*((QAsm *)(me_))->vptr->init)((QAsm *)(me_), (par_), 0); \
} while (false)
#endif // ndef Q_SPY

//${QEP-macros::QASM_DISPATCH} ...............................................
#ifdef Q_SPY
#define QASM_DISPATCH(me_, e_, qs_id_) \
    (*((QAsm *)(me_))->vptr->dispatch)((QAsm *)(me_), (e_), (qs_id_))
#endif // def Q_SPY

//${QEP-macros::QASM_DISPATCH} ...............................................
#ifndef Q_SPY
#define QASM_DISPATCH(me_, e_, dummy) \
    (*((QAsm *)(me_))->vptr->dispatch)((QAsm *)(me_), (e_), 0U)
#endif // ndef Q_SPY

//${QEP-macros::Q_ASM_UPCAST} ................................................
#define Q_ASM_UPCAST(ptr_) ((QAsm *)(ptr_))

//${QEP-macros::Q_HSM_UPCAST} ................................................
#define Q_HSM_UPCAST(ptr_) ((QHsm *)(ptr_))

//${QEP-macros::Q_MSM_UPCAST} ................................................
#define Q_MSM_UPCAST(ptr_) ((QMsm *)(ptr_))

//${QEP-macros::Q_TRAN} ......................................................
#define Q_TRAN(target_) \
    ((Q_ASM_UPCAST(me))->temp.fun = Q_STATE_CAST(target_), \
     (QState)Q_RET_TRAN)

//${QEP-macros::Q_TRAN_HIST} .................................................
#define Q_TRAN_HIST(hist_) \
    ((Q_ASM_UPCAST(me))->temp.fun = (hist_), \
     (QState)Q_RET_TRAN_HIST)

//${QEP-macros::Q_SUPER} .....................................................
#define Q_SUPER(super_) \
    ((Q_ASM_UPCAST(me))->temp.fun = Q_STATE_CAST(super_), \
     (QState)Q_RET_SUPER)

//${QEP-macros::Q_HANDLED} ...................................................
#define Q_HANDLED() ((QState)Q_RET_HANDLED)

//${QEP-macros::Q_UNHANDLED} .................................................
#define Q_UNHANDLED() ((QState)Q_RET_UNHANDLED)

//${QEP-macros::Q_ACTION_NULL} ...............................................
#define Q_ACTION_NULL ((QActionHandler)0)

//${QEP-macros::Q_EVT_CAST} ..................................................
#define Q_EVT_CAST(class_) ((class_ const *)(e))

//${QEP-macros::Q_STATE_CAST} ................................................
#define Q_STATE_CAST(handler_) ((QStateHandler)(handler_))

//${QEP-macros::Q_ACTION_CAST} ...............................................
#define Q_ACTION_CAST(action_) ((QActionHandler)(action_))

//${QEP-macros::Q_UNUSED_PAR} ................................................
#define Q_UNUSED_PAR(par_) ((void)(par_))

//${QEP-macros::Q_DIM} .......................................................
#define Q_DIM(array_) (sizeof(array_) / sizeof((array_)[0U]))

//${QEP-macros::Q_UINT2PTR_CAST} .............................................
#define Q_UINT2PTR_CAST(type_, uint_) ((type_ *)(uint_))

//${QEP-macros::QM_ENTRY} ....................................................
#ifdef Q_SPY
#define QM_ENTRY(state_) \
    ((Q_ASM_UPCAST(me))->temp.obj = (state_), \
     (QState)Q_RET_ENTRY)
#endif // def Q_SPY

//${QEP-macros::QM_ENTRY} ....................................................
#ifndef Q_SPY
#define QM_ENTRY(dummy) ((QState)Q_RET_ENTRY)
#endif // ndef Q_SPY

//${QEP-macros::QM_EXIT} .....................................................
#ifdef Q_SPY
#define QM_EXIT(state_) \
    ((Q_ASM_UPCAST(me))->temp.obj = (state_), \
     (QState)Q_RET_EXIT)
#endif // def Q_SPY

//${QEP-macros::QM_EXIT} .....................................................
#ifndef Q_SPY
#define QM_EXIT(dummy) ((QState)Q_RET_EXIT)
#endif // ndef Q_SPY

//${QEP-macros::QM_SM_EXIT} ..................................................
#define QM_SM_EXIT(state_) \
    ((Q_ASM_UPCAST(me))->temp.obj = (state_), \
     (QState)Q_RET_EXIT)

//${QEP-macros::QM_TRAN} .....................................................
#define QM_TRAN(tatbl_) ((Q_ASM_UPCAST(me))->temp.tatbl \
    = (struct QMTranActTable const *)(tatbl_), \
 (QState)Q_RET_TRAN)

//${QEP-macros::QM_TRAN_INIT} ................................................
#define QM_TRAN_INIT(tatbl_) ((Q_ASM_UPCAST(me))->temp.tatbl \
    = (struct QMTranActTable const *)(tatbl_), \
 (QState)Q_RET_TRAN_INIT)

//${QEP-macros::QM_TRAN_HIST} ................................................
#define QM_TRAN_HIST(history_, tatbl_) \
    ((((Q_ASM_UPCAST(me))->state.obj  = (history_)), \
      ((Q_ASM_UPCAST(me))->temp.tatbl = \
          (struct QMTranActTable const *)(tatbl_))), \
     (QState)Q_RET_TRAN_HIST)

//${QEP-macros::QM_TRAN_EP} ..................................................
#define QM_TRAN_EP(tatbl_) ((Q_ASM_UPCAST(me))->temp.tatbl \
    = (struct QMTranActTable const *)(tatbl_), \
 (QState)Q_RET_TRAN_EP)

//${QEP-macros::QM_TRAN_XP} ..................................................
#define QM_TRAN_XP(xp_, tatbl_) \
    ((((Q_ASM_UPCAST(me))->state.act  = (xp_)), \
      ((Q_ASM_UPCAST(me))->temp.tatbl = \
          (struct QMTranActTable const *)(tatbl_))), \
     (QState)Q_RET_TRAN_XP)

//${QEP-macros::QM_HANDLED} ..................................................
#define QM_HANDLED() ((QState)Q_RET_HANDLED)

//${QEP-macros::QM_UNHANDLED} ................................................
#define QM_UNHANDLED() ((QState)Q_RET_UNHANDLED)

//${QEP-macros::QM_SUPER} ....................................................
#define QM_SUPER() ((QState)Q_RET_SUPER)

//${QEP-macros::QM_SUPER_SUB} ................................................
#define QM_SUPER_SUB(host_) \
    ((Q_ASM_UPCAST(me))->temp.obj = (host_), \
     (QState)Q_RET_SUPER_SUB)

//${QEP-macros::QM_STATE_NULL} ...............................................
#define QM_STATE_NULL ((QMState *)0)
//$enddecl${QEP-macros} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::types} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::types::QPrioSpec} ....................................................
typedef uint16_t QPrioSpec;

//${QF::types::QTimeEvtCtr} ..................................................
#if (QF_TIMEEVT_CTR_SIZE == 1U)
typedef uint8_t QTimeEvtCtr;
#endif //  (QF_TIMEEVT_CTR_SIZE == 1U)

//${QF::types::QTimeEvtCtr} ..................................................
#if (QF_TIMEEVT_CTR_SIZE == 2U)
typedef uint16_t QTimeEvtCtr;
#endif //  (QF_TIMEEVT_CTR_SIZE == 2U)

//${QF::types::QTimeEvtCtr} ..................................................
#if (QF_TIMEEVT_CTR_SIZE == 4U)
typedef uint32_t QTimeEvtCtr;
#endif //  (QF_TIMEEVT_CTR_SIZE == 4U)

//${QF::types::QPSetBits} ....................................................
#if (QF_MAX_ACTIVE <= 8U)
typedef uint8_t QPSetBits;
#endif //  (QF_MAX_ACTIVE <= 8U)

//${QF::types::QPSetBits} ....................................................
#if (8U < QF_MAX_ACTIVE) && (QF_MAX_ACTIVE <= 16U)
typedef uint16_t QPSetBits;
#endif //  (8U < QF_MAX_ACTIVE) && (QF_MAX_ACTIVE <= 16U)

//${QF::types::QPSetBits} ....................................................
#if (16U < QF_MAX_ACTIVE)
typedef uint32_t QPSetBits;
#endif //  (16U < QF_MAX_ACTIVE)

//${QF::types::QF_LOG2} ......................................................
#ifndef QF_LOG2
uint_fast8_t QF_LOG2(QPSetBits const bitmask);
#endif // ndef QF_LOG2

//${QF::types::QPSet} ........................................................
//! @class QPSet
typedef struct {
// private:

    //! @private @memberof QPSet
    QPSetBits bits[((QF_MAX_ACTIVE + (8U*sizeof(QPSetBits))) - 1U)/(8U*sizeof(QPSetBits))];
} QPSet;

// public:

//! @public @memberof QPSet
static inline void QPSet_setEmpty(QPSet * const me) {
    me->bits[0] = 0U;
    #if (QF_MAX_ACTIVE > 32)
    me->bits[1] = 0U;
    #endif
}

//! @public @memberof QPSet
static inline bool QPSet_isEmpty(QPSet const * const me) {
    #if (QF_MAX_ACTIVE <= 32U)
    return (me->bits[0] == 0U);
    #else
    return (me->bits[0] == 0U) ? (me->bits[1] == 0U) : false;
    #endif
}

//! @public @memberof QPSet
static inline bool QPSet_notEmpty(QPSet const * const me) {
    #if (QF_MAX_ACTIVE <= 32U)
    return (me->bits[0] != 0U);
    #else
    return (me->bits[0] != 0U) ? true : (me->bits[1] != 0U);
    #endif
}

//! @public @memberof QPSet
static inline bool QPSet_hasElement(QPSet const * const me,
    uint_fast8_t const n)
{
    #if (QF_MAX_ACTIVE <= 32U)
    return (me->bits[0] & ((QPSetBits)1U << (n - 1U))) != 0U;
    #else
    return (n <= 32U)
        ? ((me->bits[0] & ((QPSetBits)1U << (n - 1U)))  != 0U)
        : ((me->bits[1] & ((QPSetBits)1U << (n - 33U))) != 0U);
    #endif
}

//! @public @memberof QPSet
static inline void QPSet_insert(QPSet * const me,
    uint_fast8_t const n)
{
    #if (QF_MAX_ACTIVE <= 32U)
    me->bits[0] = (me->bits[0] | ((QPSetBits)1U << (n - 1U)));
    #else
    if (n <= 32U) {
        me->bits[0] = (me->bits[0] | ((QPSetBits)1U << (n - 1U)));
    }
    else {
        me->bits[1] = (me->bits[1] | ((QPSetBits)1U << (n - 33U)));
    }
    #endif
}

//! @public @memberof QPSet
static inline void QPSet_remove(QPSet * const me,
    uint_fast8_t const n)
{
    #if (QF_MAX_ACTIVE <= 32U)
    me->bits[0] = (me->bits[0] & (QPSetBits)(~((QPSetBits)1U << (n - 1U))));
    #else
    if (n <= 32U) {
        (me->bits[0] = (me->bits[0] & ~((QPSetBits)1U << (n - 1U))));
    }
    else {
        (me->bits[1] = (me->bits[1] & ~((QPSetBits)1U << (n - 33U))));
    }
    #endif
}

//! @public @memberof QPSet
static inline uint_fast8_t QPSet_findMax(QPSet const * const me) {
    #if (QF_MAX_ACTIVE <= 32U)
    return QF_LOG2(me->bits[0]);
    #else
    return (me->bits[1] != 0U)
        ? (QF_LOG2(me->bits[1]) + 32U)
        : (QF_LOG2(me->bits[0]));
    #endif
}

// private:

#ifndef Q_UNSAFE
//! @private @memberof QPSet
static inline void QPSet_update_(QPSet const * const me,
    QPSet * const dis)
{
    dis->bits[0] = ~me->bits[0];
    #if (QF_MAX_ACTIVE > 32U)
    dis->bits[1] = ~me->bits[1];
    #endif
}
#endif // ndef Q_UNSAFE

#ifndef Q_UNSAFE
//! @private @memberof QPSet
static inline bool QPSet_verify_(QPSet const * const me,
    QPSet const * const dis)
{
    #if (QF_MAX_ACTIVE <= 32U)
    return me->bits[0] == (QPSetBits)(~dis->bits[0]);
    #else
    return (me->bits[0] == (QPSetBits)(~dis->bits[0]))
           && (me->bits[1] == (QPSetBits)(~dis->bits[1]));
    #endif
}
#endif // ndef Q_UNSAFE

//${QF::types::QSubscrList} ..................................................
// @struct QSubscrList
typedef struct {
// private:

    //! @private @memberof QSubscrList
    QPSet set;

#ifndef Q_UNSAFE
    //! @private @memberof QSubscrList
    QPSet set_dis;
#endif // ndef Q_UNSAFE
} QSubscrList;

//${QF::types::QEQueue} ......................................................
struct QEQueue;
//$enddecl${QF::types} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QActive} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QActive} .............................................................
//! @class QActive
//! @extends QAsm
typedef struct QActive {
// protected:
    QAsm super;

#ifdef QACTIVE_EQUEUE_TYPE
    //! @private @memberof QActive
    QACTIVE_EQUEUE_TYPE eQueue;
#endif // def QACTIVE_EQUEUE_TYPE

#ifdef QACTIVE_OS_OBJ_TYPE
    //! @private @memberof QActive
    QACTIVE_OS_OBJ_TYPE osObject;
#endif // def QACTIVE_OS_OBJ_TYPE

#ifdef QACTIVE_THREAD_TYPE
    //! @private @memberof QActive
    QACTIVE_THREAD_TYPE thread;
#endif // def QACTIVE_THREAD_TYPE

    //! @private @memberof QActive
    uint8_t prio;

    //! @private @memberof QActive
    uint8_t pthre;

// private:
} QActive;

//! @static @private @memberof QActive
extern QActive * QActive_registry_[QF_MAX_ACTIVE + 1U];

//! @static @private @memberof QActive
extern QSubscrList * QActive_subscrList_;

//! @static @private @memberof QActive
extern enum_t QActive_maxPubSignal_;

// protected:

//! @protected @memberof QActive
void QActive_ctor(QActive * const me,
    QStateHandler const initial);

// public:

//! @public @memberof QActive
void QActive_setAttr(QActive * const me,
    uint32_t attr1,
    void const * attr2);

// private:

//! @private @memberof QActive
void QActive_start_(QActive * const me,
    QPrioSpec const prioSpec,
    QEvt const * * const qSto,
    uint_fast16_t const qLen,
    void * const stkSto,
    uint_fast16_t const stkSize,
    void const * const par);

// protected:

#ifdef QACTIVE_CAN_STOP
//! @protected @memberof QActive
void QActive_stop(QActive * const me);
#endif // def QACTIVE_CAN_STOP

// private:

//! @private @memberof QActive
void QActive_register_(QActive * const me);

//! @private @memberof QActive
void QActive_unregister_(QActive * const me);

//! @private @memberof QActive
bool QActive_post_(QActive * const me,
    QEvt const * const e,
    uint_fast16_t const margin,
    void const * const sender);

//! @private @memberof QActive
void QActive_postLIFO_(QActive * const me,
    QEvt const * const e);

//! @private @memberof QActive
QEvt const * QActive_get_(QActive * const me);

// public:

//! @static @public @memberof QActive
void QActive_psInit(
    QSubscrList * const subscrSto,
    enum_t const maxSignal);

// private:

//! @static @private @memberof QActive
void QActive_publish_(
    QEvt const * const e,
    void const * const sender,
    uint_fast8_t const qs_id);

// protected:

//! @protected @memberof QActive
void QActive_subscribe(QActive const * const me,
    enum_t const sig);

//! @protected @memberof QActive
void QActive_unsubscribe(QActive const * const me,
    enum_t const sig);

//! @protected @memberof QActive
void QActive_unsubscribeAll(QActive const * const me);

//! @protected @memberof QActive
bool QActive_defer(QActive const * const me,
    struct QEQueue * const eq,
    QEvt const * const e);

//! @protected @memberof QActive
bool QActive_recall(QActive * const me,
    struct QEQueue * const eq);

//! @protected @memberof QActive
uint_fast16_t QActive_flushDeferred(QActive const * const me,
    struct QEQueue * const eq);

// private:

//! @private @memberof QActive
void QActive_evtLoop_(QActive * const me);
//$enddecl${QF::QActive} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QMActive} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QMActive} ............................................................
//! @class QMActive
//! @extends QActive
typedef struct {
// protected:
    QActive super;
} QMActive;

// protected:

//! @protected @memberof QMActive
void QMActive_ctor(QMActive * const me,
    QStateHandler const initial);
//$enddecl${QF::QMActive} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QTimeEvt} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QTimeEvt} ............................................................
//! @class QTimeEvt
// @extends QEvt
typedef struct QTimeEvt {
// protected:
    QEvt super;

// private:

    //! @private @memberof QTimeEvt
    struct QTimeEvt * volatile next;

    //! @private @memberof QTimeEvt
    void * volatile act;

    //! @private @memberof QTimeEvt
    QTimeEvtCtr volatile ctr;

    //! @private @memberof QTimeEvt
    QTimeEvtCtr interval;
} QTimeEvt;

//! @static @private @memberof QTimeEvt
extern QTimeEvt QTimeEvt_timeEvtHead_[QF_MAX_TICK_RATE];

// public:

//! @public @memberof QTimeEvt
void QTimeEvt_ctorX(QTimeEvt * const me,
    QActive * const act,
    enum_t const sig,
    uint_fast8_t const tickRate);

//! @public @memberof QTimeEvt
void QTimeEvt_armX(QTimeEvt * const me,
    QTimeEvtCtr const nTicks,
    QTimeEvtCtr const interval);

//! @public @memberof QTimeEvt
bool QTimeEvt_disarm(QTimeEvt * const me);

//! @public @memberof QTimeEvt
bool QTimeEvt_rearm(QTimeEvt * const me,
    QTimeEvtCtr const nTicks);

//! @public @memberof QTimeEvt
bool QTimeEvt_wasDisarmed(QTimeEvt * const me);

//! @public @memberof QTimeEvt
QTimeEvtCtr QTimeEvt_currCtr(QTimeEvt const * const me);

//! @static @private @memberof QTimeEvt
void QTimeEvt_tick_(
    uint_fast8_t const tickRate,
    void const * const sender);

// private:

#ifdef Q_UTEST
//! @static @private @memberof QTimeEvt
void QTimeEvt_tick1_(
    uint_fast8_t const tickRate,
    void const * const sender);
#endif // def Q_UTEST

// public:

//! @static @public @memberof QTimeEvt
bool QTimeEvt_noActive(uint_fast8_t const tickRate);
//$enddecl${QF::QTimeEvt} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QTicker} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QTicker} .............................................................
//! @class QTicker
// @extends QActive
typedef struct {
// protected:
    QActive super;
} QTicker;

// public:

//! @public @memberof QTicker
void QTicker_ctor(QTicker * const me,
    uint_fast8_t const tickRate);

// private:

//! @private @memberof QTicker
void QTicker_init_(
    QAsm * const me,
    void const * const par,
    uint_fast8_t const qs_id);

//! @private @memberof QTicker
void QTicker_dispatch_(
    QAsm * const me,
    QEvt const * const e,
    uint_fast8_t const qs_id);

//! @private @memberof QTicker
void QTicker_trig_(
    QActive * const me,
    void const * const sender);
//$enddecl${QF::QTicker} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QF-base} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QF-base::init} .......................................................
//! @static @public @memberof QF
void QF_init(void);

//${QF::QF-base::stop} .......................................................
//! @static @public @memberof QF
void QF_stop(void);

//${QF::QF-base::run} ........................................................
//! @static @public @memberof QF
int_t QF_run(void);

//${QF::QF-base::getQueueMin} ................................................
//! @static @public @memberof QF
uint_fast16_t QF_getQueueMin(uint_fast8_t const prio);

//${QF::QF-base::onStartup} ..................................................
//! @static @public @memberof QF
void QF_onStartup(void);

//${QF::QF-base::onCleanup} ..................................................
//! @static @public @memberof QF
void QF_onCleanup(void);

//${QF::QF-base::onContextSw} ................................................
#ifdef QF_ON_CONTEXT_SW
//! @static @public @memberof QF
void QF_onContextSw(
    QActive * prev,
    QActive * next);
#endif // def QF_ON_CONTEXT_SW
//$enddecl${QF::QF-base} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF::QF-dyn} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QF-dyn::poolInit} ....................................................
//! @static @public @memberof QF
void QF_poolInit(
    void * const poolSto,
    uint_fast32_t const poolSize,
    uint_fast16_t const evtSize);

//${QF::QF-dyn::poolGetMaxBlockSize} .........................................
//! @static @public @memberof QF
uint_fast16_t QF_poolGetMaxBlockSize(void);

//${QF::QF-dyn::getPoolMin} ..................................................
//! @static @public @memberof QF
uint_fast16_t QF_getPoolMin(uint_fast8_t const poolId);

//${QF::QF-dyn::newX_} .......................................................
//! @static @private @memberof QF
QEvt * QF_newX_(
    uint_fast16_t const evtSize,
    uint_fast16_t const margin,
    enum_t const sig);

//${QF::QF-dyn::gc} ..........................................................
//! @static @public @memberof QF
void QF_gc(QEvt const * const e);

//${QF::QF-dyn::newRef_} .....................................................
//! @static @private @memberof QF
QEvt const * QF_newRef_(
    QEvt const * const e,
    void const * const evtRef);

//${QF::QF-dyn::deleteRef_} ..................................................
//! @static @private @memberof QF
void QF_deleteRef_(void const * const evtRef);

//${QF::QF-dyn::gcFromISR} ...................................................
//! @static @public @memberof QF
void QF_gcFromISR(QEvt const * const e);
//$enddecl${QF::QF-dyn} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

//$declare${QF-macros} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF-macros::QF_NO_MARGIN} .................................................
#define QF_NO_MARGIN ((uint_fast16_t)0xFFFFU)

//${QF-macros::Q_PRIO} .......................................................
#define Q_PRIO(prio_, pthre_) ((QPrioSpec)((prio_) | ((pthre_) << 8U)))

//${QF-macros::Q_NEW} ........................................................
#ifndef QEVT_DYN_CTOR
#define Q_NEW(evtT_, sig_) ((evtT_ *)QF_newX_((uint_fast16_t)sizeof(evtT_), \
                           QF_NO_MARGIN, (enum_t)(sig_)))
#endif // ndef QEVT_DYN_CTOR

//${QF-macros::Q_NEW} ........................................................
#ifdef QEVT_DYN_CTOR
#define Q_NEW(evtT_, sig_, ...) \
    (evtT_##_ctor((evtT_ *)QF_newX_((uint_fast16_t)sizeof(evtT_), \
                  QF_NO_MARGIN, (sig_)), __VA_ARGS__))
#endif // def QEVT_DYN_CTOR

//${QF-macros::Q_NEW_X} ......................................................
#ifndef QEVT_DYN_CTOR
#define Q_NEW_X(evtT_, margin_, sig_) \
    ((evtT_ *)QF_newX_((uint_fast16_t)sizeof(evtT_), \
                      (margin_), (enum_t)(sig_)))
#endif // ndef QEVT_DYN_CTOR

//${QF-macros::Q_NEW_X} ......................................................
#ifdef QEVT_DYN_CTOR
#define Q_NEW_X(evtT_, margin_, sig_, ...) \
    (evtT_##_ctor((evtT_ *)QF_newX_((uint_fast16_t)sizeof(evtT_), \
                  (margin_), (sig_)), __VA_ARGS__))
#endif // def QEVT_DYN_CTOR

//${QF-macros::Q_NEW_REF} ....................................................
#define Q_NEW_REF(evtRef_, evtT_) \
    ((evtRef_) = (evtT_ const *)QF_newRef_(e, (evtRef_)))

//${QF-macros::Q_DELETE_REF} .................................................
#define Q_DELETE_REF(evtRef_) do { \
    QF_deleteRef_((evtRef_)); \
    (evtRef_) = (void *)0; \
} while (false)

//${QF-macros::QACTIVE_START} ................................................
#define QACTIVE_START(me_, prioSpec_, qSto_, qLen_, stkSto_, stkSize_, par_) \
    (QActive_start_((QActive *)(me_), (prioSpec_), \
        (qSto_), (qLen_), (stkSto_), (stkSize_), (par_)))

//${QF-macros::QACTIVE_POST} .................................................
#ifdef Q_SPY
#define QACTIVE_POST(me_, e_, sender_) \
    ((void)QActive_post_((me_), (e_), QF_NO_MARGIN, (sender_)))
#endif // def Q_SPY

//${QF-macros::QACTIVE_POST} .................................................
#ifndef Q_SPY
#define QACTIVE_POST(me_, e_, dummy) \
    ((void)QActive_post_((me_), (e_), QF_NO_MARGIN, (void *)0))
#endif // ndef Q_SPY

//${QF-macros::QACTIVE_POST_X} ...............................................
#ifdef Q_SPY
#define QACTIVE_POST_X(me_, e_, margin_, sender_) \
    (QActive_post_((me_), (e_), (margin_), (sender_)))
#endif // def Q_SPY

//${QF-macros::QACTIVE_POST_X} ...............................................
#ifndef Q_SPY
#define QACTIVE_POST_X(me_, e_, margin_, dummy) \
    (QActive_post_((me_), (e_), (margin_), (void *)0))
#endif // ndef Q_SPY

//${QF-macros::QACTIVE_POST_LIFO} ............................................
#define QACTIVE_POST_LIFO(me_, e_) \
    (QActive_postLIFO_((me_), (e_)))

//${QF-macros::QACTIVE_PUBLISH} ..............................................
#ifdef Q_SPY
#define QACTIVE_PUBLISH(e_, sender_) \
    (QActive_publish_((e_), (void const *)(sender_), (sender_)->prio))
#endif // def Q_SPY

//${QF-macros::QACTIVE_PUBLISH} ..............................................
#ifndef Q_SPY
#define QACTIVE_PUBLISH(e_, dummy) (QActive_publish_((e_), (void *)0, 0U))
#endif // ndef Q_SPY

//${QF-macros::QTIMEEVT_TICK_X} ..............................................
#ifdef Q_SPY
#define QTIMEEVT_TICK_X(tickRate_, sender_) (QTimeEvt_tick_((tickRate_), (sender_)))
#endif // def Q_SPY

//${QF-macros::QTIMEEVT_TICK_X} ..............................................
#ifndef Q_SPY
#define QTIMEEVT_TICK_X(tickRate_, dummy) (QTimeEvt_tick_((tickRate_), (void *)0))
#endif // ndef Q_SPY

//${QF-macros::QTIMEEVT_TICK} ................................................
#define QTIMEEVT_TICK(sender_) QTIMEEVT_TICK_X(0U, (sender_))

//${QF-macros::QTICKER_TRIG} .................................................
#ifdef Q_SPY
#define QTICKER_TRIG(ticker_, sender_) (QTicker_trig_((ticker_), (sender_)))
#endif // def Q_SPY

//${QF-macros::QTICKER_TRIG} .................................................
#ifndef Q_SPY
#define QTICKER_TRIG(ticker_, sender_) (QTicker_trig_((ticker_), (void *)0))
#endif // ndef Q_SPY

//${QF-macros::QF_CRIT_EXIT_NOP} .............................................
#ifndef QF_CRIT_EXIT_NOP
#define QF_CRIT_EXIT_NOP() ((void)0)
#endif // ndef QF_CRIT_EXIT_NOP

//${QF-macros::QF_TICK_X} ....................................................
#define QF_TICK_X(tickRate_, sender_) QTIMEEVT_TICK_X((tickRate_), (sender_))

//${QF-macros::QF_TICK} ......................................................
#define QF_TICK(sender_) QTIMEEVT_TICK(sender_)

//${QF-macros::QF_PUBLISH} ...................................................
#define QF_PUBLISH(e_, sender_) QACTIVE_PUBLISH((e_), (sender_))

//${QF-macros::QF_MEM_SYS} ...................................................
#ifndef QF_MEM_SYS
#define QF_MEM_SYS() ((void)0)
#endif // ndef QF_MEM_SYS

//${QF-macros::QF_MEM_APP} ...................................................
#ifndef QF_MEM_APP
#define QF_MEM_APP() ((void)0)
#endif // ndef QF_MEM_APP
//$enddecl${QF-macros} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

#endif // QP_H_
