## Brought to you by:
[![Quantum Leaps](https://www.state-machine.com/attachments/logo_ql_400.png)](https://www.state-machine.com)

---------------------------------------------------------------------
![QP Framework](https://www.state-machine.com/img/qp_banner.jpg)

# About this QP/C version
This folder contains a stripped-down version of the
[QP/C Real-Time Embedded Framework](https://www.state-machine.com/products/qp).
This folder contains only the QP/C source code, ports, and 3rd-party code
pertaining to the "Modern Embedded Systems Programming" video course.
All other elements normally included in the full QP/C distribution have been
deleted to reduce the size of this folder. Please refer to the complete
[QP/C distribution on GitHub](https://github.com/QuantumLeaps/qpc).

# QP/C Licensing
QP/C is licensed under the sustainable [dual licensing model][Lic],
in which both the open source software distribution mechanism and
traditional closed source software distribution models are combined.
QP/C is available under the following licenses:

- [GPLv3](https://www.gnu.org/copyleft/gpl.html) (SPDX-License-Identifier: GPL-3.0-or-later); or
- [commercial Quantum Leaps license](https://www.state-machine.com/licensing#Commercial)
  (SPDX-License-Identifier: LicenseRef-QL-commercial)

> **NOTE:** If your company has a policy forbidding open source in your
product, all QP frameworks can be [licensed commercially][Lic], in which case
you don't use any open source license and you do not violate your policy.


# QP/C Documentation
The online HTML documention for the **latest** version of QP/C is located
at: https://www.state-machine.com/qpc

# How to Get Help?
- [Free Support Forum](https://sourceforge.net/p/qpc/discussion/668726)
- [Bug Reports](https://sourceforge.net/p/qpc/bugs/)
- [Feature Requests](https://sourceforge.net/p/qpc/feature-requests/)
- [Quantum Leaps website](https://www.state-machine.com)
- [Quantum Leaps licensing](https://www.state-machine.com/licensing)
- [info@state-machine.com](mailto:info@state-machine.com)


# How to Help this Project?
If you like this project, please give it a star (in the upper-right corner of your browser window):

![GitHub star](https://www.state-machine.com/img/github-star.jpg)


   [RTEF]: <https://www.state-machine.com/rtef>
   [QP]: <https://www.state-machine.com/products/qp>
   [QP/C]: <https://www.state-machine.com/qpc>
   [QP/C++]: <https://www.state-machine.com/qpcpp>
   [QM]: <https://www.state-machine.com/products/qm>
   [Active]: <https://www.state-machine.com/active-object>
   [HSM]: <https://www.state-machine.com/fsm#HSM>
   [Lic]: <https://www.state-machine.com/licensing>
   [Cust]: <https://www.state-machine.com/customers>
   [AN]: <https://www.state-machine.com/doc/AN_Getting_Started_with_QP.pdf>
   [Tutorial]: <https://www.state-machine.com/qpc/gs_tut.html>
   [Video]: <https://youtu.be/O7ER6_VqIH0>
