//$file${include::qequeue.h} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
//
// Model: qpc.qm
// File:  ${include::qequeue.h}
//
// This code has been generated by QM 5.3.0 <www.state-machine.com/qm>.
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This code is covered by the following QP license:
// License #    : LicenseRef-QL-dual
// Issued to    : Any user of the QP/C real-time embedded framework
// Framework(s) : qpc
// Support ends : 2024-12-31
// License scope:
//
// Copyright (C) 2005 Quantum Leaps, LLC <state-machine.com>.
//
//                    Q u a n t u m  L e a P s
//                    ------------------------
//                    Modern Embedded Software
//
// SPDX-License-Identifier: GPL-3.0-or-later OR LicenseRef-QL-commercial
//
// This software is dual-licensed under the terms of the open source GNU
// General Public License version 3 (or any later version), or alternatively,
// under the terms of one of the closed source Quantum Leaps commercial
// licenses.
//
// The terms of the open source GNU General Public License version 3
// can be found at: <www.gnu.org/licenses/gpl-3.0>
//
// The terms of the closed source Quantum Leaps commercial licenses
// can be found at: <www.state-machine.com/licensing>
//
// Redistributions in source code must retain this top-level comment block.
// Plagiarizing this software to sidestep the license obligations is illegal.
//
// Contact information:
// <www.state-machine.com/licensing>
// <info@state-machine.com>
//
//$endhead${include::qequeue.h} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#ifndef QEQUEUE_H_
#define QEQUEUE_H_

#ifndef QF_EQUEUE_CTR_SIZE
    #define QF_EQUEUE_CTR_SIZE 1U
#endif

#if (QF_EQUEUE_CTR_SIZE == 1U)
    typedef uint8_t QEQueueCtr;
#elif (QF_EQUEUE_CTR_SIZE == 2U)
    typedef uint16_t QEQueueCtr;
#elif (QF_EQUEUE_CTR_SIZE == 4U)
    typedef uint32_t QEQueueCtr;
#else
    #error "QF_EQUEUE_CTR_SIZE defined incorrectly, expected 1U, 2U, or 4U"
#endif

struct QEvt; // forward declaration

//$declare${QF::QEQueue} vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

//${QF::QEQueue} .............................................................
//! @class QEQueue
typedef struct QEQueue {
// private:

    //! @private @memberof QEQueue
    struct QEvt const * volatile frontEvt;

    //! @private @memberof QEQueue
    struct QEvt const ** ring;

    //! @private @memberof QEQueue
    QEQueueCtr end;

    //! @private @memberof QEQueue
    QEQueueCtr volatile head;

    //! @private @memberof QEQueue
    QEQueueCtr volatile tail;

    //! @private @memberof QEQueue
    QEQueueCtr volatile nFree;

    //! @private @memberof QEQueue
    QEQueueCtr nMin;

// public:
} QEQueue;
extern QEQueue QEQueue_dummy;

// public:

//! @public @memberof QEQueue
void QEQueue_init(QEQueue * const me,
    struct QEvt const ** const qSto,
    uint_fast16_t const qLen);

//! @public @memberof QEQueue
bool QEQueue_post(QEQueue * const me,
    struct QEvt const * const e,
    uint_fast16_t const margin,
    uint_fast8_t const qs_id);

//! @public @memberof QEQueue
void QEQueue_postLIFO(QEQueue * const me,
    struct QEvt const * const e,
    uint_fast8_t const qs_id);

//! @public @memberof QEQueue
struct QEvt const * QEQueue_get(QEQueue * const me,
    uint_fast8_t const qs_id);

//! @public @memberof QEQueue
static inline QEQueueCtr QEQueue_getNFree(QEQueue const * const me) {
    return me->nFree;
}

//! @public @memberof QEQueue
static inline QEQueueCtr QEQueue_getNMin(QEQueue const * const me) {
    return me->nMin;
}

//! @public @memberof QEQueue
static inline bool QEQueue_isEmpty(QEQueue const * const me) {
    return me->frontEvt == (struct QEvt *)0;
}
//$enddecl${QF::QEQueue} ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

#endif // QEQUEUE_H_
