/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import statemap.State7;
import statemap.StateUndefinedException;
import statemap.TransitionHandle;
import statemap.TransitionUndefinedException;

public abstract class FSMContext7
implements Serializable {
    public static final String STATE_PROPERTY = "State";
    protected static final int DEFAULT_TRANSITION_ID = 0;
    protected static final String DEFAULT_NAME = "Default";
    protected static final String SYSTEM_DEFAULT = "defaultTransition";
    protected static final String STATE_NAME_FORMAT = "%s_%s";
    protected static final String ENTRY_NAME = "%s_%s__Entry_";
    protected static final String EXIT_NAME = "%s_%s__Exit_";
    protected static final String TRANSITION_NAME_FORMAT = "%s_%s_%s";
    protected static final MethodType NO_ARGS_TYPE = MethodType.methodType(Void.TYPE);
    private static final long serialVersionUID = 459008L;
    protected transient String mName = "FSMContext";
    protected transient State7 mState;
    protected transient String mTransition;
    protected transient State7 mPreviousState;
    protected transient Deque<State7> mStateStack;
    protected transient boolean mDebugFlag;
    protected transient PrintStream mDebugStream;
    private transient PropertyChangeSupport mListeners;

    protected FSMContext7(State7 initState) {
        this.mState = initState;
        this.mTransition = "";
        this.mPreviousState = null;
        this.mStateStack = null;
        this.mDebugFlag = false;
        this.mDebugStream = System.err;
        this.mListeners = new PropertyChangeSupport(this);
    }

    protected abstract void executeAction(MethodHandle var1);

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        istream.defaultReadObject();
        this.mListeners = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.mName;
    }

    public boolean getDebugFlag() {
        return this.mDebugFlag && this.mDebugStream != null;
    }

    public PrintStream getDebugStream() {
        return this.mDebugStream == null ? System.err : this.mDebugStream;
    }

    public boolean isInTransition() {
        return this.mState == null;
    }

    public State7 getState() throws StateUndefinedException {
        if (this.mState == null) {
            throw new StateUndefinedException();
        }
        return this.mState;
    }

    public State7 getPreviousState() throws NullPointerException {
        return this.mPreviousState;
    }

    public String getTransition() {
        return this.mTransition;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0 && !name.equals(this.mName)) {
            this.mName = name;
        }
    }

    public void setDebugFlag(boolean flag) {
        this.mDebugFlag = flag;
    }

    public void setDebugStream(PrintStream stream) {
        this.mDebugStream = stream;
    }

    public void setState(State7 state) {
        if (this.mDebugFlag) {
            this.mDebugStream.println("ENTERING STATE  : " + state.getName());
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = state;
        this.mListeners.firePropertyChange(STATE_PROPERTY, this.mPreviousState, this.mState);
    }

    public void clearState() {
        this.mPreviousState = this.mState;
        this.mState = null;
    }

    public void pushState(State7 state) {
        if (this.mState == null) {
            throw new NullPointerException();
        }
        if (this.mDebugFlag) {
            this.mDebugStream.println("PUSH TO STATE   : " + state.getName());
        }
        if (this.mStateStack == null) {
            this.mStateStack = new ArrayDeque<State7>();
        }
        this.mPreviousState = this.mState;
        this.mStateStack.push(this.mState);
        this.mState = state;
        this.mListeners.firePropertyChange(STATE_PROPERTY, this.mPreviousState, this.mState);
    }

    public void popState() throws EmptyStackException {
        if (this.mStateStack == null || this.mStateStack.isEmpty()) {
            if (this.mDebugFlag) {
                this.mDebugStream.println("POPPING ON EMPTY STATE STACK.");
            }
            throw new EmptyStackException();
        }
        if (this.mState != null) {
            this.mPreviousState = this.mState;
        }
        this.mState = this.mStateStack.pop();
        if (this.mStateStack.isEmpty()) {
            this.mStateStack = null;
        }
        if (this.mDebugFlag) {
            this.mDebugStream.println("POP TO STATE    : " + this.mState.getName());
        }
        this.mListeners.firePropertyChange(STATE_PROPERTY, this.mPreviousState, this.mState);
    }

    public void emptyStateStack() {
        if (this.mStateStack != null) {
            this.mStateStack.clear();
            this.mStateStack = null;
        }
    }

    public void enterStartState() {
        this.enterState();
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        this.mListeners.addPropertyChangeListener(STATE_PROPERTY, listener);
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this.mListeners.removePropertyChangeListener(STATE_PROPERTY, listener);
    }

    protected void defaultTransition() {
        if (this.mDebugFlag) {
            this.mDebugStream.println("TRANSITION      : Default");
        }
        throw new TransitionUndefinedException("State: " + this.stateName() + ", Transition: " + this.getTransition());
    }

    protected String stateName() {
        return this.mState != null ? this.mState.getName() : (this.mPreviousState != null ? this.mPreviousState.getName() : "(state unknown)");
    }

    protected void enterState() {
        MethodHandle mh = this.mState.enterState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected void exitState() {
        MethodHandle mh = this.mState.exitState();
        if (mh != null) {
            this.executeAction(mh);
        }
    }

    protected static MethodHandle lookupMethod(MethodHandles.Lookup lookup, Class<?> clazz, String name, MethodType mt) {
        MethodHandle retval = null;
        try {
            retval = lookup.findVirtual(clazz, name, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException | NullPointerException | SecurityException exception) {
            // empty catch block
        }
        return retval;
    }

    protected static TransitionHandle lookupTransition(MethodHandles.Lookup lookup, Class<?> clazz, String mapName, String stateName, String transName, MethodType methodType) {
        MethodType mt = methodType;
        String mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, transName);
        boolean isDefault = false;
        MethodHandle mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
        if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, transName), mt)) == null) {
            isDefault = true;
            mt = NO_ARGS_TYPE;
            mn = String.format(TRANSITION_NAME_FORMAT, mapName, stateName, DEFAULT_NAME);
            mh = FSMContext7.lookupMethod(lookup, clazz, mn, mt);
            if (mh == null && (mh = FSMContext7.lookupMethod(lookup, clazz, mn = String.format(TRANSITION_NAME_FORMAT, mapName, DEFAULT_NAME, DEFAULT_NAME), mt)) == null) {
                mh = FSMContext7.lookupMethod(lookup, clazz, SYSTEM_DEFAULT, mt);
            }
        }
        return new TransitionHandle(isDefault, mh);
    }
}

