/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;
import net.sf.smc.parser.SmcLexer;
import net.sf.smc.parser.SmcMessage;
import net.sf.smc.parser.SmcParserContext;

public final class SmcParser {
    public static final int LANGUAGE_COUNT = 19;
    private static List<Character> OPEN_CLAUSE_LIST;
    private static List<Character> CLOSE_CLAUSE_LIST;
    private static List<Character> QUOTE_LIST;
    private static Method[] sTransMethod;
    private final String mName;
    private final TargetLanguage mTargetLanguage;
    private final List<SmcMessage> mMessages;
    private final SmcParserContext mParserFSM;
    private final SmcLexer mLexer;
    private boolean mParseStatus;
    private boolean mQuitFlag;
    private SmcFSM mFsm;
    private SmcMap mMapInProgress;
    private SmcState mStateInProgress;
    private String mTransitionName;
    private SmcTransition mTransitionInProgress;
    private SmcGuard mGuardInProgress;
    private SmcParameter mParamInProgress;
    private SmcAction mActionInProgress;
    private String mArgInProgress;
    private List<SmcParameter> mParamList;
    private List<SmcAction> mActionList;
    private List<String> mArgList;
    private int mLineNumber;
    private final Map<TransitionKey, Integer> mTransitions;
    private int mNextTransitionId;

    public SmcParser(String name, InputStream istream, TargetLanguage targetLanguage, boolean debugFlag) {
        this.mName = name;
        this.mTargetLanguage = targetLanguage;
        this.mMessages = new ArrayList<SmcMessage>();
        this.mTransitions = new HashMap<TransitionKey, Integer>();
        this.mNextTransitionId = 1;
        this.mLexer = new SmcLexer(istream, debugFlag);
        this.mParserFSM = new SmcParserContext(this);
        this.mParserFSM.setDebugFlag(debugFlag);
    }

    public SmcFSM parse() throws IOException, IllegalAccessException, InvocationTargetException {
        SmcLexer.Token token = null;
        Object[] params = new Object[1];
        this.mMapInProgress = null;
        this.mStateInProgress = null;
        this.mTransitionName = null;
        this.mTransitionInProgress = null;
        this.mGuardInProgress = null;
        this.mParamInProgress = null;
        this.mActionInProgress = null;
        this.mArgInProgress = null;
        this.mParamList = null;
        this.mActionList = null;
        this.mArgList = null;
        this.mParseStatus = true;
        this.mQuitFlag = false;
        this.mFsm = new SmcFSM(this.mName, this.mTargetLanguage.targetFileName(this.mName));
        this.mLexer.setCookedMode();
        while (!this.mQuitFlag && (token = this.mLexer.nextToken()) != null) {
            int tokenType = token.getType();
            this.mLineNumber = token.getLineNumber();
            if (tokenType <= 0 && tokenType >= 33) {
                this.error("Undefined token type (" + Integer.toString(tokenType) + ")", token.getLineNumber());
                this.mQuitFlag = true;
                this.mParseStatus = false;
                continue;
            }
            if (tokenType == 1) {
                this.mQuitFlag = true;
                this.mParseStatus = false;
                this.error(token.getValue(), token.getLineNumber());
                continue;
            }
            if (tokenType == 2) {
                this.mQuitFlag = true;
                continue;
            }
            params[0] = token;
            sTransMethod[tokenType].invoke((Object)this.mParserFSM, params);
        }
        if (!this.mParseStatus) {
            this.mFsm = null;
        }
        return this.mFsm;
    }

    public List<SmcMessage> getMessages() {
        return this.mMessages;
    }

    boolean isValidHeader() {
        String context = this.mFsm.getContext();
        String start = this.mFsm.getStartState();
        return context != null && context.length() > 0 && start != null && start.length() > 0;
    }

    boolean isValidStartState(String name) {
        boolean retval = false;
        int index = name.indexOf("::");
        if (index >= 0 && name.indexOf("::", index + 1) < 0) {
            retval = true;
        }
        return retval;
    }

    boolean isDuplicateMap(String name) {
        return this.mFsm.findMap(name) != null;
    }

    boolean isDuplicateState(String name) {
        return this.mMapInProgress.isKnownState(name);
    }

    boolean isDefaultState() {
        return this.mStateInProgress.isDefaultState();
    }

    void warning(String errorMsg, int lineNumber) {
        this.mMessages.add(new SmcMessage(this.mName, lineNumber, 0, errorMsg));
    }

    void error(String errorMsg, int lineNumber) {
        this.mMessages.add(new SmcMessage(this.mName, lineNumber, 1, errorMsg));
        this.mParseStatus = false;
    }

    int getLineNumber() {
        return this.mLineNumber;
    }

    TargetLanguage getTargetLanguage() {
        return this.mTargetLanguage;
    }

    void setRawMode(String openChar, String closeChar, String dummy) {
        this.mLexer.setRawMode(openChar.charAt(0), closeChar.charAt(0));
    }

    void setRawMode(String openChar, String closeChar) {
        this.mLexer.setRawMode(openChar.charAt(0), closeChar.charAt(0));
    }

    void setRawMode2() {
        this.mLexer.setRawMode(OPEN_CLAUSE_LIST, CLOSE_CLAUSE_LIST, QUOTE_LIST, ')', ',');
    }

    void setRawMode(String closeChars) {
        this.mLexer.setRawMode(closeChars);
    }

    void setCookedMode() {
        this.mLexer.setCookedMode();
    }

    void setHeaderLine(int lineNumber) {
        this.mFsm.setHeaderLine(lineNumber);
    }

    void setSource(String source) {
        String src = this.mFsm.getSource();
        if (src != null && src.length() > 0) {
            this.warning("%{ %} source previously specified, new source ignored.", this.mLineNumber);
        } else {
            this.mFsm.setSource(source);
        }
    }

    void setStartState(String stateName) {
        String start = this.mFsm.getStartState();
        if (start != null && start.length() > 0) {
            this.warning("%start previously specified, new start state ignored.", this.mLineNumber);
        } else {
            this.mFsm.setStartState(stateName);
        }
    }

    void setContext(String name) {
        String context = this.mFsm.getContext();
        if (context != null && context.length() > 0) {
            this.warning("%class previously specified, new context ignored.", this.mLineNumber);
        } else {
            this.mFsm.setContext(name);
        }
    }

    void setFsmClassName(String name) {
        this.mFsm.setFsmClassName(name.trim());
    }

    void setFsmFileName(String name) {
        this.mFsm.setFsmTargetFile(name.trim());
    }

    void setPackageName(String name) {
        String pkg = this.mFsm.getPackage();
        if (pkg != null && pkg.length() > 0) {
            this.warning("%package previously specified, new package ignored.", this.mLineNumber);
        } else {
            this.mFsm.setPackage(name.trim());
        }
    }

    void addImport(String name) {
        this.mFsm.addImport(name.trim());
    }

    void addDeclare(String name) {
        this.mFsm.addDeclare(name.trim());
    }

    void setHeader(String name) {
        String header = this.mFsm.getHeader();
        if (header != null && header.length() > 0) {
            this.warning("%header previously specified, new header file ignored.", this.mLineNumber);
        } else {
            this.mFsm.setHeader(name.trim());
        }
    }

    void addInclude(String name) {
        this.mFsm.addInclude(name.trim());
    }

    void setAccessLevel(String level) {
        String accessLevel = this.mFsm.getAccessLevel();
        if (accessLevel != null && accessLevel.length() > 0) {
            this.warning("%access previously specified, new access level ignored.", this.mLineNumber);
        } else {
            this.mFsm.setAccessLevel(level.trim());
        }
    }

    void addMap() {
        if (this.mMapInProgress == null) {
            this.error("There is no in-progress map to add", this.mLineNumber);
        } else {
            if (!this.mMapInProgress.hasDefaultState()) {
                SmcState DefaultState = new SmcState("Default", this.mMapInProgress.getLineNumber(), this.mMapInProgress);
                this.mMapInProgress.addState(DefaultState);
            }
            this.mFsm.addMap(this.mMapInProgress);
            this.mMapInProgress = null;
        }
    }

    void createMap(String name, int lineNumber) {
        if (this.mMapInProgress != null) {
            this.error("Cannot create new map while still filling in previous map (" + this.mMapInProgress.getName() + ").", lineNumber);
        } else {
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("CREATE MAP   : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this.mMapInProgress = new SmcMap(name, lineNumber, this.mFsm);
        }
    }

    void addState() {
        if (this.mMapInProgress == null) {
            this.error("There is no in-progress map to which the state may be added.", this.mLineNumber);
        } else if (this.mStateInProgress == null) {
            this.error("There is no in-progrss state to add to the map.", this.mLineNumber);
        } else {
            this.mMapInProgress.addState(this.mStateInProgress);
            this.mStateInProgress = null;
        }
    }

    void createState(String name, int lineNumber) {
        if (this.mStateInProgress != null) {
            this.error("Cannot create new state while still filling in previous state (" + this.mStateInProgress.getName() + ").", lineNumber);
        } else {
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("CREATE STATE : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this.mStateInProgress = new SmcState(name, lineNumber, this.mMapInProgress);
        }
    }

    void setEntryAction(List<SmcAction> actions) {
        if (this.mStateInProgress == null) {
            this.error("There is no in-progress state to receive the entry action.", this.mLineNumber);
        } else if (this.mStateInProgress.getEntryActions() != null) {
            this.warning("Entry action previously specified, new entry action ignored.", this.mLineNumber);
        } else {
            this.mStateInProgress.setEntryActions(actions);
        }
    }

    void setExitAction(List<SmcAction> actions) {
        if (this.mStateInProgress == null) {
            this.error("There is no in-progress state to receive the exit action.", this.mLineNumber);
        } else if (this.mStateInProgress.getExitActions() != null) {
            this.warning("Exit action previously specified, new exit action ignored.", this.mLineNumber);
        } else {
            this.mStateInProgress.setExitActions(actions);
        }
    }

    void addTransition() {
        if (this.mStateInProgress == null) {
            this.error("There is no in-progress state to which the transition may be added.", this.mLineNumber);
        } else if (this.mTransitionInProgress == null) {
            this.error("There is no in-progress transition to add to the state.", this.mLineNumber);
        } else {
            this.mStateInProgress.addTransition(this.mTransitionInProgress);
            this.mTransitionInProgress = null;
        }
    }

    String getTransitionName() {
        return this.mTransitionInProgress != null ? this.mTransitionInProgress.getName() : this.mTransitionName;
    }

    void storeTransitionName(String name) {
        if (this.mTransitionName != null) {
            this.error("There already is a previously stored transition name - \"" + name + "\".", this.mLineNumber);
        } else {
            this.mTransitionName = name;
        }
    }

    void createTransition(List<SmcParameter> params, int lineNumber) {
        if (this.mTransitionInProgress != null) {
            this.error("Cannot create new transition while still filling in previous transition (" + this.mTransitionInProgress.getName() + ").", lineNumber);
        } else if (this.mStateInProgress == null) {
            this.error("There is no in-progress state to which the transition may be added.", lineNumber);
        } else if (this.mTransitionName == null) {
            this.error("There is no stored transition name.", lineNumber);
        } else {
            this.mTransitionInProgress = this.mStateInProgress.findTransition(this.mTransitionName, params);
            if (this.mTransitionInProgress == null) {
                int transId = this.getTransitionId(new TransitionKey(this.mTransitionName, params));
                if (this.mParserFSM.getDebugFlag()) {
                    PrintStream os = this.mParserFSM.getDebugStream();
                    StringBuffer buffer = new StringBuffer(80);
                    buffer.append("CREATE TRANS : ");
                    buffer.append(this.mTransitionName);
                    buffer.append('(');
                    Iterator<SmcParameter> pit = params.iterator();
                    String sep = "";
                    while (pit.hasNext()) {
                        buffer.append(sep);
                        buffer.append(pit.next());
                        sep = ", ";
                    }
                    buffer.append(')');
                    buffer.append(" (");
                    buffer.append(lineNumber);
                    buffer.append(")");
                    os.println(buffer);
                }
                this.mTransitionInProgress = new SmcTransition(this.mTransitionName, params, transId, lineNumber, this.mStateInProgress);
            }
            this.mTransitionName = null;
        }
    }

    void createTransition(int lineNumber) {
        this.createTransition(new ArrayList<SmcParameter>(), lineNumber);
    }

    void addGuard() {
        if (this.mTransitionInProgress == null) {
            this.error("There is no in-progress transition to which the guard may be added.", this.mLineNumber);
        } else if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to add to the " + this.mTransitionInProgress.getName() + " transition.", this.mLineNumber);
        } else {
            this.mTransitionInProgress.addGuard(this.mGuardInProgress);
            this.mGuardInProgress = null;
        }
    }

    void createGuard(String transition, String condition, int lineNumber) {
        if (this.mGuardInProgress != null) {
            this.error("Cannot create new guard while still filling in previous guard.", lineNumber);
        } else {
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("CREATE GUARD : " + condition + "(" + Integer.toString(lineNumber) + ")");
            }
            this.mGuardInProgress = new SmcGuard(condition, lineNumber, this.mTransitionInProgress);
        }
    }

    void setTransType(SmcElement.TransType trans_type) {
        if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to which to set the transition type.", this.mLineNumber);
        } else {
            switch (trans_type) {
                case TRANS_SET: 
                case TRANS_PUSH: 
                case TRANS_POP: {
                    this.mGuardInProgress.setTransType(trans_type);
                    break;
                }
                default: {
                    this.error("Transition type must be either \"TRANS_SET\", \"TRANS_PUSH\" or \"TRANS_POP\".", this.mLineNumber);
                }
            }
        }
    }

    void setEndState(String state) {
        if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to which to add the end state.", this.mLineNumber);
        } else {
            this.mGuardInProgress.setEndState(state);
        }
    }

    void setPushState(String name) {
        if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to which to add the end state.", this.mLineNumber);
        } else if (this.mGuardInProgress.getTransType() != SmcElement.TransType.TRANS_PUSH) {
            this.error("Cannot set push state on a non-push transition.", this.mLineNumber);
        } else if (name.equals("nil")) {
            this.error("Cannot push to \"nil\" state.", this.mLineNumber);
        } else {
            this.mGuardInProgress.setPushState(name);
        }
    }

    void setActions(List<SmcAction> actions) {
        if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to which to add the action.", this.mLineNumber);
        } else {
            this.mGuardInProgress.setActions(actions);
        }
    }

    void setPopArgs(String args) {
        if (this.mGuardInProgress == null) {
            this.error("There is no in-progress guard to which to add the action.", this.mLineNumber);
        } else {
            this.mGuardInProgress.setPopArgs(args);
        }
    }

    void createParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList<SmcParameter>();
        }
    }

    List<SmcParameter> getParamList() {
        List<SmcParameter> retval = this.mParamList;
        this.mParamList = null;
        return retval;
    }

    void createParameter(String name, int lineNumber) {
        if (this.mParamInProgress != null) {
            this.error("Cannot create new parameter while still filling in previous one.", lineNumber);
        } else {
            String type = "";
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("CREATE PARAM : " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            if (this.mTargetLanguage == TargetLanguage.TCL) {
                type = "value";
            }
            this.mParamInProgress = new SmcParameter(name, lineNumber, type);
        }
    }

    void setParamType(String type) {
        if (this.mParamInProgress == null) {
            this.error("There is no in-progress parameter to which to add the type.", this.mLineNumber);
        } else {
            this.mParamInProgress.setType(type);
        }
    }

    void addParameter() {
        if (this.mParamList == null) {
            this.error("There is no parameter list to which the parameter may be added.", this.mLineNumber);
        } else if (this.mParamInProgress == null) {
            this.error("There is no in-progress parameter to add to the list.", this.mLineNumber);
        } else {
            this.mParamList.add(this.mParamInProgress);
            this.mParamInProgress = null;
        }
    }

    void clearParameter() {
        this.mParamInProgress = null;
    }

    void createActionList() {
        if (this.mActionList != null) {
            this.error("Cannot create an action list when one already exists.", this.mLineNumber);
        } else {
            this.mActionList = new ArrayList<SmcAction>();
        }
    }

    List<SmcAction> getActionList() {
        List<SmcAction> retval = this.mActionList;
        this.mActionList = null;
        return retval;
    }

    void createAction(String name, int lineNumber) {
        if (this.mActionInProgress != null) {
            this.error("Cannot create new action while still filling in previous one.", lineNumber);
        } else {
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("CREATE ACTION: " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this.mActionInProgress = new SmcAction(name, lineNumber);
        }
    }

    void setActionArgs(List<String> args) {
        if (this.mActionInProgress == null) {
            this.error("There is no in-progress action to which to add the arguments.", this.mLineNumber);
        } else {
            this.mActionInProgress.setArguments(args);
        }
    }

    void addAction() {
        if (this.mActionList == null) {
            this.error("There is no action list to which the action may be added.", this.mLineNumber);
        } else if (this.mActionInProgress == null) {
            this.error("There is no in-progress action to add to the list.", this.mLineNumber);
        } else {
            this.mActionList.add(this.mActionInProgress);
            this.mActionInProgress = null;
        }
    }

    boolean getProperty() {
        boolean retcode = false;
        if (this.mActionInProgress == null) {
            this.error("There is no in-progress action, get property flag failed.", this.mLineNumber);
        } else {
            retcode = this.mActionInProgress.isProperty();
        }
        return retcode;
    }

    void setProperty(boolean flag) {
        if (this.mActionInProgress == null) {
            this.error("There is no in-progress action, set property flag failed.", this.mLineNumber);
        } else {
            this.mActionInProgress.setProperty(flag);
        }
    }

    void clearActions() {
        if (this.mActionList != null) {
            this.mActionList.clear();
            this.mActionList = null;
        }
    }

    void createArgList() {
        if (this.mArgList != null) {
            this.error("Cannot create an argument list when one already exists.", this.mLineNumber);
        } else {
            this.mArgList = new ArrayList<String>();
        }
    }

    List<String> getArgsList() {
        List<String> retval = this.mArgList;
        this.mArgList = null;
        return retval;
    }

    void createArgument(String name, int lineNumber) {
        if (this.mArgInProgress != null) {
            this.error("Cannot create new argument while still filling in previous one.", lineNumber);
        } else {
            if (this.mParserFSM.getDebugFlag()) {
                PrintStream os = this.mParserFSM.getDebugStream();
                os.println("   CREATE ARG: " + name + "(" + Integer.toString(lineNumber) + ")");
            }
            this.mArgInProgress = name;
        }
    }

    void addArgument() {
        if (this.mArgList == null) {
            this.error("There is no argument list to which the argument may be added.", this.mLineNumber);
        } else if (this.mArgInProgress == null) {
            this.error("There is no in-progress argument to add to the list.", this.mLineNumber);
        } else {
            this.mArgList.add(this.mArgInProgress.trim());
            this.mArgInProgress = null;
        }
    }

    void clearArguments() {
        if (this.mArgList != null) {
            this.mArgList.clear();
            this.mArgList = null;
        }
    }

    private int getTransitionId(TransitionKey transKey) {
        Integer retval = this.mTransitions.get(transKey);
        if (retval == null) {
            retval = this.mNextTransitionId;
            ++this.mNextTransitionId;
            this.mTransitions.put(transKey, retval);
        }
        return retval;
    }

    static {
        String transName = "<not set>";
        OPEN_CLAUSE_LIST = new ArrayList<Character>();
        CLOSE_CLAUSE_LIST = new ArrayList<Character>();
        QUOTE_LIST = new ArrayList<Character>();
        OPEN_CLAUSE_LIST.add(new Character('('));
        OPEN_CLAUSE_LIST.add(new Character('{'));
        OPEN_CLAUSE_LIST.add(new Character('['));
        OPEN_CLAUSE_LIST.add(new Character('<'));
        CLOSE_CLAUSE_LIST.add(new Character(')'));
        CLOSE_CLAUSE_LIST.add(new Character('}'));
        CLOSE_CLAUSE_LIST.add(new Character(']'));
        CLOSE_CLAUSE_LIST.add(new Character('>'));
        QUOTE_LIST.add(new Character('\"'));
        QUOTE_LIST.add(new Character('\''));
        sTransMethod = new Method[33];
        try {
            Class<SmcParserContext> fsmClass = SmcParserContext.class;
            Class[] paramTypes = new Class[]{SmcLexer.Token.class};
            transName = "ENTRY";
            SmcParser.sTransMethod[3] = fsmClass.getDeclaredMethod("ENTRY", paramTypes);
            transName = "EXIT";
            SmcParser.sTransMethod[4] = fsmClass.getDeclaredMethod("EXIT", paramTypes);
            transName = "JUMP";
            SmcParser.sTransMethod[30] = fsmClass.getDeclaredMethod("JUMP", paramTypes);
            transName = "POP";
            SmcParser.sTransMethod[5] = fsmClass.getDeclaredMethod("POP", paramTypes);
            transName = "PUSH";
            SmcParser.sTransMethod[6] = fsmClass.getDeclaredMethod("PUSH", paramTypes);
            transName = "WORD";
            SmcParser.sTransMethod[7] = fsmClass.getDeclaredMethod("WORD", paramTypes);
            transName = "START_STATE";
            SmcParser.sTransMethod[8] = fsmClass.getDeclaredMethod("START_STATE", paramTypes);
            transName = "MAP_NAME";
            SmcParser.sTransMethod[9] = fsmClass.getDeclaredMethod("MAP_NAME", paramTypes);
            transName = "CLASS_NAME";
            SmcParser.sTransMethod[10] = fsmClass.getDeclaredMethod("CLASS_NAME", paramTypes);
            transName = "HEADER_FILE";
            SmcParser.sTransMethod[11] = fsmClass.getDeclaredMethod("HEADER_FILE", paramTypes);
            transName = "INCLUDE_FILE";
            SmcParser.sTransMethod[12] = fsmClass.getDeclaredMethod("INCLUDE_FILE", paramTypes);
            transName = "PACKAGE_NAME";
            SmcParser.sTransMethod[13] = fsmClass.getDeclaredMethod("PACKAGE_NAME", paramTypes);
            transName = "FSM_CLASS_NAME";
            SmcParser.sTransMethod[31] = fsmClass.getDeclaredMethod("FSM_CLASS_NAME", paramTypes);
            transName = "FSM_FILE_NAME";
            SmcParser.sTransMethod[32] = fsmClass.getDeclaredMethod("FSM_FILE_NAME", paramTypes);
            transName = "IMPORT";
            SmcParser.sTransMethod[14] = fsmClass.getDeclaredMethod("IMPORT", paramTypes);
            transName = "DECLARE";
            SmcParser.sTransMethod[15] = fsmClass.getDeclaredMethod("DECLARE", paramTypes);
            transName = "LEFT_BRACE";
            SmcParser.sTransMethod[16] = fsmClass.getDeclaredMethod("LEFT_BRACE", paramTypes);
            transName = "RIGHT_BRACE";
            SmcParser.sTransMethod[17] = fsmClass.getDeclaredMethod("RIGHT_BRACE", paramTypes);
            transName = "LEFT_BRACKET";
            SmcParser.sTransMethod[18] = fsmClass.getDeclaredMethod("LEFT_BRACKET", paramTypes);
            transName = "LEFT_PAREN";
            SmcParser.sTransMethod[19] = fsmClass.getDeclaredMethod("LEFT_PAREN", paramTypes);
            transName = "RIGHT_PAREN";
            SmcParser.sTransMethod[20] = fsmClass.getDeclaredMethod("RIGHT_PAREN", paramTypes);
            transName = "COMMA";
            SmcParser.sTransMethod[21] = fsmClass.getDeclaredMethod("COMMA", paramTypes);
            transName = "COLON";
            SmcParser.sTransMethod[22] = fsmClass.getDeclaredMethod("COLON", paramTypes);
            transName = "SEMICOLON";
            SmcParser.sTransMethod[23] = fsmClass.getDeclaredMethod("SEMICOLON", paramTypes);
            transName = "SOURCE";
            SmcParser.sTransMethod[24] = fsmClass.getDeclaredMethod("SOURCE", paramTypes);
            transName = "EOD";
            SmcParser.sTransMethod[25] = fsmClass.getDeclaredMethod("EOD", paramTypes);
            transName = "SLASH";
            SmcParser.sTransMethod[26] = fsmClass.getDeclaredMethod("SLASH", paramTypes);
            transName = "EQUAL";
            SmcParser.sTransMethod[27] = fsmClass.getDeclaredMethod("EQUAL", paramTypes);
            transName = "ACCESS";
            SmcParser.sTransMethod[28] = fsmClass.getDeclaredMethod("ACCESS", paramTypes);
            transName = "DOLLAR";
            SmcParser.sTransMethod[29] = fsmClass.getDeclaredMethod("DOLLAR", paramTypes);
        }
        catch (NoSuchMethodException ex1) {
            System.err.println("INITIALIZATION ERROR! No such method as SmcParserContext." + transName + ".");
            System.exit(2);
        }
        catch (SecurityException ex2) {
            System.err.println("INITIALIZATION ERROR! Not allowed to access SmcParserContext." + transName + ".");
            System.exit(2);
        }
    }

    private static final class TransitionKey
    implements Comparable<TransitionKey> {
        private final String mName;
        private final List<SmcParameter> mParameters;

        private TransitionKey(String name, List<SmcParameter> params) {
            this.mName = name;
            this.mParameters = params;
        }

        @Override
        public int compareTo(TransitionKey key) {
            int retval = this.mName.compareTo(key.mName);
            if (retval == 0) {
                retval = SmcTransition.compareParams(this.mParameters, key.mParameters);
            }
            return retval;
        }

        public boolean equals(Object obj) {
            boolean retcode;
            boolean bl = retcode = this == obj;
            if (!retcode && obj instanceof TransitionKey) {
                TransitionKey key = (TransitionKey)obj;
                retcode = this.mName.equals(key.mName) && SmcTransition.compareParams(this.mParameters, key.mParameters) == 0;
            }
            return retcode;
        }

        public int hashCode() {
            return this.mName.hashCode() ^ this.mParameters.hashCode();
        }

        public String toString() {
            StringBuffer retval = new StringBuffer(512);
            retval.append(this.mName);
            retval.append("(");
            Iterator<SmcParameter> pit = this.mParameters.iterator();
            String sep = "";
            while (pit.hasNext()) {
                retval.append(sep);
                retval.append(pit.next());
                sep = ", ";
            }
            retval.append(")");
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public List<SmcParameter> parameters() {
            return this.mParameters;
        }
    }
}

