/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

public final class SmcMessage {
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    private final String mName;
    private final int mLineNumber;
    private final int mLevel;
    private final String mText;

    public SmcMessage(String name, int lineNumber, int level, String text) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (text == null) {
            throw new NullPointerException("null text");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        if (lineNumber < 0) {
            throw new IllegalArgumentException("negative lineNumber");
        }
        if (level != 0 && level != 1) {
            throw new IllegalArgumentException("invalid level (" + Integer.toString(level) + ")");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("empty text");
        }
        this.mName = name;
        this.mLineNumber = lineNumber;
        this.mLevel = level;
        this.mText = text;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.mName).append(':').append(this.mLineNumber).append(':').append(this.mLevel == 0 ? " warning" : " error").append(" - ").append(this.mText);
        return retval.toString();
    }

    public String getName() {
        return this.mName;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public String getText() {
        return this.mText;
    }
}

