/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.smc.parser.SmcLexerContext;

final class SmcLexer {
    private static final int MAX_BUFFER_LEN = 4096;
    private static final int BUFFER_OFFSET = 2;
    private static final int READ_BUFFER_LEN = 4098;
    static final int COOKED = 1;
    static final int RAW = 2;
    static final int RAW2 = 3;
    static final int RAW3 = 4;
    static final int TOKEN_NOT_SET = 0;
    static final int DONE_FAILED = 1;
    static final int DONE_SUCCESS = 2;
    static final int ENTRY = 3;
    static final int EXIT = 4;
    static final int POP = 5;
    static final int PUSH = 6;
    static final int WORD = 7;
    static final int START_STATE = 8;
    static final int MAP_NAME = 9;
    static final int CLASS_NAME = 10;
    static final int HEADER_FILE = 11;
    static final int INCLUDE_FILE = 12;
    static final int PACKAGE_NAME = 13;
    static final int IMPORT = 14;
    static final int DECLARE = 15;
    static final int LEFT_BRACE = 16;
    static final int RIGHT_BRACE = 17;
    static final int LEFT_BRACKET = 18;
    static final int LEFT_PAREN = 19;
    static final int RIGHT_PAREN = 20;
    static final int COMMA = 21;
    static final int COLON = 22;
    static final int SEMICOLON = 23;
    static final int SOURCE = 24;
    static final int EOD = 25;
    static final int SLASH = 26;
    static final int EQUAL = 27;
    static final int ACCESS = 28;
    static final int DOLLAR = 29;
    static final int JUMP = 30;
    static final int FSM_CLASS_NAME = 31;
    static final int FSM_FILE_NAME = 32;
    static final int TOKEN_COUNT = 33;
    private static final int KEYWORD_COUNT = 4;
    private static final int PERCENT_KEYWORD_COUNT = 9;
    private static final int MIN_ASCII_CHAR = 0;
    private static final int MAX_ASCII_CHAR = 128;
    private static final int NEW_LINE = 10;
    private static final char ESCAPE = '\\';
    private static String[] sTypeName;
    private static Map<String, Integer> sKeywordMap;
    private static Map<String, Integer> sPercentKeywordMap;
    private static Method[] sTransMethod;
    private final SmcLexerContext mLexerFSM;
    private final InputStream mStream;
    private int mMode;
    private boolean mStopFlag;
    private char mCurrentChar;
    private final Token mToken;
    private final StringBuilder mTokenBuffer;
    private int mLineNumber;
    private final char[] mReadBuffer;
    private int mBufferSize;
    private int mReadIndex;
    private char mOpenChar;
    private char mCloseChar;
    private List<Character> mOpenList;
    private List<Character> mCloseList;
    private List<Character> mQuoteList;
    private char mEndChar;
    private char mSeparator;
    private String mCloseChars;

    SmcLexer(InputStream stream, boolean debugFlag) {
        this.mStream = stream;
        this.mToken = new Token();
        this.mTokenBuffer = new StringBuilder();
        this.mLineNumber = 1;
        this.mReadBuffer = new char[4098];
        this.mBufferSize = 0;
        this.mReadIndex = 0;
        this.mLexerFSM = new SmcLexerContext(this);
        this.mLexerFSM.setDebugFlag(debugFlag);
    }

    int getLineNumber() {
        return this.mLineNumber;
    }

    Token nextToken() throws IOException, IllegalAccessException, InvocationTargetException {
        Token retval;
        switch (this.mMode) {
            case 1: {
                retval = this.nextCookedToken();
                break;
            }
            case 2: {
                retval = this.nextRawToken();
                break;
            }
            case 3: {
                retval = this.nextParamTypeToken();
                break;
            }
            default: {
                retval = this.nextRaw3Token();
            }
        }
        return retval;
    }

    void setRawMode(char openChar, char closeChar) {
        this.mMode = 2;
        this.mOpenChar = openChar;
        this.mCloseChar = closeChar;
    }

    void setRawMode(List<Character> openList, List<Character> closeList, List<Character> quoteList, char endChar, char separator) {
        this.mMode = 3;
        this.mOpenList = new ArrayList<Character>(openList);
        this.mCloseList = new ArrayList<Character>(closeList);
        this.mQuoteList = new ArrayList<Character>(quoteList);
        this.mEndChar = endChar;
        this.mSeparator = separator;
    }

    void setRawMode(String closeChars) {
        this.mMode = 4;
        this.mCloseChars = closeChars;
    }

    void setCookedMode() {
        this.mMode = 1;
    }

    void startToken() {
        this.mToken.reset();
        this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
        this.mToken.setLineNumber(this.mLineNumber);
    }

    void addToToken() {
        this.mTokenBuffer.append(this.mCurrentChar);
    }

    void outputChar() {
        System.out.println();
        System.out.print("Unknown character: 0x");
        System.out.println(Integer.toHexString(this.mCurrentChar));
    }

    void addToToken(String s) {
        this.mTokenBuffer.append(s);
    }

    void endToken(int type) {
        this.mToken.setType(type);
        this.mToken.setValue(this.mTokenBuffer.toString());
        this.mStopFlag = true;
    }

    void badToken(String error_msg) {
        this.mToken.setType(1);
        this.mToken.setValue(error_msg + " (token: " + this.mTokenBuffer.toString() + ")");
        this.mStopFlag = true;
    }

    void checkKeyword() {
        String tokenStr = this.mTokenBuffer.toString();
        this.mToken.setValue(tokenStr);
        this.mStopFlag = true;
        if (sKeywordMap.containsKey(tokenStr)) {
            this.mToken.setType(sKeywordMap.get(tokenStr));
        } else if (tokenStr.length() > 0) {
            this.mToken.setType(7);
        } else {
            this.badToken("Zero-length word");
        }
    }

    void checkPercentKeyword() {
        String tokenStr = this.mTokenBuffer.toString();
        this.mToken.setValue(tokenStr);
        this.mStopFlag = true;
        if (sPercentKeywordMap.containsKey(tokenStr)) {
            this.mToken.setType(sPercentKeywordMap.get(tokenStr));
        } else {
            this.badToken("Unknown % directive");
        }
    }

    void ungetChar() {
        if (this.mReadIndex > 0) {
            --this.mReadIndex;
        }
    }

    Token nextCookedToken() {
        try {
            Object[] args = new Object[]{};
            this.mStopFlag = false;
            while (!this.mStopFlag) {
                this.mCurrentChar = this.readChar();
                if (this.mCurrentChar >= sTransMethod.length) {
                    this.mLexerFSM.unicode();
                    continue;
                }
                if (this.mCurrentChar == '\n') {
                    ++this.mLineNumber;
                }
                sTransMethod[this.mCurrentChar].invoke((Object)this.mLexerFSM, args);
            }
        }
        catch (EOFException e) {
            this.mToken.setType(2);
            this.mToken.setValue("");
        }
        catch (InvocationTargetException invokex) {
            this.badToken("Unknown token");
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException jex) {
            this.badToken(jex.getMessage() + " (token: " + this.mTokenBuffer.toString() + ")");
        }
        return this.mToken;
    }

    private Token nextRawToken() throws IOException {
        int startLine = this.mLineNumber;
        this.startToken();
        try {
            int depth = 0;
            this.mStopFlag = false;
            while (!this.mStopFlag) {
                this.mCurrentChar = this.readChar();
                if (this.mCurrentChar == this.mCloseChar && depth == 0) {
                    this.mStopFlag = true;
                    continue;
                }
                this.mTokenBuffer.append(this.mCurrentChar);
                if (this.mMode == 4) continue;
                if (this.mCurrentChar == this.mCloseChar) {
                    --depth;
                    continue;
                }
                if (this.mCurrentChar == this.mOpenChar) {
                    ++depth;
                    continue;
                }
                if (this.mCurrentChar != '\n') continue;
                ++this.mLineNumber;
            }
            this.mToken.setType(24);
            this.mToken.setValue(this.mTokenBuffer.toString());
            this.mToken.setLineNumber(startLine);
        }
        catch (EOFException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("User source code contains an unbalanced ");
            msg.append(this.mOpenChar);
            msg.append(", ");
            msg.append(this.mCloseChar);
            msg.append(" pair.");
            this.mToken.setType(1);
            this.mToken.setValue(msg.toString());
        }
        return this.mToken;
    }

    private Token nextRaw3Token() throws IOException {
        int startLine = this.mLineNumber;
        this.startToken();
        try {
            this.mStopFlag = false;
            while (!this.mStopFlag) {
                this.mCurrentChar = this.readChar();
                if (this.mCurrentChar == '\n') {
                    ++this.mLineNumber;
                }
                if (this.mCloseChars.indexOf(this.mCurrentChar) >= 0) {
                    this.mStopFlag = true;
                    continue;
                }
                this.mTokenBuffer.append(this.mCurrentChar);
            }
            this.mToken.setType(24);
            this.mToken.setValue(this.mTokenBuffer.toString());
            this.mToken.setLineNumber(startLine);
        }
        catch (EOFException e) {
            this.mToken.setType(24);
            this.mToken.setValue(this.mTokenBuffer.toString());
            this.mToken.setLineNumber(startLine);
        }
        return this.mToken;
    }

    private Token nextParamTypeToken() throws IOException {
        int startLine = this.mLineNumber;
        int tokenType = 24;
        this.startToken();
        try {
            LinkedList<Character> depth = new LinkedList<Character>();
            boolean quoteFlag = false;
            int quoteChar = 32;
            boolean escapeFlag = false;
            this.mStopFlag = false;
            while (!this.mStopFlag) {
                this.mCurrentChar = this.readChar();
                if ((this.mCurrentChar == this.mEndChar || this.mCurrentChar == this.mSeparator) && depth.isEmpty() && !quoteFlag) {
                    this.mStopFlag = true;
                    this.ungetChar();
                    continue;
                }
                this.mTokenBuffer.append(this.mCurrentChar);
                if (escapeFlag) {
                    escapeFlag = false;
                    continue;
                }
                if (this.mCurrentChar == '\\') {
                    escapeFlag = true;
                    continue;
                }
                if (this.mQuoteList.indexOf(Character.valueOf(this.mCurrentChar)) >= 0) {
                    if (!quoteFlag) {
                        quoteFlag = true;
                        quoteChar = this.mCurrentChar;
                        continue;
                    }
                    if (this.mCurrentChar != quoteChar) continue;
                    quoteFlag = false;
                    quoteChar = 32;
                    continue;
                }
                if (quoteFlag) continue;
                int closeIndex = this.mCloseList.indexOf(Character.valueOf(this.mCurrentChar));
                if (closeIndex >= 0) {
                    if (depth.isEmpty()) {
                        tokenType = 1;
                        this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
                        this.mTokenBuffer.append("'");
                        this.mTokenBuffer.append(this.mCurrentChar);
                        this.mTokenBuffer.append("' has no matching '");
                        this.mTokenBuffer.append(this.mOpenList.get(closeIndex));
                        this.mTokenBuffer.append("'.");
                        continue;
                    }
                    Character openChar = (Character)depth.removeFirst();
                    int openIndex = this.mOpenList.indexOf(openChar);
                    if (closeIndex == openIndex) continue;
                    tokenType = 1;
                    this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
                    this.mTokenBuffer.append("'");
                    this.mTokenBuffer.append(this.mCurrentChar);
                    this.mTokenBuffer.append("' does not match '");
                    this.mTokenBuffer.append(openChar);
                    this.mTokenBuffer.append("'.");
                    continue;
                }
                if (this.mOpenList.contains(Character.valueOf(this.mCurrentChar))) {
                    depth.addFirst(Character.valueOf(this.mCurrentChar));
                    continue;
                }
                if (this.mCurrentChar != '\n') continue;
                ++this.mLineNumber;
            }
        }
        catch (EOFException e) {
            tokenType = 1;
            this.mTokenBuffer.delete(0, this.mTokenBuffer.length());
            this.mTokenBuffer.append("User source code contains ");
            this.mTokenBuffer.append("an unbalanced open, closing ");
            this.mTokenBuffer.append(" pair.");
        }
        this.mToken.setType(tokenType);
        this.mToken.setValue(this.mTokenBuffer.toString());
        this.mToken.setLineNumber(startLine);
        return this.mToken;
    }

    private char readChar() throws IOException, EOFException {
        if (this.mReadIndex == this.mBufferSize) {
            int size;
            int offset = 0;
            int c = 0;
            if (this.mBufferSize > 2) {
                offset = 2;
                this.mReadBuffer[0] = this.mReadBuffer[this.mBufferSize - 2];
                this.mReadBuffer[1] = this.mReadBuffer[this.mBufferSize - 1];
            } else if (this.mBufferSize > 1) {
                offset = 1;
                this.mReadBuffer[0] = this.mReadBuffer[this.mBufferSize - 1];
            }
            int index = offset;
            for (size = 0; size < 4096 && (c = this.mStream.read()) >= 0; ++size) {
                this.mReadBuffer[index] = (char)c;
                ++index;
            }
            if (size == 0 && c < 0) {
                this.mBufferSize = 0;
                throw new EOFException("end-of-file reached");
            }
            this.mBufferSize = size + offset;
            this.mReadIndex = offset;
        }
        char retval = this.mReadBuffer[this.mReadIndex];
        ++this.mReadIndex;
        return retval;
    }

    static {
        String transName = "<not set>";
        sTypeName = new String[33];
        SmcLexer.sTypeName[0] = "TOKEN_NOT_SET";
        SmcLexer.sTypeName[1] = "DONE_FAILED";
        SmcLexer.sTypeName[2] = "DONE_SUCCESS";
        SmcLexer.sTypeName[3] = "ENTRY";
        SmcLexer.sTypeName[4] = "EXIT";
        SmcLexer.sTypeName[5] = "POP";
        SmcLexer.sTypeName[6] = "PUSH";
        SmcLexer.sTypeName[7] = "WORD";
        SmcLexer.sTypeName[8] = "START_STATE";
        SmcLexer.sTypeName[9] = "MAP_NAME";
        SmcLexer.sTypeName[10] = "CLASS_NAME";
        SmcLexer.sTypeName[11] = "HEADER_FILE";
        SmcLexer.sTypeName[12] = "INCLUDE_FILE";
        SmcLexer.sTypeName[13] = "PACKAGE_NAME";
        SmcLexer.sTypeName[31] = "FSM_CLASS_NAME";
        SmcLexer.sTypeName[32] = "FSM_FILE_NAME";
        SmcLexer.sTypeName[14] = "IMPORT";
        SmcLexer.sTypeName[15] = "DECLARE";
        SmcLexer.sTypeName[16] = "LEFT_BRACE";
        SmcLexer.sTypeName[17] = "RIGHT_BRACE";
        SmcLexer.sTypeName[18] = "LEFT_BRACKET";
        SmcLexer.sTypeName[19] = "LEFT_PAREN";
        SmcLexer.sTypeName[20] = "RIGHT_PAREN";
        SmcLexer.sTypeName[21] = "COMMA";
        SmcLexer.sTypeName[22] = "COLON";
        SmcLexer.sTypeName[22] = "SEMICOLON";
        SmcLexer.sTypeName[24] = "SOURCE";
        SmcLexer.sTypeName[25] = "EOD";
        SmcLexer.sTypeName[26] = "SLASH";
        SmcLexer.sTypeName[27] = "EQUAL";
        SmcLexer.sTypeName[28] = "ACCESS";
        SmcLexer.sTypeName[29] = "DOLLAR";
        SmcLexer.sTypeName[30] = "JUMP";
        sKeywordMap = new HashMap<String, Integer>(4);
        sKeywordMap.put("Entry", 3);
        sKeywordMap.put("Exit", 4);
        sKeywordMap.put("jump", 30);
        sKeywordMap.put("pop", 5);
        sKeywordMap.put("push", 6);
        sPercentKeywordMap = new HashMap<String, Integer>(9);
        sPercentKeywordMap.put("%start", 8);
        sPercentKeywordMap.put("%map", 9);
        sPercentKeywordMap.put("%class", 10);
        sPercentKeywordMap.put("%header", 11);
        sPercentKeywordMap.put("%include", 12);
        sPercentKeywordMap.put("%package", 13);
        sPercentKeywordMap.put("%fsmclass", 31);
        sPercentKeywordMap.put("%fsmfile", 32);
        sPercentKeywordMap.put("%import", 14);
        sPercentKeywordMap.put("%declare", 15);
        sPercentKeywordMap.put("%access", 28);
        sTransMethod = new Method[128];
        try {
            int i;
            Class<SmcLexerContext> fsmClass = SmcLexerContext.class;
            Class[] paramTypes = new Class[]{};
            transName = "unicode";
            Method unicode = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "whitespace";
            Method whitespace = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "alpha";
            Method alpha = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "digit";
            Method digit = fsmClass.getDeclaredMethod(transName, paramTypes);
            for (i = 0; i < 128; ++i) {
                SmcLexer.sTransMethod[i] = unicode;
            }
            SmcLexer.sTransMethod[9] = whitespace;
            SmcLexer.sTransMethod[11] = whitespace;
            SmcLexer.sTransMethod[12] = whitespace;
            SmcLexer.sTransMethod[28] = whitespace;
            SmcLexer.sTransMethod[29] = whitespace;
            SmcLexer.sTransMethod[30] = whitespace;
            SmcLexer.sTransMethod[31] = whitespace;
            SmcLexer.sTransMethod[32] = whitespace;
            SmcLexer.sTransMethod[10] = fsmClass.getDeclaredMethod("EOL", paramTypes);
            SmcLexer.sTransMethod[13] = sTransMethod[10];
            for (i = 97; i <= 122; ++i) {
                SmcLexer.sTransMethod[i] = alpha;
            }
            for (i = 65; i <= 90; ++i) {
                SmcLexer.sTransMethod[i] = alpha;
            }
            for (i = 48; i <= 57; ++i) {
                SmcLexer.sTransMethod[i] = digit;
            }
            transName = "percent";
            SmcLexer.sTransMethod[37] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_paren";
            SmcLexer.sTransMethod[40] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_paren";
            SmcLexer.sTransMethod[41] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "asterisk";
            SmcLexer.sTransMethod[42] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "comma";
            SmcLexer.sTransMethod[44] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "period";
            SmcLexer.sTransMethod[46] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "slash";
            SmcLexer.sTransMethod[47] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "colon";
            SmcLexer.sTransMethod[58] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "semicolon";
            SmcLexer.sTransMethod[59] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_bracket";
            SmcLexer.sTransMethod[91] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "underscore";
            SmcLexer.sTransMethod[95] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "left_brace";
            SmcLexer.sTransMethod[123] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "right_brace";
            SmcLexer.sTransMethod[125] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "equal";
            SmcLexer.sTransMethod[61] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "lt";
            SmcLexer.sTransMethod[60] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "gt";
            SmcLexer.sTransMethod[62] = fsmClass.getDeclaredMethod(transName, paramTypes);
            transName = "dollar";
            SmcLexer.sTransMethod[36] = fsmClass.getDeclaredMethod(transName, paramTypes);
        }
        catch (NoSuchMethodException ex1) {
            System.err.println("INITIALIZATION ERROR! No such method as SmcLexerContext." + transName + ".");
            System.exit(1);
        }
        catch (SecurityException ex2) {
            System.err.println("INITIALIZATION ERROR! Not allowed to access SmcLexerContext." + transName + ".");
            System.exit(1);
        }
    }

    final class Token {
        private int mType = 0;
        private String mValue = null;
        private int mLineNumber = -1;

        Token() {
        }

        public String toString() {
            return "{" + sTypeName[this.mType] + ", " + this.mValue + "}";
        }

        int getType() {
            return this.mType;
        }

        String getValue() {
            return this.mValue;
        }

        int getLineNumber() {
            return this.mLineNumber;
        }

        Token copy() {
            Token retval = new Token();
            retval.setType(this.mType);
            retval.setValue(this.mValue);
            retval.setLineNumber(this.mLineNumber);
            return retval;
        }

        void setType(int type) {
            this.mType = type;
        }

        void setLineNumber(int line_number) {
            this.mLineNumber = line_number;
        }

        void setValue(String value) {
            this.mValue = value;
        }

        private void reset() {
            this.mType = 0;
            this.mValue = null;
            this.mLineNumber = -1;
        }
    }
}

