/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcVisitor;

public final class SmcTransition
extends SmcElement
implements Comparable<SmcTransition> {
    private final SmcState mState;
    private final int mIdentifier;
    private final List<SmcParameter> mParameters;
    private final List<SmcGuard> mGuards;

    public SmcTransition(String name, List<SmcParameter> parameters, int transId, int lineNumber, SmcState state) {
        super(name, lineNumber);
        this.mState = state;
        this.mParameters = parameters;
        this.mIdentifier = transId;
        this.mGuards = new ArrayList<SmcGuard>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int compareTo(SmcTransition trans) {
        int retval = this.mName.compareTo(trans.mName);
        if (retval == 0) {
            retval = this.compareParams(trans.getParameters());
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean retcode;
        boolean bl = retcode = this == obj;
        if (!retcode && obj instanceof SmcTransition) {
            SmcTransition trans = (SmcTransition)obj;
            retcode = this.mName.equals(trans.mName) && this.compareParams(trans.mParameters) == 0;
        }
        return retcode;
    }

    public int hashCode() {
        return this.mIdentifier;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder(512);
        retval.append(this.mName);
        retval.append("(");
        Iterator<SmcParameter> pit = this.mParameters.iterator();
        String sep = "";
        while (pit.hasNext()) {
            retval.append(sep);
            retval.append(pit.next());
            sep = ", ";
        }
        retval.append(")");
        if (!this.mGuards.isEmpty()) {
            for (SmcGuard guard : this.mGuards) {
                retval.append('\n').append(guard);
            }
        }
        return retval.toString();
    }

    public int getIdentifier() {
        return this.mIdentifier;
    }

    public SmcState getState() {
        return this.mState;
    }

    public List<SmcParameter> getParameters() {
        return this.mParameters;
    }

    public List<SmcGuard> getGuards() {
        return this.mGuards;
    }

    public boolean hasCtxtReference() {
        Iterator<SmcGuard> guardIt = this.mGuards.iterator();
        boolean retcode = false;
        while (guardIt.hasNext() && !retcode) {
            retcode = guardIt.next().hasCtxtReference();
        }
        return retcode;
    }

    public boolean hasNonNilEndState() {
        Iterator<SmcGuard> guardIt = this.mGuards.iterator();
        boolean retcode = false;
        while (guardIt.hasNext() && !retcode) {
            SmcGuard guard = guardIt.next();
            retcode = !guard.getEndState().equals("nil");
        }
        return retcode;
    }

    public void addGuard(SmcGuard guard) {
        this.mGuards.add(guard);
    }

    public int compareTo(String name, List<SmcParameter> parameters) {
        int retval = this.mName.compareTo(name);
        if (retval == 0) {
            retval = this.compareParams(parameters);
        }
        return retval;
    }

    public static int compareParams(List<SmcParameter> p1, List<SmcParameter> p2) {
        int retval = p1.size() - p2.size();
        if (retval == 0) {
            Iterator<SmcParameter> pit1 = p1.iterator();
            Iterator<SmcParameter> pit2 = p2.iterator();
            while (pit1.hasNext() && pit2.hasNext() && retval == 0) {
                SmcParameter param1 = pit1.next();
                SmcParameter param2 = pit2.next();
                retval = param1.compareTo(param2);
            }
        }
        return retval;
    }

    private int compareParams(List<SmcParameter> params) {
        return SmcTransition.compareParams(this.mParameters, params);
    }
}

