/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcMap
extends SmcElement {
    private static int sStateId = 0;
    private final SmcFSM mFsm;
    private final List<SmcState> mStates;
    private SmcState mDefaultState;

    public SmcMap(String name, int lineNumber, SmcFSM fsm) {
        super(name, lineNumber);
        this.mFsm = fsm;
        this.mDefaultState = null;
        this.mStates = new ArrayList<SmcState>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        String retval = "%map " + this.mName;
        if (this.mDefaultState != null) {
            retval = retval + "\n" + this.mDefaultState;
        }
        for (SmcState state : this.mStates) {
            retval = retval + "\n" + state;
        }
        return retval;
    }

    public SmcFSM getFSM() {
        return this.mFsm;
    }

    public List<SmcState> getStates() {
        return this.mStates;
    }

    public boolean findState(SmcState state) {
        Iterator<SmcState> it = this.mStates.iterator();
        boolean retval = false;
        while (it.hasNext() && !retval) {
            SmcState state2 = it.next();
            retval = state.getInstanceName().equals(state2.getInstanceName());
        }
        return retval;
    }

    public boolean isKnownState(String stateName) {
        boolean retval;
        if (stateName.compareToIgnoreCase("default") == 0) {
            retval = this.hasDefaultState();
        } else {
            Iterator<SmcState> it = this.mStates.iterator();
            retval = false;
            while (it.hasNext() && !retval) {
                SmcState state = it.next();
                retval = stateName.equals(state.getInstanceName());
            }
        }
        return retval;
    }

    public boolean hasDefaultState() {
        return this.mDefaultState != null;
    }

    public SmcState getDefaultState() {
        return this.mDefaultState;
    }

    public List<SmcState> getAllStates() {
        ArrayList<SmcState> retval = new ArrayList<SmcState>(this.mStates);
        if (this.mDefaultState != null) {
            retval.add(this.mDefaultState);
        }
        return retval;
    }

    public List<SmcTransition> getTransitions() {
        List<Object> retval = this.mDefaultState != null ? new ArrayList<SmcTransition>(this.mDefaultState.getTransitions()) : new ArrayList();
        for (SmcState state : this.mStates) {
            List<SmcTransition> transList = state.getTransitions();
            retval = SmcMap.merge(transList, retval, new Comparator<SmcTransition>(){

                @Override
                public int compare(SmcTransition o1, SmcTransition o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        return retval;
    }

    public List<SmcTransition> getUndefinedDefaultTransitions() {
        List<Object> definedDefaultTransitions;
        ArrayList<SmcTransition> retval = new ArrayList<SmcTransition>();
        if (this.mDefaultState == null) {
            definedDefaultTransitions = new ArrayList();
        } else {
            definedDefaultTransitions = this.mDefaultState.getTransitions();
            Collections.sort(definedDefaultTransitions, new Comparator<SmcTransition>(){

                @Override
                public int compare(SmcTransition o1, SmcTransition o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        for (SmcState state : this.mStates) {
            for (SmcTransition transition : state.getTransitions()) {
                if (!transition.getName().equals("Default") || definedDefaultTransitions.contains(transition) || retval.contains(transition)) continue;
                retval.add(transition);
            }
        }
        return retval;
    }

    public boolean hasEntryActions() {
        for (SmcState state : this.mStates) {
            List<SmcAction> actions = state.getEntryActions();
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExitActions() {
        for (SmcState state : this.mStates) {
            List<SmcAction> actions = state.getExitActions();
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static int getNextStateId() {
        int retval = sStateId++;
        return retval;
    }

    public void addState(SmcState state) {
        if (state.isDefaultState()) {
            this.mDefaultState = state;
        } else {
            this.mStates.add(state);
        }
    }
}

