/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.SmcVisitor;

public final class SmcFSM
extends SmcElement {
    private String mStartState = "";
    private String mSource = "";
    private String mContext = "";
    private final String mSourceFileName;
    private String mTargetFileName;
    private String mFsmClassName;
    private String mHeader;
    private final List<String> mIncludeList;
    private String mPackage;
    private final List<String> mImportList;
    private final List<String> mDeclareList;
    private String mAccessLevel;
    private int mHeaderLine;
    private final List<SmcMap> mMaps;

    public SmcFSM(String name, String targetFile) {
        super(name, 1);
        this.mSourceFileName = name;
        this.mTargetFileName = targetFile;
        this.mFsmClassName = name + "Context";
        this.mHeader = "";
        this.mIncludeList = new ArrayList<String>();
        this.mPackage = null;
        this.mImportList = new ArrayList<String>();
        this.mDeclareList = new ArrayList<String>();
        this.mAccessLevel = "";
        this.mHeaderLine = -1;
        this.mMaps = new ArrayList<SmcMap>();
    }

    @Override
    public void accept(SmcVisitor visitor) {
        visitor.visit(this);
    }

    public String getSource() {
        return this.mSource;
    }

    public int getHeaderLine() {
        return this.mHeaderLine;
    }

    public String getStartState() {
        return this.mStartState;
    }

    public String getContext() {
        return this.mContext;
    }

    public String getSourceFileName() {
        return this.mSourceFileName;
    }

    public String getTargetFileName() {
        return this.mTargetFileName;
    }

    public String getFsmClassName() {
        return this.mFsmClassName;
    }

    public String getHeader() {
        return this.mHeader;
    }

    public List<String> getIncludes() {
        return this.mIncludeList;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public List<String> getImports() {
        return this.mImportList;
    }

    public int getImportCount() {
        return this.mImportList.size();
    }

    public int getDeclareCount() {
        return this.mDeclareList.size();
    }

    public List<String> getDeclarations() {
        return this.mDeclareList;
    }

    public String getAccessLevel() {
        return this.mAccessLevel;
    }

    public SmcMap findMap(String name) {
        Iterator<SmcMap> mapIt = this.mMaps.iterator();
        SmcMap retval = null;
        while (mapIt.hasNext() && retval == null) {
            SmcMap map = mapIt.next();
            if (map.getName().compareTo(name) != 0) continue;
            retval = map;
        }
        return retval;
    }

    public List<SmcMap> getMaps() {
        return this.mMaps;
    }

    public List<SmcTransition> getTransitions() {
        Comparator<SmcTransition> comparator = new Comparator<SmcTransition>(){

            @Override
            public int compare(SmcTransition o1, SmcTransition o2) {
                return o1.compareTo(o2);
            }
        };
        List<SmcTransition> retval = new ArrayList<SmcTransition>();
        for (SmcMap map : this.mMaps) {
            retval = SmcFSM.merge(map.getTransitions(), retval, comparator);
        }
        return retval;
    }

    public boolean hasEntryActions() {
        for (SmcMap map : this.mMaps) {
            if (!map.hasEntryActions()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExitActions() {
        for (SmcMap map : this.mMaps) {
            if (!map.hasExitActions()) continue;
            return true;
        }
        return false;
    }

    public void setSource(String source) {
        this.mSource = source;
    }

    public void setHeaderLine(int lineNumber) {
        if (this.mHeaderLine < 0) {
            this.mHeaderLine = lineNumber;
        }
    }

    public void setStartState(String state) {
        this.mStartState = state;
    }

    public void setContext(String context) {
        this.mContext = context;
    }

    public void setFsmClassName(String fsmName) {
        this.mFsmClassName = fsmName;
    }

    public void setFsmTargetFile(String fileName) {
        this.mTargetFileName = fileName;
    }

    public void setHeader(String header) {
        char c = header.charAt(0);
        this.mHeader = c != '\"' && c != '<' ? "\"" + header.trim() + "\"" : header.trim();
        this.mIncludeList.add(this.mHeader);
    }

    public void addInclude(String includeFile) {
        char c = includeFile.charAt(0);
        String filename = c != '\"' && c != '<' ? "\"" + includeFile.trim() + "\"" : includeFile.trim();
        this.mIncludeList.add(filename);
    }

    public void setPackage(String pkg) {
        this.mPackage = pkg;
    }

    public void addImport(String name) {
        this.mImportList.add(name);
    }

    public void addDeclare(String name) {
        this.mDeclareList.add(name);
    }

    public void setAccessLevel(String accessLevel) {
        this.mAccessLevel = accessLevel;
    }

    public void addMap(SmcMap map) {
        this.mMaps.add(map);
    }

    public void dump(PrintStream stream) {
        stream.print("Start State: ");
        stream.println(this.mStartState);
        stream.print("     Source:");
        if (this.mSource.isEmpty()) {
            stream.println(" none.");
        } else {
            stream.println();
            stream.println(this.mSource);
        }
        stream.print("    Context: ");
        stream.println(this.mContext);
        for (String include : this.mIncludeList) {
            stream.print("     Include: ");
            stream.println(include);
        }
        stream.println("       Maps:");
        stream.println();
        for (SmcMap map : this.mMaps) {
            stream.println(map);
        }
    }
}

