/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcVBGenerator
extends SmcCodeGenerator {
    public SmcVBGenerator(SmcOptions options) {
        super(options, TargetLanguage.VB.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        int index;
        String separator;
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        if (this.mReflectFlag) {
            if (!this.mGenericFlag) {
                this.mTarget.println("Imports System.Collections");
            } else {
                this.mTarget.println("Imports System.Collections.Generic");
            }
        }
        for (String string : fsm.getImports()) {
            this.mTarget.print("Imports ");
            this.mTarget.println(string);
        }
        if (this.mSerialFlag) {
            this.mTarget.println("Imports System.Runtime.Serialization");
        }
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.print("Namespace ");
            this.mTarget.println(packageName);
            this.mTarget.println();
            this.mIndent = "    ";
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("<Serializable()> ");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("Public NotInheritable Class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    Inherits statemap.FSMContext");
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    Implements ISerializable");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Member data");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.print(this.mIndent);
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' The associated application class instance.");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Private _owner As ");
        this.mTarget.println(context);
        this.mTarget.println();
        if (this.mSerialFlag || this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Shared data");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ' State instance array. ");
            this.mTarget.println("Used to deserialize.");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Private Shared ReadOnly _States() As ");
            this.mTarget.print(context);
            this.mTarget.println("State = _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        {");
            separator = " _";
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.println(separator);
                    this.mTarget.print(this.mIndent);
                    this.mTarget.print("            ");
                    this.mTarget.print(mapName);
                    this.mTarget.print('.');
                    this.mTarget.print(state.getClassName());
                    separator = ", _";
                }
            }
            this.mTarget.println(" _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Properties");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Property State() As ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        Get");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            If state_ Is Nothing _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            Then");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("                Throw ");
        this.mTarget.println("New statemap.StateUndefinedException()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            End If");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            Return state_");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        End Get");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        Set(ByVal state As ");
        this.mTarget.print(context);
        this.mTarget.println("State)");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            state_ = state");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        End Set");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Property");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Property Owner() As ");
        this.mTarget.println(context);
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        Get");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            Return _owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        End Get");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        Set(ByVal owner As ");
        this.mTarget.print(context);
        this.mTarget.println(")");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            If owner Is Nothing _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            Then");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("                Throw New NullReferenceException");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            End If");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            _owner = owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        End Set");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Property");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public ReadOnly Property States() As ");
            this.mTarget.print(context);
            this.mTarget.println("State()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Return _States");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End Get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Property");
            this.mTarget.println();
        }
        String vbState = (index = startState.indexOf("::")) >= 0 ? startState.substring(0, index) + "." + startState.substring(index + 2) : startState;
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Member methods");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Sub New(ByRef owner As ");
        this.mTarget.print(context);
        this.mTarget.println(")");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        MyBase.New(");
        this.mTarget.print(vbState);
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        _owner = owner");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    Public Overrides Sub EnterStartState()");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        State.Entry(Me)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition smcTransition : transitions) {
            String indent2;
            if (smcTransition.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Sub ");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(");
            List<SmcParameter> params = smcTransition.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(")");
            this.mTarget.println();
            if (this.mSyncFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        SyncLock Me");
                indent2 = this.mIndent + "            ";
            } else {
                indent2 = this.mIndent + "        ";
            }
            this.mTarget.print(indent2);
            this.mTarget.print("transition_ = \"");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.println("\"");
            this.mTarget.print(indent2);
            this.mTarget.print("State.");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(Me");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(")");
            this.mTarget.print(indent2);
            this.mTarget.println("transition_ = \"\"");
            if (this.mSyncFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        End SyncLock");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
            this.mTarget.println();
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Function ValueOf(");
            this.mTarget.print("ByVal stateId As Integer) As ");
            this.mTarget.print(context);
            this.mTarget.println("State");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Return _States(stateId)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Function");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Private Sub GetObjectData(");
            this.mTarget.println("ByVal info As SerializationInfo, _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                              ");
            this.mTarget.println("ByVal context As StreamingContext) _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.println("Implements ISerializable.GetObjectData");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Dim stackSize As Integer = 0");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Dim index As Integer");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Dim it As IEnumerator");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        If Not IsNothing(stateStack_) _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Then");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            stackSize = stateStack_.Count");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            it = stateStack_.GetEnumerator()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End If");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.println("info.AddValue(\"stackSize\", stackSize)");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        index = 0");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        While index < stackSize");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            it.MoveNext()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            info.AddValue( _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                ");
            this.mTarget.println("String.Concat(\"stackItem\", index), _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                              it.Current.Id)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            index += 1");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End While");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        info.AddValue(\"state\", state_.Id)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Private Sub New(");
            this.mTarget.println("ByVal info As SerializationInfo, _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                    ");
            this.mTarget.println("ByVal context As StreamingContext)");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        MyBase.New(Nothing)");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Dim stackSize As Integer");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Dim stateId As Integer");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        stackSize = ");
            this.mTarget.println("info.GetInt32(\"stackSize\")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        If stackSize > 0 _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Then");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Dim index As Integer");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            stateStack_ = New Stack()");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            index = stackSize - 1");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            While index >= 0");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                stateId = _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                    info.GetInt32( _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                        ");
            this.mTarget.println("String.Concat(\"stackItem\", index))");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("                    ");
            this.mTarget.println("stateStack_.Push(_States(stateId))");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("                    index -= 1");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            End While");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End If");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        stateId = info.GetInt32(\"state\")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        state_ = _States(stateId)");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("End Class");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("Public MustInherit Class ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    Inherits statemap.State");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Properties");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public MustOverride ReadOnly ");
            this.mTarget.print("Property Transitions() As IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("(Of String, Integer)");
            }
            this.mTarget.println();
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Member methods");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Protected Sub New(");
        this.mTarget.println("ByVal name As String, ByVal id As Integer)");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        MyBase.New(name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Overridable Sub Entry(");
        this.mTarget.print("ByRef context As ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Overridable Sub Exit_(");
        this.mTarget.print("ByRef context As ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        for (SmcTransition smcTransition : transitions) {
            if (smcTransition.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Overridable Sub ");
            this.mTarget.print(smcTransition.getName());
            this.mTarget.print("(ByRef context As ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("");
            for (SmcParameter param : smcTransition.getParameters()) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Default_(context)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Overridable Sub Default_(");
        this.mTarget.print("ByRef context As ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(")");
        this.mTarget.println();
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("#If TRACE Then");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        Trace.WriteLine(");
            this.mTarget.println("\"TRANSITION   : Default\")");
            this.mTarget.println("#End If");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        Throw ");
        this.mTarget.println("New statemap.TransitionUndefinedException( _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("            String.Concat(\"State: \", _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("               context.State.Name, _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("               \", Transition: \", _");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("               context.GetTransition()))");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("End Class");
        for (SmcMap smcMap : maps) {
            smcMap.accept(this);
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.println();
            this.mTarget.println("End Namespace");
        }
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("Public MustInherit Class ");
        this.mTarget.println(mapName);
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Shared data");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        for (SmcState state : states) {
            String stateName = state.getClassName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Shared ");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" As ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(stateName);
            this.mTarget.println(" = _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        New ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(stateName);
            this.mTarget.print("(\"");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(stateName);
            this.mTarget.print("\", ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(")");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Private Shared Default_ As ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default = _");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        New ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default(\"");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default\", -1)");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("End Class");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("Public Class ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Inherits ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Properties");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Overrides ReadOnly ");
            this.mTarget.print("Property Transitions() As IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("(of String, Integer)");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Get");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Return _transitions");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End Get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Property");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Member methods");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Sub New(");
        this.mTarget.println("ByVal name As String, ByVal id As Integer)");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        MyBase.New(name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        this.mTarget.println();
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Shared data");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print("Private Shared _transitions As IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("(Of String, Integer)");
            }
            this.mTarget.println();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    Shared Sub New()");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print("_transitions = New ");
            if (!this.mGenericFlag) {
                this.mTarget.print("Hashtable");
            } else {
                this.mTarget.print("Dictionary(Of String, Integer)");
            }
            this.mTarget.println("()");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        ");
                this.mTarget.print("_transitions.Add(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(")");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("End Class");
        for (SmcState state : states) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("Public NotInheritable Class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.println(state.getClassName());
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Inherits ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Properties");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Overrides ReadOnly ");
            this.mTarget.print("Property Transitions() As IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("(Of String, Integer)");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Get");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            Return _transitions");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End Get");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Property");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '------------------------------------------------------------");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    ' Member methods");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    '");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Sub New(");
        this.mTarget.println("ByVal name As String, ByVal id As Integer)");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        MyBase.New(name, id)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Overrides Sub Entry(");
            this.mTarget.print("ByRef context As ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(")");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("       Dim ctxt As ");
            this.mTarget.print(context);
            this.mTarget.println(" = context.Owner");
            this.mTarget.println();
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    Public Overrides Sub Exit(");
            this.mTarget.print("ByRef context As ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(")");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        Dim ctxt As ");
            this.mTarget.print(context);
            this.mTarget.println(" = context.Owner");
            this.mTarget.println();
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '------------------------------------------------------------");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    ' Shared data");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    '");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print("Private Shared _transitions As IDictionary");
            if (this.mGenericFlag) {
                this.mTarget.print("(Of String, Integer)");
            }
            this.mTarget.println();
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    Shared Sub New()");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.print("_transitions = New ");
            if (!this.mGenericFlag) {
                this.mTarget.print("Hashtable");
            } else {
                this.mTarget.print("Dictionary(Of String, Integer)");
            }
            this.mTarget.println("()");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        ");
                this.mTarget.print("_transitions.Add(\"");
                this.mTarget.print(transName);
                this.mTarget.print("\", ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(")");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    End Sub");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("End Class");
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    Public Overrides Sub ");
        if (transName.equals("Default")) {
            this.mTarget.print("Default_");
        } else {
            this.mTarget.print(transName);
        }
        this.mTarget.print("(ByRef context As ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println(")");
        this.mTarget.println();
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        Dim ctxt As ");
            this.mTarget.print(context);
            this.mTarget.println(" = context.Owner");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("#If TRACE Then");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Trace.WriteLine( _");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            \"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print(".");
            this.mTarget.print(stateName);
            this.mTarget.println("\")");
            this.mTarget.println("#End If");
            this.mTarget.println();
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Else");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            MyBase.");
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End If");
        } else if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        End If");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    End Sub");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent2;
        String sep;
        Iterator<SmcElement> pit;
        List<SmcParameter> parameters;
        String fqEndStateName;
        String indent1;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            endStateName = this.scopeStateName(endStateName, mapName);
        }
        stateName = this.scopeStateName(stateName, mapName);
        pushStateName = this.scopeStateName(pushStateName, mapName);
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent1 = this.mIndent + "            ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        If ");
                this.mTarget.print(condition);
                this.mTarget.println(" _");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        Then");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        ElseIf ");
                this.mTarget.print(condition);
                this.mTarget.println(" _");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        Then");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        Else");
            }
        } else if (condition.length() == 0) {
            indent1 = this.mIndent + "        ";
        } else {
            indent1 = this.mIndent + "            ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        If ");
            this.mTarget.print(condition);
            this.mTarget.println(" _");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Then");
        }
        if (actions.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (loopbackFlag) {
            fqEndStateName = "endState";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("Dim ");
            this.mTarget.print(fqEndStateName);
            this.mTarget.print(" As ");
            this.mTarget.print(context);
            this.mTarget.println("State = context.State");
            this.mTarget.println();
        } else {
            fqEndStateName = endStateName;
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#If TRACE Then");
                this.mTarget.print(indent1);
                this.mTarget.println("Trace.WriteLine( _");
                this.mTarget.print(indent1);
                this.mTarget.print("    \"BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit_(context)\")");
                this.mTarget.println("#End If");
                this.mTarget.println();
            }
            this.mTarget.print(indent1);
            this.mTarget.println("context.State.Exit_(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#If TRACE Then");
                this.mTarget.print(indent1);
                this.mTarget.println("Trace.WriteLine( _");
                this.mTarget.print(indent1);
                this.mTarget.print("    \"AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println(".Exit_(context)\")");
                this.mTarget.println("#End If");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.println("#If TRACE Then");
            this.mTarget.print(indent1);
            this.mTarget.println("Trace.WriteLine( _");
            this.mTarget.print(indent1);
            this.mTarget.print("    \"ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\")");
            this.mTarget.println("#End If");
            this.mTarget.println();
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent1);
                this.mTarget.println("' No actions.");
            }
            indent2 = indent1;
        } else {
            this.mTarget.print(indent1);
            this.mTarget.println("context.ClearState()");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent1);
                this.mTarget.println("Try");
                indent2 = indent1 + "    ";
            } else {
                indent2 = indent1;
            }
            String tempIndent = this.mIndent;
            this.mIndent = indent2;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = tempIndent;
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent1);
                this.mTarget.println("Finally");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.println("#If TRACE Then");
            this.mTarget.print(indent2);
            this.mTarget.println("Trace.WriteLine( _");
            this.mTarget.print(indent2);
            this.mTarget.print("    \"EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print(".");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                ((SmcParameter)pit.next()).accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\")");
            this.mTarget.println("#End If");
            this.mTarget.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent2);
            this.mTarget.print("context.State = ");
            this.mTarget.println(fqEndStateName);
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.print("context.State = ");
                this.mTarget.println(fqEndStateName);
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println("#If TRACE Then");
                    this.mTarget.print(indent1);
                    this.mTarget.println("Trace.WriteLine( _");
                    this.mTarget.print(indent1);
                    this.mTarget.print("    \"BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(context)\")");
                    this.mTarget.println("#End If");
                    this.mTarget.println();
                }
                this.mTarget.print(indent2);
                this.mTarget.println("context.State.Entry(context)");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println("#If TRACE Then");
                    this.mTarget.print(indent1);
                    this.mTarget.println("Trace.WriteLine( _");
                    this.mTarget.print(indent1);
                    this.mTarget.print("    \"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println(".Entry(context)\")");
                    this.mTarget.println("#End If");
                    this.mTarget.println();
                }
            }
            this.mTarget.print(indent2);
            this.mTarget.print("context.PushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent1);
            this.mTarget.println("context.PopState()");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#If TRACE Then");
                this.mTarget.print(indent2);
                this.mTarget.println("Trace.WriteLine( _");
                this.mTarget.print(indent2);
                this.mTarget.print("    \"BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(context)\")");
                this.mTarget.println("#End If");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.State.Entry(context)");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println("#If TRACE Then");
                this.mTarget.print(indent2);
                this.mTarget.println("Trace.WriteLine( _");
                this.mTarget.print(indent2);
                this.mTarget.print("    \"AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(".Entry(context)\")");
                this.mTarget.println("#End If");
                this.mTarget.println();
            }
        }
        if (actions.size() > 0 && !this.mNoCatchFlag) {
            this.mTarget.print(indent1);
            this.mTarget.println("End Try");
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent1);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(")");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("context.EmptyStateStack()");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("ctxt.");
            }
            this.mTarget.print(name);
            if (action.isProperty()) {
                String arg = arguments.get(0);
                this.mTarget.print(" = ");
                this.mTarget.println(arg.substring(0, arg.indexOf(59)));
            } else {
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(")");
            }
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print("ByVal ");
        this.mTarget.print(parameter.getName());
        this.mTarget.print(" As ");
        this.mTarget.print(parameter.getType());
    }
}

