/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcTclGenerator
extends SmcCodeGenerator {
    private String mPkgScope;

    public SmcTclGenerator(SmcOptions options) {
        super(options, TargetLanguage.TCL.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String mapName;
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String rawSource = fsm.getSource();
        String packageName = fsm.getPackage();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        int index = 0;
        this.mTarget.println("# ex: set ro:");
        this.mTarget.println("# DO NOT EDIT.");
        this.mTarget.println("# generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("# from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String imp : fsm.getImports()) {
            this.mTarget.print("package require ");
            this.mTarget.print(imp);
            this.mTarget.println(";");
        }
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.print("namespace eval ");
            this.mTarget.print(packageName);
            this.mTarget.println(" {");
            this.mTarget.println();
            this.mIndent = "    ";
            this.mPkgScope = "::" + packageName + "::";
        } else {
            this.mIndent = "";
            this.mPkgScope = "";
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    inherit ::statemap::FSMContext;");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Member functions.");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    constructor {owner} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        ::statemap::FSMContext::constructor ${");
        this.mTarget.print(this.mPkgScope);
        this.mTarget.print(startState);
        this.mTarget.println("};");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    } {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        set _owner $owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            List<SmcParameter> params = trans.getParameters();
            if (trans.getName().equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public method ");
            this.mTarget.print(trans.getName());
            this.mTarget.print(" {");
            Iterator<SmcParameter> pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = " ";
            }
            this.mTarget.println("} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        [getState] ");
            this.mTarget.print(trans.getName());
            this.mTarget.print(" $this");
            for (SmcParameter smcParameter : params) {
                this.mTarget.print(" $");
                this.mTarget.print(smcParameter.getName());
            }
            this.mTarget.println(";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code ok;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public method getOwner {} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        return -code ok $_owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        if (this.mSerialFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method valueOf {id} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if {$id < $MIN_ID || $id > $MAX_ID} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            set retcode error;");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            set retval ");
            this.mTarget.println("\"$id is out of bounds\";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        } else {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            set retcode ok;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            set retval $_States($id);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code $retcode $retval;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method getStates {} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        set retval [list];");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("         foreach name [array names _States] {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            lappend retval $_States($name);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code ok ${retval};");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Member data.");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    private variable _owner;");
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    private common MIN_ID;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    private common MAX_ID;");
        }
        if (this.mSerialFlag || this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    private common _States;");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    inherit ::statemap::State;");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Member functions.");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    constructor {name id} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        ::statemap::State::constructor $name $id;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    } {}");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public method Entry {context} {};");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public method Exit {context} {};");
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public method ");
            this.mTarget.print(transName);
            this.mTarget.print(" {context");
            for (SmcParameter smcParameter : trans.getParameters()) {
                this.mTarget.print(" ");
                smcParameter.accept(this);
            }
            this.mTarget.println("} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        Default $context;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code ok;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public method Default {context} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        set transition [$context getTransition];");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        return -code error ");
        this.mTarget.print("\"Transition \\\"$transition\\\" ");
        this.mTarget.print("fell through to a ");
        this.mTarget.println("non-existent default definition.\";");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Static state declarations.");
        for (SmcMap map : maps) {
            mapName = map.getName();
            for (SmcState smcState : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("set ");
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(smcState.getInstanceName());
                this.mTarget.print(" ");
                if (packageName != null && packageName.length() > 0) {
                    this.mTarget.print(packageName);
                    this.mTarget.print("::");
                }
                this.mTarget.print("[");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(smcState.getClassName());
                this.mTarget.print(" #auto \"");
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(smcState.getClassName());
                this.mTarget.print("\" ");
                this.mTarget.print(index);
                this.mTarget.println("];");
                ++index;
            }
        }
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("# Static state transitions.");
            for (SmcMap map : maps) {
                SmcState defaultState = map.getDefaultState();
                List<SmcTransition> defaultTransitions = defaultState.getTransitions();
                List<SmcTransition> stateTransitions = new ArrayList<SmcTransition>();
                this.reflectTransitions(defaultState, stateTransitions, defaultTransitions, transitions);
                for (SmcState state : map.getStates()) {
                    stateTransitions = state.getTransitions();
                    this.reflectTransitions(state, stateTransitions, defaultTransitions, transitions);
                    ++index;
                }
            }
        }
        if (this.mSerialFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("set ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("::MIN_ID 0;");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("set ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("::MAX_ID ");
            this.mTarget.print(index - 1);
            this.mTarget.println(";");
        }
        if (this.mSerialFlag || this.mReflectFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("array set ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("::_States [list");
            index = 0;
            for (SmcMap map : maps) {
                mapName = map.getName();
                for (SmcState smcState : map.getStates()) {
                    this.mTarget.print(" ");
                    this.mTarget.print(index);
                    this.mTarget.print(" ${");
                    this.mTarget.print(mapName);
                    this.mTarget.print("::");
                    this.mTarget.print(smcState.getInstanceName());
                    this.mTarget.print("}");
                    ++index;
                }
            }
            this.mTarget.println("];");
        }
        if (packageName != null && packageName.length() > 0) {
            this.mTarget.println("}");
        }
        this.mTarget.println();
        this.mTarget.println("# Local variables:");
        this.mTarget.println("#  buffer-read-only: t");
        this.mTarget.println("# End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println(" {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Member data.");
        this.mTarget.println();
        for (SmcState state : states) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    public common ");
            this.mTarget.print(state.getClassName());
            this.mTarget.println(" \"\";");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default {");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    inherit ");
        this.mTarget.print(context);
        this.mTarget.println("State;");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("# Member functions.");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    constructor {name id} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("       ");
        this.mTarget.print(context);
        this.mTarget.println("State::constructor $name $id;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    } {}");
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method getTransitions {} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.println("return -code ok [array get _transitions];");
            this.mTarget.println("    }");
        }
        if (defaultState != null) {
            for (SmcTransition transition : definedDefaultTransitions) {
                transition.accept(this);
            }
        }
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("# Member data.");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public common _transitions;");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
    }

    @Override
    public void visit(SmcState state) {
        List<SmcAction> actions;
        String mapName = state.getMap().getName();
        String stateName = state.getClassName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.println(" {");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    inherit ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default;");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    constructor {name id} {");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default::constructor $name $id;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    } {}");
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method getTransitions {} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        ");
            this.mTarget.println("return -code ok [array get _transitions];");
            this.mTarget.println("    }");
        }
        if ((actions = state.getEntryActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method Entry {context} {");
            this.mTarget.println("        set ctxt [$context getOwner];");
            this.mTarget.println();
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code ok;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public method Exit {context} {");
            this.mTarget.println("        set ctxt [$context getOwner];");
            this.mTarget.println();
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        return -code ok;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("# Member data.");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    public common _transitions;");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public method ");
        this.mTarget.print(transName);
        this.mTarget.print(" {context");
        for (SmcParameter param : parameters) {
            this.mTarget.print(" ");
            param.accept(this);
        }
        this.mTarget.println("} {");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        set ctxt [$context getOwner];");
        }
        if (stateName.equals("Default")) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        set _transition \"");
            this.mTarget.print(transName);
            this.mTarget.println("\";");
        } else {
            this.mTarget.println();
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if {[$context getDebugFlag] != 0} {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            puts [$context getDebugStream] ");
            this.mTarget.print("\"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("::");
            this.mTarget.print(stateName);
            this.mTarget.println("\";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        }");
            }
            this.mTarget.println(" else {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            ");
            this.mTarget.print(mapName);
            this.mTarget.print("_Default ");
            this.mTarget.print(transName);
            this.mTarget.print(" $context");
            for (SmcParameter param : parameters) {
                this.mTarget.print(" ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(";");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
            this.mTarget.println();
        } else {
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        return -code ok;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator<SmcParameter> pit;
        List<SmcParameter> parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && !endStateName.contains("::")) {
            endStateName = mapName + "::" + endStateName;
        }
        if (!stateName.contains("::")) {
            stateName = mapName + "::" + stateName;
        }
        if (pushStateName != null && pushStateName.length() > 0 && !pushStateName.contains("::")) {
            pushStateName = mapName + "::" + pushStateName;
        }
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        if {");
                this.mTarget.print(condition);
                this.mTarget.println("} {");
            } else if (condition.length() > 0) {
                this.mTarget.print(" elseif {");
                this.mTarget.print(condition);
                this.mTarget.println("} {");
            } else {
                this.mTarget.println(" else {");
            }
            indent2 = this.mIndent + "            ";
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "        ";
        } else {
            indent2 = this.mIndent + "            ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        if {");
            this.mTarget.print(condition);
            this.mTarget.println("} {");
        }
        if (transType != SmcElement.TransType.TRANS_POP) {
            if (actions.isEmpty() && endStateName.length() != 0) {
                endStateName = "${" + this.mPkgScope + endStateName + "}";
            } else if (actions.size() > 0) {
                if (loopbackFlag) {
                    endStateName = "${EndStateName}";
                    this.mTarget.print(indent2);
                    this.mTarget.println("set EndStateName [$context getState];");
                } else {
                    endStateName = "${" + this.mPkgScope + endStateName + "}";
                }
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                this.mTarget.print(indent2);
                this.mTarget.print("    puts [$context getDebugStream] ");
                this.mTarget.print("\"BEFORE EXIT     : \\[");
                this.mTarget.print(stateName);
                this.mTarget.println("\\] Exit $context\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("[$context getState] Exit $context;");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                this.mTarget.print(indent2);
                this.mTarget.print("    puts [$context getDebugStream] ");
                this.mTarget.print("\"AFTER EXIT      : \\[");
                this.mTarget.print(stateName);
                this.mTarget.println("\\] Exit $context\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if {[$context getDebugFlag] != 0} {");
            this.mTarget.print(indent2);
            this.mTarget.print("    puts [$context getDebugStream] ");
            this.mTarget.print("\"ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print(" ");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                pit.next().accept(this);
                sep = ", ";
            }
            this.mTarget.println(")\";");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
            this.mTarget.println();
        }
        if (actions.isEmpty()) {
            indent3 = indent2;
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
            }
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("$context clearState;");
            if (!this.mNoCatchFlag) {
                indent3 = indent2 + "    ";
                this.mTarget.print(indent2);
                this.mTarget.println("if [catch {");
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (this.mDebugLevel >= 0) {
                parameters = transition.getParameters();
                this.mTarget.print(indent3);
                this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                this.mTarget.print(indent3);
                this.mTarget.print("    puts [$context getDebugStream] ");
                this.mTarget.print("\"EXIT TRANSITION : ");
                this.mTarget.print(stateName);
                this.mTarget.print(" ");
                this.mTarget.print(transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    pit.next().accept(this);
                    sep = ", ";
                }
                this.mTarget.println(")\";");
                this.mTarget.print(indent3);
                this.mTarget.println("}");
                this.mTarget.println();
            }
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("} result] {");
                if (transType == SmcElement.TransType.TRANS_SET) {
                    this.mTarget.print(indent3);
                    this.mTarget.print("$context setState ");
                    this.mTarget.print(endStateName);
                    this.mTarget.println(";");
                } else if (transType == SmcElement.TransType.TRANS_PUSH) {
                    this.mTarget.print(indent3);
                    this.mTarget.print("$context setState ");
                    this.mTarget.print(endStateName);
                    this.mTarget.println(";");
                    if (!loopbackFlag) {
                        if (this.mDebugLevel >= 1) {
                            this.mTarget.println();
                            this.mTarget.print(indent3);
                            this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                            this.mTarget.print(indent3);
                            this.mTarget.print("    puts [$context getDebugStream] ");
                            this.mTarget.print("\"BEFORE ENTRY    : \\[");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("\\] Entry $context\";");
                            this.mTarget.print(indent3);
                            this.mTarget.println("}");
                            this.mTarget.println();
                        }
                        this.mTarget.println();
                        this.mTarget.print(indent3);
                        this.mTarget.println("[$context getState] Entry $context;");
                        this.mTarget.println();
                        if (this.mDebugLevel >= 1) {
                            this.mTarget.println();
                            this.mTarget.print(indent3);
                            this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                            this.mTarget.print(indent3);
                            this.mTarget.print("    puts [$context getDebugStream] ");
                            this.mTarget.print("\"AFTER ENTRY     : \\[");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("\\] Exit $context\";");
                            this.mTarget.print(indent3);
                            this.mTarget.println("}");
                            this.mTarget.println();
                        }
                    }
                    this.mTarget.print(indent3);
                    this.mTarget.print("$context pushState ${");
                    this.mTarget.print(this.mPkgScope);
                    this.mTarget.print(pushStateName);
                    this.mTarget.println("};");
                } else if (transType == SmcElement.TransType.TRANS_POP) {
                    this.mTarget.print(indent3);
                    this.mTarget.println("$context popState;");
                }
                this.mTarget.print(indent3);
                this.mTarget.println("error $result;");
                this.mTarget.print(indent2);
                this.mTarget.println("} else {");
            }
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("$context setState ");
            this.mTarget.print(endStateName);
            this.mTarget.println(";");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent3);
                this.mTarget.print("$context setState ");
                this.mTarget.print(endStateName);
                this.mTarget.println(";");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println();
                    this.mTarget.print(indent3);
                    this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    puts [$context getDebugStream] ");
                    this.mTarget.print("\"BEFORE ENTRY    : \\[");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("\\] Exit $context\";");
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                    this.mTarget.println();
                }
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.println("[$context getState] Entry $context;");
                this.mTarget.println();
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println();
                    this.mTarget.print(indent3);
                    this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                    this.mTarget.print(indent3);
                    this.mTarget.print("    puts [$context getDebugStream] ");
                    this.mTarget.print("\"AFTER ENTRY     : \\[");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("\\] Entry $context\";");
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                    this.mTarget.println();
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("$context pushState ${");
            this.mTarget.print(this.mPkgScope);
            this.mTarget.print(pushStateName);
            this.mTarget.println("};");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("$context popState;");
        }
        if (actions.size() > 0 && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                this.mTarget.print(indent2);
                this.mTarget.print("    puts [$context getDebugStream] ");
                this.mTarget.print("\"BEFORE ENTRY    : \\[");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("\\] Entry $context\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("[$context getState] Entry $context;");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println("if {[$context getDebugFlag] != 0} {");
                this.mTarget.print(indent2);
                this.mTarget.print("    puts [$context getDebugStream] ");
                this.mTarget.print("\"AFTER ENTRY     : \\[");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("\\] Entry $context\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.println();
            this.mTarget.print(indent2);
            this.mTarget.print("$context ");
            this.mTarget.print(endStateName);
            if (popArgs.length() > 0) {
                this.mTarget.print(" ");
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(";");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("$context emptyStateStack;");
        } else {
            this.mTarget.print("$ctxt ");
            this.mTarget.print(name);
            for (String arg : action.getArguments()) {
                this.mTarget.print(" ");
                this.mTarget.print(arg);
            }
            this.mTarget.println(";");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        if (parameter.getType().equals("value")) {
            this.mTarget.print("$");
        }
        this.mTarget.print(parameter.getName());
    }

    private void reflectTransitions(SmcState state, List<SmcTransition> stateTransitions, List<SmcTransition> defaultTransitions, List<SmcTransition> allTransitions) {
        this.mTarget.print(this.mIndent);
        this.mTarget.print("array set ");
        this.mTarget.print(state.getMap().getName());
        this.mTarget.print("_");
        this.mTarget.print(state.getClassName());
        this.mTarget.print("::_transitions {");
        Iterator<SmcTransition> it = allTransitions.iterator();
        String sep = "";
        while (it.hasNext()) {
            SmcTransition transition = it.next();
            String transName = transition.getName();
            int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
            this.mTarget.print(sep);
            this.mTarget.print("\"");
            this.mTarget.print(transName);
            this.mTarget.print("\" ");
            this.mTarget.print(transDefinition);
            sep = " ";
        }
        this.mTarget.println("};");
    }
}

