/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcTableGenerator
extends SmcCodeGenerator {
    public SmcTableGenerator(SmcOptions options) {
        super(options, TargetLanguage.TABLE.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        this.mTarget.println("<html>");
        this.mTarget.println("  <head>");
        this.mTarget.print("    <title>");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println("</title>");
        this.mTarget.println("  </head>");
        this.mTarget.println();
        this.mTarget.println("  <body>");
        Iterator<SmcMap> mit = fsm.getMaps().iterator();
        String separator = "";
        while (mit.hasNext()) {
            this.mTarget.print(separator);
            mit.next().accept(this);
            separator = "    <p>\n";
        }
        this.mTarget.println("  </body>");
        this.mTarget.println("</html>");
    }

    @Override
    public void visit(SmcMap map) {
        List<SmcParameter> params;
        String transName;
        String mapName = map.getName();
        List<SmcTransition> transitions = map.getTransitions();
        int transitionCount = transitions.size() + 1;
        SmcTransition defaultTransition = null;
        this.mTarget.println("    <table align=center border=3 cellspacing=2 cellpadding=2>");
        this.mTarget.println("      <caption align=\"top\">");
        this.mTarget.print("        ");
        this.mTarget.print(mapName);
        this.mTarget.println(" Finite State Machine");
        this.mTarget.println("      </caption>");
        this.mTarget.println("      <tr>");
        this.mTarget.println("        <th rowspan=2>");
        this.mTarget.println("          State");
        this.mTarget.println("        </th>");
        this.mTarget.println("        <th colspan=2>");
        this.mTarget.println("          Actions");
        this.mTarget.println("        </th>");
        this.mTarget.print("        <th colspan=");
        this.mTarget.print(transitionCount);
        this.mTarget.println(">");
        this.mTarget.println("          Transition");
        this.mTarget.println("        </th>");
        this.mTarget.println("      </tr>");
        this.mTarget.println("      <tr>");
        this.mTarget.println("        <th>");
        this.mTarget.println("          Entry");
        this.mTarget.println("        </th>");
        this.mTarget.println("        <th>");
        this.mTarget.println("         Exit");
        this.mTarget.println("        </th>");
        for (SmcTransition transition : transitions) {
            transName = transition.getName();
            params = transition.getParameters();
            if (transName.equals("Default")) continue;
            this.mTarget.println("        <th>");
            this.mTarget.print("          ");
            this.mTarget.println(transName);
            if (!params.isEmpty()) {
                this.mTarget.println("          <br>");
                this.mTarget.print("          (");
                Iterator<SmcParameter> it = params.iterator();
                boolean firstFlag = true;
                while (it.hasNext()) {
                    if (!firstFlag) {
                        this.mTarget.println(',');
                        this.mTarget.println("          <br>");
                        this.mTarget.print("          ");
                    }
                    it.next().accept(this);
                    firstFlag = false;
                }
                this.mTarget.println(")");
            }
            this.mTarget.println("        </th>");
        }
        this.mTarget.println("        <th>");
        this.mTarget.println("          <b>Default</b>");
        this.mTarget.println("        </th>");
        this.mTarget.println("      </tr>");
        for (SmcState state : map.getStates()) {
            this.mTarget.println("      <tr>");
            state.accept(this);
            for (SmcTransition transition : transitions) {
                transName = transition.getName();
                params = transition.getParameters();
                if (transName.equals("Default")) {
                    defaultTransition = state.findTransition(transName, params);
                    continue;
                }
                this.mTarget.println("        <td>");
                transition = state.findTransition(transName, params);
                if (transition != null) {
                    this.mTarget.print("          <pre>");
                    transition.accept(this);
                    this.mTarget.println("          </pre>");
                }
                this.mTarget.println("        </td>");
            }
            this.mTarget.println("        <td>");
            if (defaultTransition != null) {
                this.mTarget.print("          <pre>");
                defaultTransition.accept(this);
                this.mTarget.println("          </pre>");
            }
            this.mTarget.println("        </td>");
            this.mTarget.println("      </tr>");
        }
        this.mTarget.println("    </table>");
    }

    @Override
    public void visit(SmcState state) {
        this.mTarget.println("        <td>");
        this.mTarget.print("          ");
        this.mTarget.println(state.getInstanceName());
        this.mTarget.println("        </td>");
        this.mTarget.println("        <td>");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println("          <pre>");
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("          </pre>");
        }
        this.mTarget.println("        </td>");
        this.mTarget.println("        <td>");
        actions = state.getExitActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println("          <pre>");
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("          </pre>");
        }
        this.mTarget.println("        </td>");
    }

    @Override
    public void visit(SmcTransition transition) {
        for (SmcGuard guard : transition.getGuards()) {
            this.mTarget.println();
            guard.accept(this);
        }
    }

    @Override
    public void visit(SmcGuard guard) {
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String mapName = map.getName();
        String stateName = state.getClassName();
        SmcElement.TransType transType = guard.getTransType();
        String condition = guard.getCondition();
        String endStateName = guard.getEndState();
        List<SmcAction> actions = guard.getActions();
        if (condition.length() > 0) {
            this.mTarget.print('[');
            this.mTarget.print(condition);
            this.mTarget.println(']');
        }
        if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print("  pop(");
            if (!endStateName.equals("nil") && endStateName.length() > 0) {
                String popArgs = guard.getPopArgs();
                this.mTarget.print(endStateName);
                if (popArgs.length() > 0) {
                    this.mTarget.print(", ");
                    this.mTarget.print(popArgs.trim());
                }
            }
            this.mTarget.println(")");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            this.mTarget.print("  push(");
            if (endStateName.equals("nil")) {
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(stateName);
            } else {
                this.mTarget.print(endStateName);
            }
            this.mTarget.println(")");
        } else {
            this.mTarget.print("  ");
            if (endStateName.equals("nil")) {
                this.mTarget.println(stateName);
            } else {
                this.mTarget.println(endStateName);
            }
        }
        if (actions.isEmpty()) {
            this.mTarget.println("  {}");
        } else {
            this.mTarget.println("  {");
            this.mIndent = "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mTarget.println("  }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        List<String> arguments = action.getArguments();
        this.mTarget.print(this.mIndent);
        this.mTarget.print(action.getName());
        if (action.isProperty()) {
            this.mTarget.print(" = ");
            this.mTarget.print(arguments.get(0).trim());
        } else {
            this.mTarget.print("(");
            Iterator<String> it = arguments.iterator();
            String sep = "";
            while (it.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(it.next().trim());
                sep = ", ";
            }
            this.mTarget.print(")");
        }
        this.mTarget.println(";");
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
    }
}

