/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcPerlGenerator
extends SmcCodeGenerator {
    public SmcPerlGenerator(SmcOptions options) {
        super(options, TargetLanguage.PERL.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String rawSource = fsm.getSource();
        String startState = fsm.getStartState();
        List<SmcMap> maps = fsm.getMaps();
        this.mTarget.println("# ex: set ro:");
        this.mTarget.println("# DO NOT EDIT.");
        this.mTarget.println("# generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("# from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "::" + context;
            startState = packageName + "::" + startState;
        }
        this.mTarget.println("use strict;");
        this.mTarget.println("use warnings;");
        this.mTarget.println();
        this.mTarget.println("use DFA::Statemap;");
        for (String imp : fsm.getImports()) {
            this.mTarget.print("use ");
            this.mTarget.print(imp);
            this.mTarget.println(";");
        }
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(context);
        this.mTarget.println("State;");
        this.mTarget.println("    use base qw(DFA::Statemap::State);");
        this.mTarget.println();
        this.mTarget.println("    use Carp;");
        this.mTarget.println();
        this.mTarget.println("    sub Entry {}");
        this.mTarget.println();
        this.mTarget.println("    sub Exit {}");
        this.mTarget.println();
        this.mTarget.println("    my %meth = (");
        List<SmcTransition> transitions = fsm.getTransitions();
        for (SmcTransition trans : transitions) {
            String transName = trans.getName();
            if (transName.equals("Default")) continue;
            this.mTarget.print("        ");
            this.mTarget.print(transName);
            this.mTarget.println(" => undef,");
        }
        this.mTarget.println("    );");
        this.mTarget.println();
        this.mTarget.println("    sub AUTOLOAD {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.println("        use vars qw( $AUTOLOAD );");
        this.mTarget.println("        (my $method = $AUTOLOAD) =~ s/^.*:://;");
        this.mTarget.println("        return unless exists $meth{$method};");
        this.mTarget.println("        $self->Default(@_);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    sub Default {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.println("        my ($fsm) = @_;");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if ($fsm->getDebugFlag()) {");
            this.mTarget.println("            my $fh = $fsm->getDebugStream();");
            this.mTarget.println("            print $fh \"TRANSITION   : Default\\n\";");
            this.mTarget.println("        }");
            this.mTarget.println("        confess \"TransitionUndefinedException\\n\",");
        } else {
            this.mTarget.println("        croak \"TransitionUndefinedException\\n\",");
        }
        this.mTarget.println("            \"State: \", $fsm->getState()->getName(),\"\\n\",");
        this.mTarget.println("            \"Transition: \", $fsm->getTransition(),\"\\n\";");
        this.mTarget.println("    }");
        for (SmcMap map : maps) {
            map.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(context);
        this.mTarget.println("_sm;");
        this.mTarget.println("    use base qw(DFA::Statemap::FSMContext);");
        this.mTarget.println();
        this.mTarget.println("    use Carp;");
        this.mTarget.println();
        this.mTarget.println("    sub new {");
        this.mTarget.println("        my $proto = shift;");
        this.mTarget.println("        my $class = ref($proto) || $proto;");
        this.mTarget.print("        my $self = $class->SUPER::new($");
        this.mTarget.print(startState);
        this.mTarget.println(");");
        this.mTarget.println("        my ($owner) = @_;");
        this.mTarget.println("        $self->{_owner} = $owner;");
        this.mTarget.println("        return $self;");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    sub AUTOLOAD {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.println("        use vars qw( $AUTOLOAD );");
        this.mTarget.println("        (my $method = $AUTOLOAD) =~ s/^.*:://;");
        this.mTarget.println("        return unless exists $meth{$method};");
        this.mTarget.println("        $self->{_transition} = $method;");
        this.mTarget.println("        $self->getState()->$method($self, @_);");
        this.mTarget.println("        $self->{_transition} = undef;");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    sub enterStartState {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.println("        $self->{_state}->Entry($self);");
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.println("    sub getOwner {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.println("        return $self->{_owner};");
        this.mTarget.println("    }");
        this.mTarget.println();
        if (this.mReflectFlag) {
            this.mTarget.println("    sub getStates {");
            this.mTarget.println("        my $self = shift;");
            this.mTarget.println("        return (");
            for (SmcMap map : maps) {
                String mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print("            $");
                    this.mTarget.print(mapName);
                    this.mTarget.print("::");
                    this.mTarget.print(state.getClassName());
                    this.mTarget.println(",");
                }
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
            this.mTarget.println();
            this.mTarget.println("    sub getTransitions {");
            this.mTarget.println("        my $self = shift;");
            this.mTarget.println("        return (");
            for (SmcTransition trans : transitions) {
                this.mTarget.print("            '");
                this.mTarget.print(trans.getName());
                this.mTarget.println("',");
            }
            this.mTarget.println("        );");
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println("1;");
        this.mTarget.println();
        this.mTarget.println("# Local variables:");
        this.mTarget.println("#  buffer-read-only: t");
        this.mTarget.println("# End:");
    }

    @Override
    public void visit(SmcMap map) {
        SmcState defaultState = map.getDefaultState();
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        List<SmcState> states = map.getStates();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
            context = packageName + "::" + context;
        }
        List<SmcTransition> definedDefaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(mapName);
        this.mTarget.println(";");
        this.mTarget.println();
        this.mTarget.println("use vars qw(");
        for (SmcState state : states) {
            this.mTarget.print("    $");
            this.mTarget.println(state.getInstanceName());
        }
        this.mTarget.println("    $Default");
        this.mTarget.println(");");
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default;");
        this.mTarget.print("    use base qw(");
        this.mTarget.print(context);
        this.mTarget.println("State);");
        for (SmcTransition transition : definedDefaultTransitions) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            this.mTarget.println();
            this.mTarget.println("    sub getTransitions {");
            this.mTarget.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = definedDefaultTransitions.contains(transition) ? 2 : 0;
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("        };");
            this.mTarget.println("    }");
        }
        for (SmcState state : states) {
            state.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(mapName);
        this.mTarget.println(';');
        this.mTarget.println();
        this.mTarget.println("sub BEGIN {");
        for (SmcState state : states) {
            this.mTarget.print("    $");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.print(" = ");
            this.mTarget.print(mapName);
            this.mTarget.print('_');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("->new('");
            this.mTarget.print(mapName);
            this.mTarget.print('.');
            this.mTarget.print(state.getClassName());
            this.mTarget.print("', ");
            this.mTarget.print(SmcMap.getNextStateId());
            this.mTarget.println(");");
        }
        this.mTarget.print("    $Default = ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default->new('");
        this.mTarget.print(mapName);
        this.mTarget.println(".Default', -1);");
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
        }
        this.mTarget.println();
        this.mTarget.print("package ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.println(";");
        this.mTarget.print("    use base qw(");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default);");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    sub Entry {");
            this.mTarget.println("        my $self = shift;");
            this.mTarget.println("        my ($fsm) = @_;");
            this.mTarget.println("        my $ctxt = $fsm->getOwner();");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.println();
            this.mTarget.println("    sub Exit {");
            this.mTarget.println("        my $self = shift;");
            this.mTarget.println("        my ($fsm) = @_;");
            this.mTarget.println("        my $ctxt = $fsm->getOwner();");
            indent2 = this.mIndent;
            this.mIndent = "        ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.println("    }");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        if (this.mReflectFlag) {
            List<SmcTransition> allTransitions = map.getFSM().getTransitions();
            List<SmcTransition> stateTransitions = state.getTransitions();
            SmcState defaultState = map.getDefaultState();
            List<SmcTransition> defaultTransitions = defaultState != null ? defaultState.getTransitions() : new ArrayList<SmcTransition>();
            this.mTarget.println();
            this.mTarget.println("    sub getTransitions {");
            this.mTarget.println("        return {");
            for (SmcTransition transition : allTransitions) {
                String transName = transition.getName();
                int transDefinition = stateTransitions.contains(transition) ? 1 : (defaultTransitions.contains(transition) ? 2 : 0);
                this.mTarget.print("            '");
                this.mTarget.print(transName);
                this.mTarget.print("' => ");
                this.mTarget.print(transDefinition);
                this.mTarget.println(",");
            }
            this.mTarget.println("        };");
            this.mTarget.println("    }");
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        List<SmcParameter> parameters = transition.getParameters();
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        SmcGuard nullGuard = null;
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
        }
        this.mTarget.println();
        this.mTarget.print("    sub ");
        this.mTarget.print(transName);
        this.mTarget.println(" {");
        this.mTarget.println("        my $self = shift;");
        this.mTarget.print("        my ($fsm");
        for (SmcParameter param : parameters) {
            this.mTarget.print(", ");
            this.mTarget.print(param.getName());
        }
        this.mTarget.println(") = @_;");
        if (transition.hasCtxtReference()) {
            this.mTarget.println("        my $ctxt = $fsm->getOwner();");
        }
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("        if ($fsm->getDebugFlag()) {");
            this.mTarget.println("            my $fh = $fsm->getDebugStream();");
            this.mTarget.print("            print $fh \"LEAVING STATE   : ");
            this.mTarget.print(mapName);
            this.mTarget.print("::");
            this.mTarget.print(stateName);
            this.mTarget.println("\\n\";");
            this.mTarget.println("        }");
        }
        this.mIndent = "    ";
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.println("        }");
            }
            this.mTarget.println("        else {");
            this.mTarget.print("            ");
            this.mTarget.print("$self->SUPER::");
            this.mTarget.print(transName);
            this.mTarget.print("($fsm");
            for (SmcParameter param : parameters) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.println("        }");
            this.mTarget.println();
        }
        this.mTarget.println("    }");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator<SmcParameter> pit;
        List<SmcParameter> parameters;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String packageName = map.getFSM().getPackage();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String transName = transition.getName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (packageName != null && packageName.length() > 0) {
            mapName = packageName + "::" + mapName;
        }
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil")) {
            if (!endStateName.contains("::")) {
                endStateName = mapName + "::" + endStateName;
            } else if (packageName != null && packageName.length() > 0) {
                endStateName = packageName + "::" + endStateName;
            }
        }
        if (!stateName.contains("::")) {
            stateName = mapName + "::" + stateName;
        }
        if (pushStateName != null && pushStateName.length() > 0) {
            if (!pushStateName.contains("::")) {
                pushStateName = mapName + "::" + pushStateName;
            } else if (packageName != null && packageName.length() > 0) {
                pushStateName = packageName + "::" + pushStateName;
            }
        }
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    elsif (");
                this.mTarget.print(condition);
                this.mTarget.println(") {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            indent2 = this.mIndent + "        ";
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(") {");
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (actions.size() > 0) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print("my $");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = $fsm->getState();");
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag()) {");
                this.mTarget.print(indent2);
                this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                this.mTarget.print(indent2);
                this.mTarget.print("    print $fh \"");
                this.mTarget.print("BEFORE EXIT     : ");
                this.mTarget.print(stateName);
                this.mTarget.println("->Exit($fsm)\\n\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->getState()->Exit($fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag()) {");
                this.mTarget.print(indent2);
                this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                this.mTarget.print(indent2);
                this.mTarget.print("    print $fh \"");
                this.mTarget.print("AFTER EXIT      : ");
                this.mTarget.print(stateName);
                this.mTarget.println("->Exit($fsm)\\n\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if ($fsm->getDebugFlag()) {");
            this.mTarget.print(indent2);
            this.mTarget.println("    my $fh = $fsm->getDebugStream();");
            this.mTarget.print(indent2);
            this.mTarget.print("    print $fh \"");
            this.mTarget.print("ENTER TRANSITION: ");
            this.mTarget.print(stateName);
            this.mTarget.print("->");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(pit.next().getName());
                sep = ", ";
            }
            this.mTarget.print(")");
            this.mTarget.println("\\n\";");
            this.mTarget.print(indent2);
            this.mTarget.println("}");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("# No actions.");
            }
            indent3 = indent2;
        } else {
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->clearState();");
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("eval {");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
            if (this.mDebugLevel >= 0) {
                parameters = transition.getParameters();
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag()) {");
                this.mTarget.print(indent2);
                this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                this.mTarget.print(indent2);
                this.mTarget.print("    print $fh \"");
                this.mTarget.print("EXIT TRANSITION : ");
                this.mTarget.print(stateName);
                this.mTarget.print("->");
                this.mTarget.print(transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(pit.next().getName());
                    sep = ", ";
                }
                this.mTarget.print(")");
                this.mTarget.println("\\n\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("};");
                this.mTarget.print(indent2);
                this.mTarget.println("warn $@ if ($@);");
            }
        }
        if (this.mDebugLevel >= 0) {
            parameters = transition.getParameters();
            this.mTarget.print(indent3);
            this.mTarget.println("if ($fsm->getDebugFlag()) {");
            this.mTarget.print(indent3);
            this.mTarget.println("    my $fh = $fsm->getDebugStream();");
            this.mTarget.print(indent2);
            this.mTarget.print("    print $fh \"");
            this.mTarget.print("EXIT TRANSITION : ");
            this.mTarget.print(stateName);
            this.mTarget.print("->");
            this.mTarget.print(transName);
            this.mTarget.print("(");
            pit = parameters.iterator();
            sep = "";
            while (pit.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(pit.next().getName());
                sep = ", ";
            }
            this.mTarget.print(")");
            this.mTarget.println("\\n\";");
            this.mTarget.print(indent3);
            this.mTarget.println("}");
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->setState($");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.print("$fsm->setState($");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if ($fsm->getDebugFlag()) {");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    print $fh \"");
                    this.mTarget.print("BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("->Entry($fsm)\\n\";");
                    this.mTarget.print(indent2);
                    this.mTarget.println("}");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("$fsm->getState()->Entry($fsm);");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.print(indent2);
                    this.mTarget.println("if ($fsm->getDebugFlag()) {");
                    this.mTarget.print(indent2);
                    this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                    this.mTarget.print(indent2);
                    this.mTarget.print("    print $fh \"");
                    this.mTarget.print("AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("->Entry($fsm)\\n\";");
                    this.mTarget.print(indent2);
                    this.mTarget.println("}");
                }
            }
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->pushState($");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->popState();");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag()) {");
                this.mTarget.print(indent2);
                this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                this.mTarget.print(indent2);
                this.mTarget.print("    print $fh \"");
                this.mTarget.print("BEFORE ENTRY    : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("->Entry($fsm)\\n\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("$fsm->getState()->Entry($fsm);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if ($fsm->getDebugFlag()) {");
                this.mTarget.print(indent2);
                this.mTarget.println("    my $fh = $fsm->getDebugStream();");
                this.mTarget.print(indent2);
                this.mTarget.print("    print $fh \"");
                this.mTarget.print("AFTER ENTRY     : ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println("->Entry($fsm)\\n\";");
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("$fsm->");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println(");");
            } else {
                this.mTarget.println(");");
            }
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        List<String> arguments = action.getArguments();
        if (action.isProperty()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("$ctxt->{");
            this.mTarget.print(name);
            this.mTarget.print("} = ");
            this.mTarget.print(arguments.get(0));
            this.mTarget.println(";");
        } else {
            this.mTarget.print(this.mIndent);
            if (action.isEmptyStateStack()) {
                this.mTarget.println("$fsm->emptyStateStack();");
            } else {
                this.mTarget.print("$ctxt->");
                this.mTarget.print(name);
                this.mTarget.print("(");
                Iterator<String> it = arguments.iterator();
                String sep = "";
                while (it.hasNext()) {
                    this.mTarget.print(sep);
                    this.mTarget.print(it.next());
                    sep = ", ";
                }
                this.mTarget.println(");");
            }
        }
    }
}

