/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;

public final class SmcHeaderObjCGenerator
extends SmcCodeGenerator {
    public SmcHeaderObjCGenerator(SmcOptions options) {
        super(options, "h");
    }

    @Override
    public void visit(SmcFSM fsm) {
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        this.mTarget.println();
        this.mTarget.println("#import \"statemap.h\"");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Forward declarations.");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("@class ");
            this.mTarget.print(mapName);
            this.mTarget.println(";");
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("@class ");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(";");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("@class ");
            this.mTarget.print(mapName);
            this.mTarget.println("_Default;");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@class ");
        this.mTarget.print(context);
        this.mTarget.println("State;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(";");
        this.printContextForwardDeclaration(context);
        for (String declaration : fsm.getDeclarations()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print(declaration);
            if (!declaration.endsWith(";")) {
                this.mTarget.print(";");
            }
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@interface ");
        this.mTarget.print(context);
        this.mTarget.println("State : SMCState");
        this.mTarget.println("{");
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Entry:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Exit:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context;");
        this.mTarget.println();
        List<SmcTransition> transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)");
            this.mTarget.print(trans.getName());
            this.mTarget.print(":(");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("*)context");
            for (SmcParameter param : trans.getParameters()) {
                this.mTarget.print(" :");
                param.accept(this);
            }
            this.mTarget.println(";");
        }
        this.mTarget.println("");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)Default:(");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("*)context;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@interface ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" : SMCFSMContext");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    __weak ");
        this.printContextType(context);
        this.mTarget.println(" _owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (id)initWithOwner:(");
        this.printContextType(context);
        this.mTarget.print(")");
        this.mTarget.println("owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (id)initWithOwner:(");
        this.printContextType(context);
        this.mTarget.print(")");
        this.mTarget.println("owner state:(SMCState*)aState;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (");
        this.printContextType(context);
        this.mTarget.println(")owner;");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (");
        this.mTarget.print(context);
        this.mTarget.println("State*)state;");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("- (void)enterStartState;");
        this.mTarget.println();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("- (void)");
            this.mTarget.print(trans.getName());
            Iterator<SmcParameter> pit = trans.getParameters().iterator();
            String separator = ":";
            while (pit.hasNext()) {
                SmcParameter param = pit.next();
                this.mTarget.print(separator);
                param.accept(this);
                separator = " :";
            }
            this.mTarget.println(";");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@interface ");
        this.mTarget.print(mapName);
        this.mTarget.println(" : NSObject");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.println("}");
        for (SmcState smcState : map.getStates()) {
            String stateName = smcState.getClassName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("+ (");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.print("*)");
            this.mTarget.print(stateName);
            this.mTarget.println(";");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@interface ");
        this.mTarget.print(mapName);
        this.mTarget.print("_Default : ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept(this);
            }
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
        for (SmcState smcState : map.getStates()) {
            smcState.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("@interface ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.print(" : ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.println("}");
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print(" -(void)Entry:(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("*)context;");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print(" -(void)Exit:(");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("*)context;");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("@end");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("- (void)");
        this.mTarget.print(transition.getName());
        this.mTarget.print(":(");
        this.mTarget.print(state.getMap().getFSM().getFsmClassName());
        this.mTarget.print("*)context");
        for (SmcParameter parameter : transition.getParameters()) {
            this.mTarget.print(" :");
            parameter.accept(this);
        }
        this.mTarget.println(";");
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print("(");
        this.mTarget.print(parameter.getType());
        this.mTarget.print(")");
        this.mTarget.print(parameter.getName());
    }

    private void printContextForwardDeclaration(String context) {
        this.mTarget.print(this.mIndent);
        if (this.mUseProtocolFlag) {
            this.mTarget.print("@protocol ");
        } else {
            this.mTarget.print("@class ");
        }
        this.mTarget.print(context);
        this.mTarget.println(";");
    }

    private void printContextType(String context) {
        if (this.mUseProtocolFlag) {
            this.mTarget.print("id<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        } else {
            this.mTarget.print(context);
            this.mTarget.print("*");
        }
    }
}

