/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;

public final class SmcHeaderGenerator
extends SmcCodeGenerator {
    public SmcHeaderGenerator(SmcOptions options) {
        super(options, "h");
    }

    @Override
    public void visit(SmcFSM fsm) {
        List<SmcParameter> params;
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        int packageDepth = 0;
        this.mTarget.println("//");
        this.mTarget.println("// ex: set ro:");
        this.mTarget.println("// DO NOT EDIT.");
        this.mTarget.println("// generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("// from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println("//");
        this.mTarget.println();
        String targetfileCaps = this.mTargetfileBase.replace('\\', '_');
        targetfileCaps = targetfileCaps.replace('/', '_');
        targetfileCaps = targetfileCaps.toUpperCase();
        this.mTarget.print("#ifndef ");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_H");
        this.mTarget.print("#define ");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_H");
        this.mTarget.println();
        if (!this.mNoStreamsFlag) {
            this.mTarget.println();
            this.mTarget.println("#define SMC_USES_IOSTREAMS");
        }
        if (this.mNoExceptionFlag) {
            this.mTarget.println();
            this.mTarget.println("#define SMC_NO_EXCEPTIONS");
        }
        if (this.mStateStackSize > 0) {
            this.mTarget.println();
            this.mTarget.println("#define SMC_FIXED_STACK");
            this.mTarget.println("#define SMC_STATE_STACK_SIZE " + this.mStateStackSize);
        }
        this.mTarget.println();
        this.mTarget.println("#include <statemap.h>");
        this.mTarget.println();
        this.mIndent = "";
        if (packageName != null && packageName.length() > 0) {
            Iterator<Object> tokenizer = new StringTokenizer(packageName, "::");
            while (((StringTokenizer)((Object)tokenizer)).hasMoreTokens()) {
                String token = ((StringTokenizer)((Object)tokenizer)).nextToken();
                ++packageDepth;
                this.mTarget.print(this.mIndent);
                this.mTarget.print("namespace ");
                this.mTarget.println(token);
                this.mTarget.print(this.mIndent);
                this.mTarget.println("{");
                this.mIndent = this.mIndent + "    ";
            }
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Forward declarations.");
        for (SmcMap map : fsm.getMaps()) {
            String mapName = map.getName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("class ");
            this.mTarget.print(mapName);
            this.mTarget.println(";");
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("class ");
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.println(";");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("class ");
            this.mTarget.print(mapName);
            this.mTarget.println("_Default;");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State;");
        this.mTarget.print(this.mIndent);
        if (this.mCRTPFlag) {
            this.mTarget.print("template<typename DERIVED> ");
        }
        this.mTarget.print("class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(";");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println(";");
        for (String declaration : fsm.getDeclarations()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print(declaration);
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(context);
        this.mTarget.println("State :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public statemap::State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("public:");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print(context);
        this.mTarget.println("State(const char * const name, const int stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    : statemap::State(name, stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {};");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    virtual void Entry(");
        this.mTarget.print(fsmClassName);
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        }
        this.mTarget.println("&) {};");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    virtual void Exit(");
        this.mTarget.print(fsmClassName);
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        }
        this.mTarget.println("&) {};");
        this.mTarget.println();
        List<SmcTransition> transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    virtual void ");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.print("& context");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(");");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("protected:");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    virtual void Default(");
        this.mTarget.print(fsmClassName);
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        }
        this.mTarget.println("& context);");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("};");
        this.mTarget.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept(this);
        }
        this.mTarget.print(this.mIndent);
        if (this.mCRTPFlag) {
            this.mTarget.println("template<typename DERIVED>");
        }
        this.mTarget.print("class ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" :");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    public statemap::FSMContext");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("public:");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    explicit ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(");
        if (!this.mCRTPFlag) {
            this.mTarget.print(context);
            this.mTarget.print("& owner");
        }
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    : FSMContext(");
        this.mTarget.print(fsm.getStartState());
        this.mTarget.print(")");
        if (!this.mCRTPFlag) {
            this.mTarget.println(",");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("      _owner(owner)");
        } else {
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {};");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("(");
        if (!this.mCRTPFlag) {
            this.mTarget.print(context);
            this.mTarget.print("& owner, ");
        }
        this.mTarget.println("const statemap::State& state)");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    : FSMContext(state)");
        if (!this.mCRTPFlag) {
            this.mTarget.println(",");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("      _owner(owner)");
        } else {
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {};");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    virtual void enterStartState()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        getState().Entry(*this);");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("        return;");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    }");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    inline ");
        this.mTarget.print(context);
        this.mTarget.println("& getOwner()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        this.mTarget.print(this.mIndent);
        if (this.mCRTPFlag) {
            this.mTarget.println("        return (*static_cast<DERIVED*>(this));");
        } else {
            this.mTarget.println("        return (_owner);");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    };");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    inline ");
        this.mTarget.print(context);
        this.mTarget.println("State& getState()");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {");
        if (!this.mNoExceptionFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        if (_state == NULL)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("            throw ");
            this.mTarget.println("statemap::StateUndefinedException();");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        }");
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        assert(_state != NULL);");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("        return ");
        this.mTarget.print(this.mCastType);
        this.mTarget.print("<");
        this.mTarget.print(context);
        this.mTarget.println("State&>(*_state);");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    };");
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    inline void ");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(");
            params = trans.getParameters();
            Iterator<SmcParameter> pit = params.iterator();
            String separator = "";
            while (pit.hasNext()) {
                this.mTarget.print(separator);
                pit.next().accept(this);
                separator = ", ";
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            if (this.mDebugLevel >= 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        setTransition(\"");
                this.mTarget.print(trans.getName());
                this.mTarget.println("\");");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.print("        getState().");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(*this");
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            if (this.mDebugLevel >= 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        setTransition(NULL);");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    };");
        }
        if (this.mSerialFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    static ");
            this.mTarget.print(context);
            this.mTarget.println("State& valueOf(int stateId);");
        }
        if (!this.mCRTPFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("private:");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println("& _owner;");
        }
        if (this.mSerialFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("private:");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    const static int MIN_INDEX;");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    const static int MAX_INDEX;");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    static ");
            this.mTarget.print(context);
            this.mTarget.println("State* _States[];");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("};");
        if (packageName != null && packageName.length() > 0) {
            for (int i = packageDepth - 1; i >= 0; --i) {
                for (int j = 0; j < i; ++j) {
                    this.mTarget.print("    ");
                }
                this.mTarget.println("}");
                this.mTarget.println();
            }
        } else {
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print("#endif // ");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_H");
        this.mTarget.println();
        this.mTarget.println("//");
        this.mTarget.println("// Local variables:");
        this.mTarget.println("//  buffer-read-only: t");
        this.mTarget.println("// End:");
        this.mTarget.println("//");
    }

    @Override
    public void visit(SmcMap map) {
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.println(mapName);
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("public:");
        this.mTarget.println();
        for (SmcState smcState : map.getStates()) {
            String stateName = smcState.getClassName();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    static ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(stateName);
            this.mTarget.print(" ");
            this.mTarget.print(stateName);
            this.mTarget.println(";");
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("};");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public ");
        this.mTarget.print(context);
        this.mTarget.println("State");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("public:");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default(const char * const name, const int stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    : ");
        this.mTarget.print(context);
        this.mTarget.println("State(name, stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {};");
        this.mTarget.println();
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition transition : defaultState.getTransitions()) {
                transition.accept(this);
            }
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("};");
        this.mTarget.println();
        for (SmcState smcState : map.getStates()) {
            smcState.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("class ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.println(" :");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    public ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("public:");
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    ");
        this.mTarget.print(mapName);
        this.mTarget.print('_');
        this.mTarget.print(stateName);
        this.mTarget.println("(const char * const name, const int stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    : ");
        this.mTarget.print(mapName);
        this.mTarget.println("_Default(name, stateId)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("    {};");
        this.mTarget.println();
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    virtual void Entry(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("&);");
        }
        if ((actions = state.getExitActions()) != null && actions.size() > 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    virtual void Exit(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("&);");
        }
        for (SmcTransition transition : state.getTransitions()) {
            transition.accept(this);
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("};");
        this.mTarget.println();
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("    virtual void ");
        this.mTarget.print(transition.getName());
        this.mTarget.print("(");
        this.mTarget.print(state.getMap().getFSM().getFsmClassName());
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(state.getMap().getFSM().getContext());
            this.mTarget.print(">");
        }
        this.mTarget.print("& context");
        for (SmcParameter param : transition.getParameters()) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println(");");
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(" ");
        this.mTarget.print(parameter.getName());
    }
}

