/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.List;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;

public final class SmcHeaderCGenerator
extends SmcCodeGenerator {
    public SmcHeaderCGenerator(SmcOptions options) {
        super(options, "h");
    }

    @Override
    public void visit(SmcFSM fsm) {
        List<SmcParameter> params;
        String packageName = fsm.getPackage();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        String startStateName = fsm.getStartState();
        this.mTarget.println("/*");
        this.mTarget.println(" * ex: set ro:");
        this.mTarget.println(" * DO NOT EDIT.");
        this.mTarget.println(" * generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print(" * from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println(" */");
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
            fsmClassName = packageName + "_" + fsmClassName;
            startStateName = packageName + "_" + startStateName;
        }
        String targetfileCaps = this.mTargetfileBase.replace('\\', '_');
        targetfileCaps = targetfileCaps.replace('/', '_');
        targetfileCaps = targetfileCaps.toUpperCase();
        this.mTarget.print("#ifndef _");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_H");
        this.mTarget.print("#define _");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_H");
        this.mTarget.println();
        this.mTarget.println("#include <assert.h>");
        if (this.mDebugLevel >= 0) {
            this.mTarget.println("#define STATEMAP_DEBUG 1");
        }
        this.mTarget.println("#include <statemap.h>");
        this.mTarget.println();
        for (String declaration : fsm.getDeclarations()) {
            this.mTarget.print(declaration);
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print("struct ");
        this.mTarget.print(context);
        this.mTarget.println(";");
        this.mTarget.print("struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(";");
        this.mTarget.println();
        this.mTarget.print("struct ");
        this.mTarget.print(context);
        this.mTarget.println("State {");
        if (fsm.hasEntryActions()) {
            this.mTarget.print("    void(*Entry)(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm);");
        }
        if (fsm.hasExitActions()) {
            this.mTarget.print("    void(*Exit)(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm);");
        }
        List<SmcTransition> transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print("    void(*");
            this.mTarget.print(trans.getName());
            this.mTarget.print(")(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" *const fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getType());
                this.mTarget.print(" ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
        }
        this.mTarget.print("    void(*Default)(struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" *const fsm);");
        this.mTarget.println("    STATE_MEMBERS");
        this.mTarget.println("};");
        this.mTarget.println();
        for (SmcMap map : fsm.getMaps()) {
            map.accept(this);
        }
        this.mTarget.println();
        this.mTarget.print("struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println(" {");
        this.mTarget.print("    struct ");
        this.mTarget.print(context);
        this.mTarget.println(" *_owner;");
        this.mTarget.print("    FSM_MEMBERS(");
        this.mTarget.print(context);
        this.mTarget.println(")");
        this.mTarget.println("};");
        this.mTarget.println();
        int index = startStateName.indexOf("::");
        String cState = index >= 0 ? startStateName.substring(0, index) + "_" + startStateName.substring(index + 2) : startStateName;
        this.mTarget.print("#ifdef NO_");
        this.mTarget.print(targetfileCaps);
        this.mTarget.println("_MACRO");
        this.mTarget.print("extern void ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print("_Init");
        this.mTarget.print("(struct ");
        this.mTarget.print(fsmClassName);
        this.mTarget.print(" *const fsm, struct ");
        this.mTarget.print(context);
        this.mTarget.println(" *const owner);");
        if (fsm.hasEntryActions()) {
            this.mTarget.print("extern void ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_EnterStartState(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println(" *const fsm);");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.print("extern void ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(struct ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print(" *const fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getType());
                this.mTarget.print(" ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
        }
        this.mTarget.println("#else");
        this.mTarget.print("#define ");
        this.mTarget.print(fsmClassName);
        this.mTarget.println("_Init(fsm, owner) \\");
        this.mTarget.print("    FSM_INIT((fsm), &");
        this.mTarget.print(cState);
        this.mTarget.println("); \\");
        this.mTarget.println("    (fsm)->_owner = (owner)");
        if (fsm.hasEntryActions()) {
            this.mTarget.println();
            this.mTarget.println("#define ENTRY_STATE(state) \\");
            this.mTarget.println("    if ((state)->Entry != NULL) { \\");
            this.mTarget.println("        (state)->Entry(fsm); \\");
            this.mTarget.println("    }");
        }
        if (fsm.hasExitActions()) {
            this.mTarget.println();
            this.mTarget.println("#define EXIT_STATE(state) \\");
            this.mTarget.println("    if ((state)->Exit != NULL) { \\");
            this.mTarget.println("        (state)->Exit(fsm); \\");
            this.mTarget.println("    }");
        }
        if (fsm.hasEntryActions()) {
            this.mTarget.println();
            this.mTarget.print("#define ");
            this.mTarget.print(fsmClassName);
            this.mTarget.println("_EnterStartState(fsm) \\");
            this.mTarget.println("    ENTRY_STATE(getState(fsm))");
        }
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print("#define ");
            this.mTarget.print(fsmClassName);
            this.mTarget.print("_");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(fsm");
            params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(") \\");
            this.mTarget.println("    assert(getState(fsm) != NULL); \\");
            this.mTarget.print("    setTransition((fsm), \"");
            this.mTarget.print(trans.getName());
            this.mTarget.println("\"); \\");
            this.mTarget.print("    getState(fsm)->");
            this.mTarget.print(trans.getName());
            this.mTarget.print("((fsm)");
            for (SmcParameter param : params) {
                this.mTarget.print(", (");
                this.mTarget.print(param.getName());
                this.mTarget.print(")");
            }
            this.mTarget.println("); \\");
            this.mTarget.println("    setTransition((fsm), NULL)");
        }
        this.mTarget.println("#endif");
        this.mTarget.println();
        this.mTarget.println("#endif");
        this.mTarget.println();
        this.mTarget.println("/*");
        this.mTarget.println(" * Local variables:");
        this.mTarget.println(" *  buffer-read-only: t");
        this.mTarget.println(" * End:");
        this.mTarget.println(" */");
    }

    @Override
    public void visit(SmcMap map) {
        String packageName = map.getFSM().getPackage();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        if (packageName != null && packageName.length() > 0) {
            context = packageName + "_" + context;
        }
        for (SmcState state : map.getStates()) {
            this.mTarget.print("extern const struct ");
            this.mTarget.print(context);
            this.mTarget.print("State ");
            if (packageName != null && packageName.length() > 0) {
                this.mTarget.print(packageName);
                this.mTarget.print("_");
            }
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(state.getInstanceName());
            this.mTarget.println(";");
        }
    }
}

